<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteExamResultReportSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_exam_result_report_settings', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->boolean('site_address_show_status')->default(false);
            $table->boolean('merit_list_show_status')->default(false);
            $table->boolean('std_image_show_status')->default(false);
            $table->boolean('qrcode_show_status')->default(false);
            $table->boolean('academic_perform_show_status')->default(false);
            $table->boolean('head_signature_show_status')->default(false);
            $table->string('left_designation')->nullable();
            $table->string('center_designation')->nullable();
            $table->string('right_designation')->nullable();
            $table->string('sheet_no')->nullable();
            $table->integer('site_id');
            $table->integer('academic_group_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_exam_result_report_settings');
    }
}
