<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteStudentRollCreateRangesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_student_roll_create_ranges', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('site_student_admission_declare_id');
            $table->integer('academic_shift_id')->nullable();
            $table->integer('academic_class_id')->nullable();
            $table->integer('academic_class_group_id')->nullable();
            $table->integer('academic_section_id')->nullable();
            $table->string('start_roll')->nullable();
            $table->string('end_roll')->nullable();
            $table->integer('site_id');
            $table->integer('academic_group_id')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_student_roll_create_ranges');
    }
}
