<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteStudentCombineResultDetailsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_student_combine_result_details', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('student_history_id')->nullable();
            $table->integer('academic_result_combine_type_id')->nullable();
            $table->double('gpa')->nullable();
            $table->string('total_marks')->nullable();
            $table->string('average_total_marks')->nullable();
            $table->string('average_marks')->nullable();
            $table->string('grade')->nullable();
            $table->integer('fail_subject_count')->nullable();
            $table->string('final_point_without_optional')->nullable();
            $table->string('final_grade_without_optional')->nullable();
            $table->boolean('combine_subject_present')->nullable();
            $table->longText('result_detail')->nullable();
            $table->text('table_header')->nullable();
            $table->boolean('status')->default(true);
            $table->boolean('result_employee_publish_status')->default(false);
            $table->boolean('result_student_publish_status')->default(false);
            $table->boolean('result_public_publish_status')->default(false);
            $table->boolean('result_public_full_publish_status')->default(false);
            $table->integer('site_id');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_student_combine_result_details');
    }
}
