<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteGroupResultPermissionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_group_result_permissions', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('site_group_id');
            $table->integer('site_id');
            $table->integer('academic_group_id');
            $table->integer('academic_year_id');
            $table->integer('academic_class_id');
            $table->integer('academic_result_primary_type_id');
            $table->boolean('site_result_permission_status')->default(0);
            $table->boolean('employee_result_permission_status')->default(0);
            $table->boolean('student_result_permission_status')->default(0);
            $table->boolean('public_result_permission_status')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_group_result_permissions');
    }
}
