<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class UpdateAuthorsTableAddColumnsAndRenameBirthColumn extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('authors', function (Blueprint $table) {
            // Rename the existing column
            $table->renameColumn('date_of_birth', 'birthDate');

            // Add new columns
            $table->string('firstName')->nullable();
            $table->string('lastName')->nullable();
            $table->enum('gender', ['male', 'female', 'other'])->nullable();
            $table->string('nationality')->nullable();
            $table->string('email')->unique()->nullable();
            $table->text('biography')->nullable();
            $table->string('genres')->nullable();


        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
         Schema::table('authors', function (Blueprint $table) {
            // Reverse changes
            $table->renameColumn('birthDate', 'date_of_birth');
            $table->dropColumn([
                'firstName',
                'lastName',
                'gender',
                'nationality',
                'email',
                'biography',
                'genres'
            ]);
            $table->dropTimestamps();
        });
    }
}
