<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreatePrimaryResultConditionSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('primary_result_condition_settings', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('academic_version_id');
            $table->integer('academic_year_id');
            $table->integer('academic_class_id');
            $table->integer('academic_result_primary_type_id');
            $table->string('math_condition')->default('ceil');
            $table->string('combine_subject_result_condition')->default('individually_pass_fail');
            $table->string('total_percentage_condition')->default('total_mark_wise_percentage');
            $table->boolean('combine_subject_show_in_table_bellow_status')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('primary_result_condition_settings');
    }
}
