<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

class CreateSiteProgressSettingsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('site_progress_settings', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->integer('academic_group_id');
            $table->integer('site_id');
            $table->integer('academic_year_id');
            $table->integer('academic_class_id');
            $table->integer('progress_id');
            $table->boolean('status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('site_progress_settings');
    }
}
