import Datepicker from "vuejs-datepicker";

export default {

    components: { Datepicker },
    data() {
        return {
            loadingPage: false,
            loadingClass: false,
            RegistrationDeclareList: [],
            declared_time_present: null,
            site_name: null,
            site_logo: null,
            oldStudentInformationAddShow: false,


            guardian_information_add: false,
            address_information_add: false,
            communication_information_add: false,
            previous_institute_information_add: false,
            local_guardian_detail_information_add: false,
            student_registration_number_box_show: false,

            dataloadingImage: false,
            editMode: false,
            //  FixedDataShowHide:true,
            id: "",
            site_info_id: "",
            academic_department_id: null,
            departmentList: [],

            unique_code: null,
            dataNotFount: false,
            dataApprovedShow: false,

            AcademicVersionList: [],
            academic_version_id: null,

            getGenderList: [],
            ReligionList: [],
            AcademicSectionList: [],
            academic_section_id: null,


            academic_class_group_id: null,
            AcademicClassGroupList: [],


            AcademicGroupList: [],
            academic_group_id: null,

            academic_year_id: null,
            AcademicYearList: [],

            academic_session_id: null,
            AcademicSessionList: [],

            academic_shift_id: null,
            AcademicShiftList: [],

            academic_class_id: null,
            AcademicClassList: [],

            FatherOccupationList: [],
            MotherOccupationList: [],
            getQuataList: [],

            getStudentTypeList: [],
            academic_student_type_id: null,

            ReligionSubjectList: [],
            OptionalSubjectList: [],
            MarkinglessSubjectList: [],
            CompulsorySubjectList: [],
            getResidenceList: [],

            academic_student_category_id: null,
            AcademicStudentCategoryList: [],

            admission_type_key: false,


            // present address
            PresentCountryList: [],
            PresentDivisionList: [],
            PresentDistrictList: [],
            PresentThanaList: [],

            // Permanent address
            PermanentCountryList: [],
            PermanentDivisionList: [],
            PermanentDistrictList: [],
            PermanentThanaList: [],



            exAcademicYearList: [],
            exAcademicShiftList: [],
            exdepartmentList: [],
            exAcademicClassList: [],
            exAcademicClassGroupList: [],
            exAcademicSectionList: [],
            exAcademicSessionList: [],
            OldStudentInfoShowHide: false,


            presentDivisionLoadingImg: false,
            presentDistrictLoadingImg: false,
            presentThanaLoadingImg: false,
            gettingStudentForEditImg: false,

            permanentDivisionLoadingImg: false,
            permanentDistrictLoadingImg: false,
            permanentThanaLoadingImg: false,

            sameAddressSelect: false,
            GurdianInfoShowHide: false,
            PrimaryInfoShowHide: false,

            getBloodGroupList: [],

            getStudentAdmissionTypeList: [],
            academic_student_admission_type_id: null,

            AddressShowHide: false,
            CommunicationInfoShowHide: false,
            PreviousInfoHideShow: false,
            LocalGurdianHideShow: false,
            whenYearClassSelect: false,
            FundamentalInfoShowHide: true,
            date_of_birth: "",

            academic_version_name: "",
            academic_year_name: "",
            academic_session_name: "",
            academic_shift_name: "",
            academic_class_name: "",
            academic_group_name: "",
            academic_section_name: "",
            academic_category_name: "",
            academic_admission_type_name: "",
            academic_student_type_name: "",
            academic_department_name: "",

            student_for_edit: null,
            student_for_edit: "",
            RelationList: [],
            whenEditClick: false,

            edit_academic_version_id: null,
            edit_academic_year_id: null,
            edit_academic_shift_id: null,
            edit_academic_class_id: null,
            edit_academic_department_id: null,
            edit_academic_class_group_id: null,
            edit_academic_section_id: null,
            edit_academic_student_category_id: null,
            edit_academic_session_id: null,
            edit_academic_student_type_id: null,
            edit_academic_student_admission_type_id: null,

            codeMessageName: null,
            codeMessageCode: null,
            codeMessageShow: false,

            loadingStudentInsert: false,

            form: new Form({
                id: "",

                status: "",
                site_student_registration_application_id: null,

                gender_id: null,
                academic_residence_id: null,
                religion_id: null,
                blood_group_id: null,
                student_image: "",


                present_country_id: null,
                present_division_id: null,
                present_district_id: null,
                present_thana_id: null,
                present_address: "",

                permanent_country_id: null,
                permanent_division_id: null,
                permanent_district_id: null,
                permanent_thana_id: null,
                permanent_address: "",

                first_name: "",
                last_name: "",
                name_native_language: "",
                student_roll_number: "",
                father_name: "",
                mother_name: "",
                date_of_birth: "",
                student_contact_number: "",
                registration_no: "",
                board_registration_number: "",
                academic_quata_id: null,

                religion_subject_id: "",

                father_occupation_id: null,
                father_yearly_income: "",
                father_contact_number: "",
                father_email: "",


                mother_occupation_id: null,
                mother_yearly_income: "",
                mother_contact_number: "",
                mother_email: "",

                birth_certificate_no: "",
                nid_number: "",
                student_mobile_number: "",
                email: "",
                passport_no: "",
                emergency_contact: "",

                previous_institute_name: "",
                previous_academic_class_id: null,
                previous_academic_department_id: null,
                previous_gpa: "",
                previous_exam_mark: "",
                previous_institute_location: "",
                tc_number: "",
                tc_date: "",


                ex_academic_year_id: null,
                ex_academic_shift_id: null,
                ex_academic_class_id: null,
                ex_academic_department_id: null,
                ex_academic_class_group_id: null,
                ex_academic_section_id: null,
                AcademicSectionList: [],
                ex_academic_session_id: null,
                ex_roll_number: null,
                id_card_code: null,

                local_guardian_name: "",
                guardian_student_relation_id: null,
                local_gurdian_mobile: "",
                local_gurdian_address: "",
                local_gurdian_email: "",

                compulsory_subject_ids: [],
                optional_subject_ids: [],
                selective_markingless_subject_ids: [],
                user_id: ""
            }),
            ssct: new Form({
                id: ""
            })
        };
    },
    methods: {



        createStudentInfo() {
            this.form.academic_group_id = this.academic_group_id;
            this.form.academic_version_id = this.academic_version_id;
            this.form.academic_year_id = this.academic_year_id;
            this.form.academic_shift_id = this.academic_shift_id;
            this.form.academic_class_id = this.academic_class_id;
            this.form.academic_department_id = this.academic_department_id;
            this.form.academic_class_group_id = this.academic_class_group_id;
            this.form.academic_section_id = this.academic_section_id;
            this.form.academic_student_category_id = this.academic_student_category_id;
            this.form.academic_session_id = this.academic_session_id;
            this.form.academic_student_type_id = this.academic_student_type_id;
            this.form.academic_student_admission_type_id = this.academic_student_admission_type_id;


            this.form.AcademicSectionList = this.AcademicSectionList;
            this.form.AcademicClassGroupList = this.AcademicClassGroupList;


            this.form.AcademicSessionList = this.AcademicSessionList;
            this.form.ReligionSubjectList = this.ReligionSubjectList;
            // console.log(this.form);

            this.codeMessageShow = false;

            this.loadingStudentInsert = true;

            this.form
                .post("/student-application/create-student-entry-application")
                .then(({ data }) => {
                    // console.log(data);
                    swal(
                        this.editMode ? "Update" : "Save",
                        'Congrats, <b>' + data.message[0] + '</b>. Your Unique Code is <b>(' + data.message[1] + ')</b>' +
                        ' Please Save this code for your next activity.',
                        "success"
                    );

                    this.codeMessageName = data.message[0];
                    this.codeMessageCode = data.message[1];
                    this.codeMessageShow = true;

                    this.form.reset();
                    this.editMode = false;
                    this.GurdianInfoShowHide = false;
                    this.CommunicationInfoShowHide = false;
                    this.PreviousInfoHideShow = false;
                    this.LocalGurdianHideShow = false;
                    this.AddressShowHide = false;
                    this.blankWithOutForm();

                    this.whenYearClassSelect = false;
                    this.FundamentalInfoShowHide = true;
                    this.getAcademicGroupList();
                    this.unique_code = null;



                })
                .catch(error => {
                    // console.log(error.response.status);
                    let status = error.response.status;

                    if (status == "412") {
                        swal("Error!", error.response.data.message, "error");
                        return;
                    }
                    toast({
                        type: "warning",
                        title: error.response.data.message
                    });
                })
                .finally(() => {
                    this.loadingStudentInsert = false;
                });
        },




        UpdateStudentInfo() {
            this.form.academic_group_id = this.academic_group_id;
            this.form.academic_version_id = this.academic_version_id;
            this.form.academic_year_id = this.academic_year_id;
            this.form.academic_shift_id = this.academic_shift_id;
            this.form.academic_class_id = this.academic_class_id;
            this.form.academic_department_id = this.academic_department_id;
            this.form.academic_class_group_id = this.academic_class_group_id;
            this.form.academic_section_id = this.academic_section_id;

            this.form.AcademicSectionList = this.AcademicSectionList;
            this.form.AcademicClassGroupList = this.AcademicClassGroupList;


            this.form.academic_student_category_id = this.academic_student_category_id;
            this.form.academic_session_id = this.academic_session_id;
            this.form.academic_student_type_id = this.academic_student_type_id;
            this.form.academic_student_admission_type_id = this.academic_student_admission_type_id;

            this.form.AcademicSessionList = this.AcademicSessionList;
            this.form.ReligionSubjectList = this.ReligionSubjectList;
            // console.log(this.form);


            this.loadingStudentInsert = true;

            this.form
                .post("/student-application/update-student-entry-application")
                .then(({ data }) => {
                    // console.log(data);
                    swal(
                        this.editMode ? "Update" : "Save",
                        data.message,
                        "success"
                    );

                    this.form.reset();
                    this.editMode = false;
                    this.GurdianInfoShowHide = false;
                    this.CommunicationInfoShowHide = false;
                    this.PreviousInfoHideShow = false;
                    this.LocalGurdianHideShow = false;
                    this.AddressShowHide = false;
                    this.blankWithOutForm();

                    this.whenYearClassSelect = false;
                    this.OldStudentInfoShowHide = false;
                    this.FundamentalInfoShowHide = true;
                    this.getAcademicGroupList();
                    this.unique_code = null;
                })
                .catch(error => {
                    // console.log(error.response.status);
                    let status = error.response.status;

                    if (status == "412") {
                        swal("Error!", error.response.data.message, "error");
                        return;
                    }
                    toast({
                        type: "warning",
                        title: error.response.data.message
                    });
                })
                .finally(() => {
                    this.loadingStudentInsert = false;
                });
        },



        async getStudentDetail() {


            if (!this.unique_code) {

                this.dataNotFount = false;
                this.dataApprovedShow = false;
                this.editMode = false;
                this.getAcademicGroupList();
                return;
            }



            this.editMode = true;
            this.form.site_student_registration_application_id = null;
            this.blankWithOutForm();
            this.form.reset();

            axios
                .get(
                    "/student-application/global-get-applied-student-detail-for-edit/" +
                    this.unique_code
                )
                .then(({ data }) => {
                    // console.log(data);

                    if (data == 0) {
                        this.dataNotFount = true;
                        this.editMode = false;
                    } else if (data == 1) {
                        this.dataApprovedShow = true;
                        this.editMode = false;
                    } else {

                        this.academic_group_id = data.academic_group_id;

                        this.getSiteYearShiftVersionAdmissiontypeStudenttypeList();

                        this.academic_version_id = data.academic_version_id;
                        this.academic_year_id = data.academic_year_id;
                        this.academic_shift_id = data.academic_shift_id;


                        this.ChangeVersionYear();

                        this.getStudentAdmissionTypeList.map((value, key) => {
                            if (value.id == data.academic_student_admission_type_id) {

                                if (value.head_key == 'old') {
                                    this.admission_type_key = true;

                                } else if (value.head_key == 'new') {
                                    this.admission_type_key = false;
                                }
                            }
                        });


                        // console.log(this.departmentList.length);
                        if (data.academic_department_id) {
                            this.academic_department_id = data.academic_department_id;

                            this.onChangeDepartment();

                            // console.log([this.AcademicClassList, "ok"])
                        }



                        this.academic_class_id = data.academic_class_id;
                        this.whenYearClassSelect = true;

                        this.ClassBaseGroupSection();
                        this.getClassGroupBaseSelectiveSubject();


                        this.getGenderReligionBloodStudentCategoryQuataOccupation();
                        this.PrimaryInfoShowHide = true;
                        this.form.fill(data);

                        this.form.site_student_registration_application_id = data.id;



                        // this.form.student_image = data.photos.length
                        // ? data.photos[0].name
                        // : null;

                        this.form.compulsory_subject_ids = [];
                        this.form.optional_subject_ids = [];
                        this.form.selective_markingless_subject_ids = [];
                        this.form.compulsory_subject_ids = data.compulsory_subject_ids[1] ? data.compulsory_subject_ids[1] : [];
                        this.form.optional_subject_ids = data.optional_subject_ids[1] ? data.optional_subject_ids[1] : [];
                        this.form.selective_markingless_subject_ids = data.selective_markingless_subject_ids[1] ? data.selective_markingless_subject_ids[1] : [];






                        this.ChangeexVersionYear();

                        if (data.ex_academic_department_id) {
                            this.exonChangeDepartment();
                        }

                        this.exClassShiftChange();



                        if (data.ex_academic_class_group_id) {
                            this.form.ex_academic_class_group_id = data.ex_academic_class_group_id;

                            this.exacademicClassGroupChange()
                            this.form.ex_academic_section_id = data.ex_academic_section_id;




                        } else {
                            this.form.ex_academic_section_id = data.ex_academic_section_id;
                        }










                        if (
                            data.father_email ||
                            data.father_contact_number ||
                            data.father_occupation_id ||
                            data.father_yearly_income ||
                            data.mother_email ||
                            data.mother_contact_number ||
                            data.mother_occupation_id ||
                            data.mother_yearly_income
                        ) {

                            this.GurdianInfoShowHide = true;
                        }





                        if (
                            data.ex_academic_year_id ||
                            data.ex_academic_shift_id ||
                            data.ex_academic_class_id ||
                            data.ex_academic_department_id ||
                            data.ex_academic_class_group_id ||
                            data.ex_academic_section_id ||
                            data.ex_academic_session_id ||
                            data.id_card_code ||
                            data.ex_roll_number
                        ) {

                            this.OldStudentInfoShowHide = true;
                        }






                        if (
                            data.birth_certificate_no ||
                            data.nid_number ||
                            data.passport_no ||
                            data.email ||
                            data.emergency_contact
                        ) {
                            this.CommunicationInfoShowHide = true;
                        }

                        if (data.previous_institute_name) {
                            this.PreviousInfoHideShow = true;
                        }

                        if (data.local_guardian_name) {
                            this.LocalGurdianHideShow = true;
                        }

                        if (data.present_country_id) {
                            this.AddressShowHide = true;
                            this.getPresentSiteCountry();
                            this.presentCountryChange();
                            this.presentDivisionChange();
                            this.presentDistrictChange();
                        }

                        if (data.permanent_country_id) {
                            this.AddressShowHide = true;
                            this.getPermanentSiteCountry();
                            this.permanentCountryChange();
                            this.permanentDivisionChange();
                            this.permanentDistrictChange();
                        }



                        this.academic_class_group_id = data.academic_class_group_id
                            ? data.academic_class_group_id
                            : "";
                        if (data.academic_class_group_id) {
                            this.academicGroupChange();
                        }

                        this.academic_section_id = data.academic_section_id;

                        this.academic_student_category_id = data.academic_student_category_id

                        this.academic_session_id = data.academic_session_id;
                        this.academic_student_type_id =
                            data.academic_student_type_id;
                        this.academic_student_admission_type_id =
                            data.academic_student_admission_type_id;







                    }






                })
                .catch(error => {
                    toast({
                        type: "warning",
                        title: error.response.data.message
                    });
                })
                .finally(() => {

                    this.gettingStudentForEditImg = false;
                });

        },




        academicAdmissionTypeChange() {


            this.getStudentAdmissionTypeList.map((value, key) => {

                // console.log(value); 

                if (value.id == this.academic_student_admission_type_id) {

                    if (this.editMode == false) {
                        this.form.ex_academic_year_id = null;
                        this.form.ex_academic_shift_id = null
                        this.form.ex_academic_class_id = null
                        this.form.ex_academic_department_id = null
                        this.form.ex_academic_class_group_id = null
                        this.form.ex_academic_section_id = null
                        this.form.ex_academic_session_id = null
                        this.form.ex_roll_number = null
                        this.form.id_card_code = null
                    }


                    if (value.head_key == 'old') {
                        this.admission_type_key = true;

                    } else if (value.head_key == 'new') {
                        this.admission_type_key = false;
                    }

                }

            });

        },





        blankWithOutForm() {

            if (this.editMode == false) {

                this.AcademicVersionList = [];
                this.AcademicYearList = [];
                this.AcademicShiftList = [];
                this.AcademicClassList = [];
                this.AcademicClassGroupList = [];
                this.AcademicStudentCategoryList = [];
                this.AcademicSessionList = [];
                this.getStudentAdmissionTypeList = [];
                this.getStudentTypeList = [];
                this.RelationList = [];
                this.departmentList = [];
                this.AcademicSectionList = [];

                this.academic_version_id = null;
                this.academic_year_id = null;
                this.academic_shift_id = null;
                this.academic_class_id = null;
                this.academic_department_id = null;
                this.academic_class_group_id = null;
                this.academic_section_id = null;
                this.academic_student_category_id = null;
                this.academic_session_id = null;
                this.academic_student_type_id = null;
                this.academic_student_admission_type_id = null;

            }

        },




        getAcademicGroupList() {
            this.AcademicGroupList = [];
            this.RegistrationDeclareList = [];
            this.declared_time_present = null;

            axios
                .get(
                    "/student-application/global-get-site-academic-group-list/"

                )
                .then(({ data }) => {
                    // console.log(data);
                    this.AcademicGroupList = data.academic_group_list
                    this.RegistrationDeclareList = data.registration_declare_group_list
                    this.declared_time_present = data.declared_time_present
                    this.site_name = data.site_list.site_name
                    this.site_logo = data.site_list.site_logo


                    if (data.academic_group_list.length == 1) {
                        this.academic_group_id = data.academic_group_list[0].id;

                        this.getSiteYearShiftVersionAdmissiontypeStudenttypeList();
                    }

                })
                .catch(error => {
                    toast({
                        type: "warning",
                        title: error.response.data.message
                    });
                })
                .finally(() => {
                    this.loadingClass = false;
                });



        },



        getSiteYearShiftVersionAdmissiontypeStudenttypeList() {
            // this.blankWithOutForm();

            this.loadingPage = true;

            axios
                .get(
                    "/student-application/global-site-year-shift-version-admissiontype-studenttype-load/"
                    + this.academic_group_id
                )
                .then(({ data }) => {
                    // console.log(data); 
                    this.AcademicVersionList = data.academicVersionList;
                    this.AcademicYearList = data.academicYearList;
                    this.AcademicShiftList = data.academicShiftList;
                    this.getStudentAdmissionTypeList = data.admissionlistdata;
                    this.getStudentTypeList = data.academicStudentTypeList;
                    this.RelationList = data.relationList;

                    this.exAcademicYearList = data.previousAcademicYearList
                    this.exAcademicShiftList = data.previousAcademicShiftList

                    this.oldStudentInformationAddShow = data.oldStudentInformationAdd == 1 ? true : false;


                    this.guardian_information_add = data.guardian_information_add == 1 ? true : false;
                    this.address_information_add = data.address_information_add == 1 ? true : false;
                    this.communication_information_add = data.communication_information_add == 1 ? true : false;
                    this.previous_institute_information_add = data.previous_institute_information_add == 1 ? true : false;
                    this.local_guardian_detail_information_add = data.local_guardian_detail_information_add == 1 ? true : false;
                    this.student_registration_number_box_show = data.student_registration_number_box_show == 1 ? true : false;


                    if (data.academicShiftList.length == 1) {
                        this.academic_shift_id = data.academicShiftList[0].id;
                    }

                    if (data.academicVersionList.length == 1) {
                        this.academic_version_id = data.academicVersionList[0].id;

                        // console.log(this.academic_version_id);
                    }


                    if (data.academicYearList.length == 1) {
                        this.academic_year_id = data.academicYearList[0].id;

                        this.ChangeVersionYear();
                    }


                })
                .catch(error => {
                    toast({
                        type: "warning",
                        title: error.response.data.message
                    });
                })
                .finally(() => {
                    this.loadingPage = false;
                });
        },




        ChangeVersionYear() {
            this.AcademicClassList = [];
            this.departmentList = [];

            this.loadingClass = true;


            axios
                .get(
                    "/student-application/global-get-site-year-version-base-department-class/"
                    + this.academic_version_id
                    + "/" + this.academic_year_id
                    + "/" + this.academic_group_id
                )
                .then(({ data }) => {
                    // console.log(data);

                    if (data[0].length > 0) {
                        this.AcademicClassList = data[0]
                    }
                    if (data[1].length > 0) {
                        this.departmentList = data[1]
                    }

                })
                .catch(error => {
                    toast({
                        type: "warning",
                        title: error.response.data.message
                    });
                })
                .finally(() => {
                    this.loadingClass = false;
                });
        },



        ChangeexVersionYear() {

            if (this.editMode == false) {
                this.exAcademicClassList = [];
                this.exdepartmentList = [];

            }



            this.loadingClass = true;


            axios
                .get(
                    "/student-application/global-get-site-year-version-base-department-class/"
                    + this.academic_version_id
                    + "/" + this.form.ex_academic_year_id
                    + "/" + this.academic_group_id
                )
                .then(({ data }) => {
                    // console.log(data);

                    if (data[0].length > 0) {
                        this.exAcademicClassList = data[0]
                    }
                    if (data[1].length > 0) {
                        this.exdepartmentList = data[1]
                    }

                })
                .catch(error => {
                    toast({
                        type: "warning",
                        title: error.response.data.message
                    });
                })
                .finally(() => {
                    this.loadingClass = false;
                });

        },


        onChangeDepartment() {
            this.AcademicClassList = [];
            // this.form.academic_class_id = null;

            axios
                .get(
                    "/student-application/global-get-department-base-class/" +
                    this.academic_department_id
                    + "/" + this.academic_year_id
                    + "/" + this.academic_group_id

                )
                .then(({ data }) => {
                    // console.log(data);
                    this.AcademicClassList = data;

                    // this.academic_group_id = academic_group_id;
                })
                .catch(function (error) {
                    swal("Error!", error.response.data.message, "error");
                })
                .finally(() => {

                });
        },


        exonChangeDepartment() {

            this.exAcademicClassList = [];
            // this.form.academic_class_id = null;

            axios
                .get(
                    "/student-application/global-get-department-base-class/" +
                    this.form.ex_academic_department_id
                    + "/" + this.form.ex_academic_year_id
                    + "/" + this.academic_group_id

                )
                .then(({ data }) => {

                    // console.log([this.ex_academic_department_id, this.ex_academic_year_id, this.academic_group_id]);
                    // console.log(data);
                    this.exAcademicClassList = data;

                    // this.academic_group_id = academic_group_id;
                })
                .catch(function (error) {
                    swal("Error!", error.response.data.message, "error");
                })
                .finally(() => {

                });
        },





        fundamentalbar() {
            if (
                !this.academic_version_id ||
                !this.academic_year_id ||
                !this.academic_shift_id ||
                !this.academic_class_id ||
                !this.academic_student_category_id ||
                (this.AcademicClassGroupList.length > 0 && !this.academic_class_group_id) ||
                (this.AcademicSectionList.length > 0 && !this.academic_section_id)
            ) {
                this.FundamentalInfoShowHide = true;
            } else {
                this.FundamentalInfoShowHide = false;
            }

            //version name show
            var version_id = this.academic_version_id;
            var academic_version_name;
            $.each(this.AcademicVersionList, function (a, b) {
                if (version_id == b.id) {
                    academic_version_name = b.version_name;
                }
            });
            this.academic_version_name = academic_version_name;

            //academic year name show
            var year_id = this.academic_year_id;
            var academic_year_name;
            $.each(this.AcademicYearList, function (a, b) {
                if (year_id == b.id) {
                    academic_year_name = b.year_name;
                }
            });
            this.academic_year_name = academic_year_name;

            //academic session name show
            var session_id = this.academic_session_id;
            var academic_session_name;
            $.each(this.AcademicSessionList, function (a, b) {
                if (session_id == b.id) {
                    academic_session_name = b.session_name;
                }
            });

            this.academic_session_name = academic_session_name;

            //academic shift name show
            var shift_id = this.academic_shift_id;
            var academic_shift_name;
            $.each(this.AcademicShiftList, function (a, b) {
                if (shift_id == b.id) {
                    academic_shift_name = b.shift_name;
                }
            });
            this.academic_shift_name = academic_shift_name;

            //academic class name show
            var department_id = this.academic_department_id;
            var academic_department_name;
            $.each(this.departmentList, function (a, b) {
                if (department_id == b.id) {
                    academic_department_name = b.name;
                }
            });
            this.academic_department_name = academic_department_name;

            //academic class name show
            var class_id = this.academic_class_id;
            var academic_class_name;
            $.each(this.AcademicClassList, function (a, b) {
                if (class_id == b.id) {
                    academic_class_name = b.class_name;
                }
            });
            this.academic_class_name = academic_class_name;

            //academic class group name show
            var class_group_id = this.academic_class_group_id;
            var academic_group_name;
            $.each(this.AcademicClassGroupList, function (a, b) {
                if (class_group_id == b.id) {
                    academic_group_name = b.group_name;
                }
            });
            this.academic_group_name = academic_group_name;

            //academic section name show
            var section_id = this.academic_section_id;
            var academic_section_name;
            $.each(this.AcademicSectionList, function (a, b) {
                if (section_id == b.id) {
                    academic_section_name = b.section_name;
                }
            });
            this.academic_section_name = academic_section_name;

            //academic student category name show
            var category_id = this.academic_student_category_id;
            var academic_category_name;

            $.each(this.AcademicStudentCategoryList, function (a, b) {
                if (category_id == b.id) {
                    academic_category_name = b.category_name;
                    //  console.log(b.category_name);
                }
            });
            this.academic_category_name = academic_category_name;

            //show Student condition name
            var student_type_id = this.academic_student_type_id;
            var academic_student_type_name;
            $.each(this.getStudentTypeList, function (a, b) {
                if (student_type_id == b.id) {
                    academic_student_type_name = b.student_type_name;
                }
            });
            this.academic_student_type_name = academic_student_type_name;

            //show Student Admission type name
            var admission_type_id = this.academic_student_admission_type_id;
            var academic_admission_type_name;
            $.each(this.getStudentAdmissionTypeList, function (a, b) {
                if (admission_type_id == b.id) {
                    academic_admission_type_name = b.admission_type_name;
                }
            });
            this.academic_admission_type_name = academic_admission_type_name;
        },






        browse() {
            document.querySelector("input[type=file]").click();
        },


        studentImageSelect(event) {
            let file = event.target.files[0];
            //console.log(file);
            let reader = new FileReader();
            let limit = 1024 * 1024 * 2;

            if (file["size"] > limit) {
                swal({
                    type: "error",
                    title: "Oops...",
                    text: "You are uploading a large file"
                });
                return false;
            }
            reader.onloadend = file => {
                this.form.student_image = reader.result;
                // console.log(reader.result);
            };
            reader.readAsDataURL(file);
        },

        getProfilePhoto() {
            // console.log("f " + this.form.student_image);
            let photo = "";
            if (this.form.student_image) {
                // console.log(this.form.student_image)
                this.photo =
                    this.form.student_image.length > 200
                        ? this.form.student_image
                        : "/uploads/" + this.form.student_image;
            } else {
                this.photo = "/uploads/image-not.png";
                this.form.student_image = "image-not.png";
            }
            return this.photo;
        },


        // browseguardian() {
        //     document.querySelector("input[type=file]").click();
        // },


        // localGuardianImageSelect(event){

        //     let file = event.target.files[0];
        //     //console.log(file);
        //     let reader = new FileReader();
        //     let limit = 1024 * 1024 * 2;

        //     if (file["size"] > limit) {
        //         swal({
        //             type: "error",
        //             title: "Oops...",
        //             text: "You are uploading a large file"
        //         });
        //         return false;
        //     }
        //     reader.onloadend = file => {
        //         this.form.local_guardian_image = reader.result;
        //         // console.log(reader.result);
        //     };
        //     reader.readAsDataURL(file);


        // },


        // getLocalGuardianPhoto(){
        //     // console.log("f " + this.form.local_guardian_image);
        //     let photo = "";



        //     if (this.form.local_guardian_image) {
        //         //console.log(this.form.local_guardian_image)
        //         this.guardianphoto =
        //             this.form.local_guardian_image.length > 200
        //                 ? this.form.local_guardian_image
        //                 : "/uploads/" + this.form.local_guardian_image;
        //     } else {
        //         this.guardianphoto = "/uploads/image-not.png";
        //         this.form.local_guardian_image = "image-not.png";
        //     }
        //     return this.guardianphoto;
        // },




        getGenderReligionBloodStudentCategoryQuataOccupation() {
            this.getGenderList = [];
            this.getResidenceList = [];
            this.ReligionList = [];
            this.getBloodGroupList = [];
            this.AcademicStudentCategoryList = [];
            this.getQuataList = [];
            this.FatherOccupationList = [];
            this.MotherOccupationList = [];

            axios
                .get(
                    "/student-application/global-get-gender-religion-blood-student-category-quata-occupation-list/" +
                    this.academic_group_id
                )
                .then(({ data }) => {
                    // console.log(data);
                    this.getGenderList = data.genderlist;
                    this.ReligionList = data.religionlist;
                    this.getBloodGroupList = data.bloodlist;
                    this.AcademicStudentCategoryList = data.studentCategorylist;
                    this.getQuataList = data.StudentQuatalistdata;
                    this.FatherOccupationList = data.Occupationlistdata;
                    this.MotherOccupationList = data.Occupationlistdata;
                    this.getResidenceList = data.residencelist;




                    if (data.studentCategorylist.length == 1) {
                        // console.log(data[2][0].id);
                        this.academic_student_category_id = data.studentCategorylist[0].id;
                    }

                    if (data.genderlist.length == 1) {
                        // console.log(data[2][0].id);
                        this.form.gender_id = data.genderlist[0].id;
                    }


                })
                .catch(function (error) {
                    // console.log(error);
                })
                .finally(() => { });
        },

        ClassShiftChange() {
            this.AcademicClassGroupList = [];
            this.AcademicSectionList = [];
            this.academic_section_id = null;
            this.academic_class_group_id = null;

            this.codeMessageName = null;
            this.codeMessageCode = null;
            this.codeMessageShow = false;

            if (this.academic_class_id) {
                this.form.reset();

                this.whenYearClassSelect = true;
                this.ClassBaseGroupSection();
                this.getClassGroupBaseSelectiveSubject();
                // this.changeSectionSessionConditionType();

                this.getGenderReligionBloodStudentCategoryQuataOccupation();





                this.student_for_edit = null;
                this.academic_class_group_id = null;
                this.academic_section_id = null;
                this.academic_student_category_id = null;
                this.academic_session_id = null;
                this.academic_student_type_id = null;
                this.academic_student_admission_type_id = null;

                this.PrimaryInfoShowHide = true;
                this.GurdianInfoShowHide = false;
                this.CommunicationInfoShowHide = false;
                this.PreviousInfoHideShow = false;
                this.LocalGurdianHideShow = false;
                this.AddressShowHide = false;
            } else {
                this.whenYearClassSelect = false;
            }
        },




        academicGroupChange() {
            this.AcademicSectionList = [];
            this.academic_section_id = null;

            if (this.academic_class_id) {
                if (this.editMode) {
                    this.ClassBaseGroupSection();
                    this.getClassGroupBaseSelectiveSubject();
                } else {
                    this.whenYearClassSelect = true;

                    this.ClassBaseGroupSection();
                    this.getClassGroupBaseSelectiveSubject();
                    // this.changeSectionSessionConditionType();

                    this.academic_section_id = null;
                    this.academic_student_category_id = null;
                    this.academic_session_id = null;
                    this.academic_student_type_id = null;
                    this.academic_student_admission_type_id = null;


                }
            } else {
                this.whenYearClassSelect = false;
            }
        },


        exClassShiftChange() {
            // console.log(this.form)
            this.exAcademicClassGroupList = [];
            this.exAcademicSectionList = [];
            this.form.ex_academic_class_group_id = null;
            this.form.ex_academic_section_id = null;
            this.exacademicClassGroupChange();
        },



        ClassBaseGroupSection() {

            this.AcademicSectionList = [];
            this.AcademicSessionList = [];

            if (this.academic_shift_id) {
                var academic_shift = this.academic_shift_id;
            } else {
                var academic_shift = 0;
            }

            if (this.academic_class_group_id) {
                var academic_group = this.academic_class_group_id;
            } else {
                var academic_group = 0;
            }

            if (this.academic_year_id) {
                var year_id = this.academic_year_id;
            } else {
                var year_id = 0;
            }

            axios
                .get(
                    "/student-application/global-get-site-class-base-section/" +
                    this.academic_class_id +
                    "/" +
                    academic_shift +
                    "/" +
                    academic_group +
                    "/" +
                    year_id +
                    "/" +
                    this.academic_group_id
                )
                .then(({ data }) => {
                    // console.log(data);

                    if (data[0] == 2001) {
                        this.AcademicClassGroupList = data[1];
                        this.AcademicSessionList = data[2];

                        // if(data[1].length==1){
                        //   console.log(data[1][0].id)
                        //   this.academic_class_group_id=data[1][0].id;~
                        // }
                    } else if (data == 4001) {
                        return;
                    } else {
                        this.AcademicSectionList = data[0];
                        this.AcademicSessionList = data[1];
                    }
                })
                .catch(error => {
                    toast({
                        type: "warning",
                        title: error.response.data.message
                    });
                })
                .finally(() => { });
        },






        exacademicClassGroupChange() {

            this.exAcademicSectionList = [];
            // this.exAcademicSessionList=[];

            if (this.form.ex_academic_shift_id) {
                var academic_shift = this.form.ex_academic_shift_id;
            } else {
                var academic_shift = 0;
            }

            if (this.form.ex_academic_class_group_id) {
                var academic_group = this.form.ex_academic_class_group_id;
            } else {
                var academic_group = 0;
            }

            if (this.form.ex_academic_year_id) {
                var year_id = this.form.ex_academic_year_id;
            } else {
                var year_id = 0;
            }

            axios
                .get(
                    "/student-application/global-get-site-class-base-section/" +
                    this.form.ex_academic_class_id +
                    "/" +
                    academic_shift +
                    "/" +
                    academic_group +
                    "/" +
                    year_id +
                    "/" +
                    this.academic_group_id
                )
                .then(({ data }) => {
                    //    console.log(data);

                    if (data[0] == 2001) {
                        this.exAcademicClassGroupList = data[1];
                        // this.exAcademicSessionList = data[2];

                    } else if (data == 4001) {
                        return;
                    } else {
                        this.exAcademicSectionList = data[0];
                        // this.exAcademicSessionList = data[1];
                    }
                })
                .catch(error => {
                    toast({
                        type: "warning",
                        title: error.response.data.message
                    });
                })
                .finally(() => { });

        },


        getClassGroupBaseSelectiveSubject() {
            if (this.academic_class_group_id) {
                var academic_group = this.academic_class_group_id;
            } else {
                var academic_group = 0;
            }

            axios
                .get(
                    "/student-application/global-get-class-group-base-selective-subject-list/" +
                    this.academic_class_id +
                    "/" +
                    academic_group +
                    "/" +
                    this.academic_year_id +
                    "/" +
                    this.academic_department_id +
                    "/" +
                    this.academic_group_id
                )
                .then(({ data }) => {
                    //   console.log(data);
                    this.ReligionSubjectList = data[0];
                    this.CompulsorySubjectList = data[1];
                    this.OptionalSubjectList = data[2];
                    this.MarkinglessSubjectList = data[3];
                })
                .catch(error => {
                    toast({
                        type: "warning",
                        title: error.response.data.message
                    });
                })
                .finally(() => { });
        },




        // present address
        getPresentSiteCountry() {
            axios
                .get("/student-application/global-get-country-list/")
                .then(({ data }) => {
                    //console.log(data);
                    this.PresentCountryList = data;
                })
                .catch(error => {
                    toast({
                        type: "warning",
                        title: error.response.data.message
                    });
                })
                .finally(() => { });
        },

        presentCountryChange() {
            this.PresentDivisionList = [];
            this.PresentDistrictList = [];
            this.PresentThanaList = [];

            if (this.form.present_country_id) {
                this.presentDivisionLoadingImg = true;
                axios
                    .get(
                        "/student-application/global-get-division-by-country-id/" +
                        this.form.present_country_id
                    )
                    .then(({ data }) => {
                        //console.log(data);
                        this.PresentDivisionList = data;
                    })
                    .catch(error => {
                        toast({
                            type: "warning",
                            title: error.response.data.message
                        });
                    })
                    .finally(() => (this.presentDivisionLoadingImg = false));
            }
        },

        presentDivisionChange() {
            this.PresentDistrictList = [];
            this.PresentThanaList = [];

            if (this.form.present_division_id) {
                this.presentDistrictLoadingImg = true;
                axios
                    .get(
                        "/student-application/global-get-district-by-division-id/" +
                        this.form.present_division_id
                    )
                    .then(({ data }) => {
                        //console.log(data);
                        this.PresentDistrictList = data;
                    })
                    .catch(error => {
                        toast({
                            type: "warning",
                            title: error.response.data.message
                        });
                    })
                    .finally(() => (this.presentDistrictLoadingImg = false));
            }
        },

        presentDistrictChange() {
            this.PresentThanaList = [];

            if (this.form.present_district_id) {
                this.presentThanaLoadingImg = true;
                axios
                    .get(
                        "/student-application/global-get-thana-list-by-district-id/" +
                        this.form.present_district_id
                    )
                    .then(({ data }) => {
                        //console.log(data);
                        this.PresentThanaList = data;
                    })
                    .catch(error => {
                        toast({
                            type: "warning",
                            title: error.response.data.message
                        });
                    })
                    .finally(() => (this.presentThanaLoadingImg = false));
            }
        },

        // Permanent address
        getPermanentSiteCountry() {
            axios
                .get("/student-application/global-get-country-list/")
                .then(({ data }) => {
                    //console.log(data);
                    this.PermanentCountryList = data;
                })
                .catch(error => {
                    toast({
                        type: "warning",
                        title: error.response.data.message
                    });
                })
                .finally(() => { });
        },

        permanentCountryChange() {
            this.PermanentDivisionList = [];
            this.PermanentDistrictList = [];
            this.PermanentThanaList = [];

            if (this.form.permanent_country_id) {
                this.permanentDivisionLoadingImg = true;
                axios
                    .get(
                        "/student-application/global-get-division-by-country-id/" +
                        this.form.permanent_country_id
                    )
                    .then(({ data }) => {
                        //console.log(data);
                        this.PermanentDivisionList = data;
                    })
                    .catch(error => {
                        toast({
                            type: "warning",
                            title: error.response.data.message
                        });
                    })
                    .finally(() => (this.permanentDivisionLoadingImg = false));
            }
        },

        permanentDivisionChange() {
            this.PermanentDistrictList = [];
            this.PermanentThanaList = [];

            if (this.form.permanent_division_id) {
                this.permanentDistrictLoadingImg = true;
                axios
                    .get(
                        "/student-application/global-get-district-by-division-id/" +
                        this.form.permanent_division_id
                    )
                    .then(({ data }) => {
                        //console.log(data);
                        this.PermanentDistrictList = data;
                    })
                    .catch(error => {
                        toast({
                            type: "warning",
                            title: error.response.data.message
                        });
                    })
                    .finally(() => (this.permanentDistrictLoadingImg = false));
            }
        },

        permanentDistrictChange() {
            this.PermanentThanaList = [];

            if (this.form.permanent_district_id) {
                this.permanentThanaLoadingImg = true;
                axios
                    .get(
                        "/student-application/global-get-thana-list-by-district-id/" +
                        this.form.permanent_district_id
                    )
                    .then(({ data }) => {
                        //console.log(data);
                        this.PermanentThanaList = data;
                    })
                    .catch(error => {
                        toast({
                            type: "warning",
                            title: error.response.data.message
                        });
                    })
                    .finally(() => {
                        this.permanentThanaLoadingImg = false
                    });
            }
        },

        permanentThanaChange() {
            if (this.form.permanent_thana_id != this.form.present_thana_id) {
                this.sameAddressSelect = false;
            }
        },

        SameAddress() {
            this.form.permanent_country_id = "";
            this.form.permanent_division_id = "";
            this.form.permanent_district_id = "";
            this.form.permanent_thana_id = "";
            this.form.PermanentAddress = "";
            // console.log(this.sameAddressSelect);

            if (this.sameAddressSelect) {
                this.form.permanent_country_id = this.form.present_country_id;
                this.permanentCountryChange();
                this.form.permanent_division_id = this.form.present_division_id;
                this.permanentDivisionChange();
                this.form.permanent_district_id = this.form.present_district_id;
                this.permanentDistrictChange();
                this.form.permanent_thana_id = this.form.present_thana_id;
                this.form.permanent_address = this.form.present_address;
            }
        },

    },
    created() {
        this.getAcademicGroupList();
    }
};
