export default [
    {
        name: "site-student-panel-attendance-master-component",
        path: "/student/attendance",
        component: () =>
            import("@/components/site/studentPanel/attendance/masterComponent"),
        meta: {
            breadcrumb: [
                { title: "Settings" },
                { title: "Student Attendance", active: true }
            ],
            pageTitle: "Student Attendance"
        },
        children: [
            {
                name: "site-student-panel-attendance-leave-component",
                path: "leave",
                component: () =>
                    import(
                        "@/components/site/studentPanel/attendance/leave/ApplyLeaveComponent"
                    ),
                meta: {
                    breadcrumb: [{ title: "Payment" }],
                    pageTitle: "Student Payment Master"
                }
            },
            {
                name: "site-student-panel-attendance-my-attendance",
                path: "my-attendance",
                component: () =>
                    import(
                        "@/components/site/studentPanel/attendance/MyAttendanceComponent"
                    ),
                meta: {
                    breadcrumb: [{ title: "Payment" }],
                    pageTitle: "Student Attendance"
                }
            },
            {
                name: "site-student-panel-attendance-my-periodic-attendance",
                path: "periodic-attendance",
                component: () =>
                    import(
                        "@/components/site/studentPanel/attendance/PeriodAttendanceComponent"
                    ),
                meta: {
                    breadcrumb: [{ title: "periodic" }],
                    pageTitle: "Student periodic Attendance"
                }
            },
            {
                name: "site-student-panel-attendance-my-routine",
                path: "routine",
                component: () =>
                    import(
                        "@/components/site/studentPanel/attendance/MyRoutineComponent"
                    ),
                meta: {
                    breadcrumb: [{ title: "MyRoutineComponent" }],
                    pageTitle: "Student MyRoutineComponent.vue"
                }
            }
        ]
    },
    {
        name: "site-student-class-room-component",
        path: "/api/site/student/class-room/view",
        props: true,
        component: () =>
            import("@/components/site/studentPanel/classRoom/ClassRoomComponent"),
        meta: {
            breadcrumb: [{ title: "Class Room", active: true }],
            pageTitle: "Class Room"
        }
    },
    {

        name: "site-student-calendar-component",
        path: "/site/student/calendar-view",
        props: true,
        component: () =>
        import(
            "@/components/site/employee/calendar/EmployeeCalendarMasterComponent"
        ),
        meta: {
            breadcrumb: [{ title: "Academic Calendar", active: true }],
            pageTitle: "Academic Calendar"
        }
    },
    // {
    //     name: "my-invitation",
    //     path: "/user/my-invitation",
    //     component: () =>
    //         import(
    //             "@/components/site/studentPanel/meeting/MyInvitationComponent.vue"
    //         )
    // },
    {
        name: "site-student-payment-master-component",
        path: "/student/payment/master",
        component: () =>
            import("@/components/site/studentPanel/payment/masterComponent"),
        meta: {
            breadcrumb: [
                { title: "Payment" },
                { title: "Student Payment", active: true }
            ],
            pageTitle: "Student Payment Master"
        },
        children: [
            {
                name: "site-student-academic-payment-component",
                path: "/student/payment/payment-with-wallet",
                component: () =>
                    import(
                        "@/components/site/studentPanel/payment/MakePaymentComponent"
                    ),
                meta: {
                    breadcrumb: [{ title: "Payment" }],
                    pageTitle: "Student Payment Master"
                }
            },
            {
                name: "site-student-payment-list-component",
                path: "/student/payment/payment-list",
                component: () =>
                    import(
                        "@/components/site/studentPanel/payment/PaymentTransactionListComponent"
                    ),
                meta: {
                    breadcrumb: [{ title: "Payment" }],
                    pageTitle: "Student Payment Master"
                }
            },
            {
                name: "site-student-academic-payment-with-transaction-id-component",
                path: "/student/payment/payment-with-transaction-id",
                component: () =>
                    import(
                        "@/components/site/studentPanel/payment/MakePaymentWithTransactionIDComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Payment" },
                        { title: "With Transaction ID" },
                    ],
                    pageTitle: "Student Payment With Transaction ID"
                }
            },
            {
                name: "site-student-academic-check-payment-with-transaction-id-component",
                path: "/student/payment/check-payment-with-transaction-id",
                component: () =>
                    import(
                        "@/components/site/studentPanel/payment/CheckPaymentWithTransactionIDComponent"
                    ),
                meta: {
                    breadcrumb: [
                        { title: "Payment" },
                        { title: "With Transaction ID" },
                    ],
                    pageTitle: "Student Payment With Transaction ID"
                }
            },
            {
                name: "site-student-payment-status-message-component",
                path: "/student/payment/sonali-pay-message",
                component: () =>
                    import(
                        "@/components/site/studentPanel/payment/PaymentReceiveStatusMessageComponent"
                    ),
                meta: {
                    breadcrumb: [{ title: "Payment" }],
                    pageTitle: "Student Payment Master"
                }
            },
        ]
    },

     // this route for student quiz start
     {
        name: "student-quiz-component",
        path: "/student/quiz/master",
        component: () =>
            import(
                "@/components/site/studentPanel/quiz/StudentQuizMasterComponent "
            ),
        meta: {
            breadcrumb: [
                { title: "Form", url: "/" },
                { title: "Student Quiz", active: true }
            ],
            pageTitle: "Student Quiz Master"
        }
    },


    {
        name: "student-quiz-start-component",
        path: "/student/quiz/start/:quizDeclareId",
        props: true,
        component: () =>
            import(
                "@/components/site/studentPanel/quiz/StudentQuizStartComponent"
            ),
        meta: {
            breadcrumb: [
                { title: "Exam Start" },
                { title: "Exam Start", active: true }
            ],
            pageTitle: "Exam Start"
        }
    },

    // this route for student quiz end
];
