<!DOCTYPE html>
<html>

<head>
    @php($site = getSiteInfoForPdf())
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>


    <title>{{ $page_tittle }}</title>


</head>

<body>



    @foreach ($card_data as $key => $value)
        <style>
            @font-face {
                font-family: 'Verdana';
                font-weight: 100;
                font-style: normal;
                font-variant: normal;
                src: url("{{ public_path() }}/fonts/Verdana.ttf") format("truetype");
            }

            body {
                font-family: "Verdana", Arial, Helvetica, sans-serif;
                font-size: 12px;
            }

            .st-image {
                border-top-left-radius: 36px 38.5px;
                border-top-right-radius: 36px 38.5px;
                border-bottom-left-radius: 36px 38.5px;
                border-bottom-right-radius: 36px 38.5px;
                margin-top: px;
                border: 1px solid white !important;
                text-align: center;
                width: 100px;
                height: 100px;

            }

            .name {
                text-align: left;
                width: 20%;
                font-weight: bold;
                font-size: {{ $body_font_size }};
            }

            .value {
                /*width: 100%;*/
                text-transform: capitalize;
                font-weight: bold;
                font-size: {{ $body_font_size }};
            }

            .main-div {
                background-position: center;
                background-size: cover;
                background-repeat: no-repeat;
                border: .5px solid black;
                width: 205px;
                height: 326px;
                margin-bottom: 12.4111px;
                margin-left: 21px;
                float: left;
                overflow: hidden;
            }

            .site-logo {
                background: white;
                border-top-left-radius: 6px/51px;
                border-top-right-radius: 6px/51px;
                border-bottom-left-radius: 6px/51px;
                border-bottom-right-radius: 6px/51px;
                /*margin-top: 8px;*/
                height: 40px;
                width: 40px;
                /* margin-left: 10px */
            }

            @page {
                size: 2330px 1730px;
                margin: 0;
                margin-bottom: 1px;
                /* Adjust to prevent extra blank pages */
            }
        </style>


        <div class="main-div" style="background-image: url({{ public_path($bg_path) }});">

            <table cellspacing="0" border="0" width="100%;">

                <tbody>
                    <tr>
                        <td style="width: 100%;text-align: center; padding: 2px">

                        </td>
                    </tr>
                    <tr style="">
                        <td style="width: 100%;text-align:center">
                            <div style="">
                                <img class="site-logo" style="" src="{!! public_path($site_logo_path) !!}">
                            </div>
                            <div style="">
                                <p
                                    style="font-size:{{ $institute_name_font_size }}; text-transform:capitalize;margin-left: 100px;font-weight: bold ; margin:0px;color:white ">
                                    Chittagong City <br> Corporation Premier College</p>

                            </div>


                        </td>
                    </tr>


                    <tr>
                        <td style=" width: 100%;text-align: center ;padding: 2px">
                            <span
                                style="text-transform:uppercase;font-size: 15px; font-weight: bold; color: #ffffff"></span>
                        </td>
                    </tr>
                    <tr>

                        <td style="width: 50%;text-align: center;">

                            @if (file_exists(public_path($value['latest_photo_path'])))
                                <img class="st-image"src="{{ public_path($value['latest_photo_path']) }}">
                            @else
                                <img class="st-image" src="{{ public_path('uploads') . '/image-not.png' }}">
                            @endif

                        </td>

                    </tr>
                    <tr>
                        <td style="width: 100%;text-align: center; padding: px">

                        </td>
                    </tr>
                    <tr style="width: 100%;text-align: center">
                        <td style="width: 100%;text-align: center">
                            <span
                                style="text-transform:uppercase;font-size: {{ $name_font_size }}; font-weight: bold; color: #000080;position:absolute;left:35px;right:0px">
                                {{ $value['full_name'] ?? '--' }} </span>
                        </td>
                    </tr>
                    <tr>
                        <td style="width: 100%;text-align: center; padding: 14px">

                        </td>
                    </tr>

                    <tr style="width: 100%;font-weight: bold;font-size: 11px; color:white;text-align: center">

                        <td style="text-align: center;">
                            <div>
                                <b> {{ $value['designation_name'] }} </b>
                                <br>
                                @if ($value['subject'])
                                    <div style="margin-top:3px;color:black">
                                        ({{ $value['subject'] }})
                                    </div>
                               
                                @endif
                            </div>
                        </td>

                    </tr>

                </tbody>

            </table>
            <div style="margin-left: 0px;margin-top: 0px">
                <div style="width:100%;padding:0 0px 0 0px">
                    <div style=" padding-left:10pxpx ">
                        <table class="data-table" cellspacing="0" border="0" width="100%;" style="">

                            <tbody style="margin-left: 100px">


                                <tr>
                                    <th class="name">
                                        <nobr>Mobile No.</nobr>
                                    </th>
                                    <td class="value" style="text-transform: inherit !important">
                                        <nobr> : {{ $value['contact_number'] ?? '--' }}</nobr>
                                    </td>
                                </tr>





                                <tr>
                                    <th class="name">
                                        <nobr>Email</nobr>
                                    </th>
                                    <td class="value"
                                        style="text-transform: inherit !important;font-size: {{ strlen($value['email']) < 22 ? $body_font_size : 9 }}px">
                                        <nobr> : {{ $value['email'] ?? '--' }}</nobr>
                                    </td>
                                </tr>
                                <tr>
                                    <th class="name">
                                        <nobr>Blood Group</nobr>
                                    </th>
                                    <td class="value" style="text-transform: inherit !important">
                                        <nobr> : {{ $value['blood_group_name'] ?? '--' }}</nobr>
                                    </td>
                                </tr>


                                <tr>
                                    <th class="name">
                                        <nobr>Emergency No.</nobr>
                                    </th>
                                    <td class="value">
                                        <nobr> : 01783718856</nobr>
                                    </td>
                                </tr>









                            </tbody>
                        </table>
                    </div>
                </div>

            </div>

            <table class="data-table" cellspacing="0" border="0" width="100%;" style="">
                <tr>
                    <th colspan="3"></th>
                </tr>
                <tr>
                    <td style="width: 100%;text-align: center; padding: 5px">

                    </td>
                </tr>
                <tr>
                    <td colspan="2" style="text-align:right; padding-right:15px;">
                        <div style="position: absolute;top:-30px;margin-left: 135px">
                            <img width="80" src="{{ public_path($signature) }}"
                                style="position: absolute;top:12px;left: -13px">
                            <br><br>
                            <span
                                style="border-top: 1px dotted black; font-weight:bold padding: 0 10px; font-size:10px">{{ $designation }}</span>
                        </div>
                    </td>

                    {{-- <td style="width: 100%; " style="">
                        @if ($showQRCode)
                            <img width="120" style="position: absolute;margin-left: 50px;margin-top: -50px"
                                src="data:image/png;base64, {!! base64_encode(
                                    QrCode::size(48)->generate(
                                        $domain . '/site-public/student-details/' . $value['username'] . '.' . $site_id . '.' . $value['history_id'],
                                    ),
                                ) !!} ">
                        @endif

                    </td> --}}
                </tr>

            </table>


        </div>
        @if (($key + 1) % 10 == 0)
            <div style="clear:both;"></div>
        @endif

        @if (($key + 1) % 50 == 0 && $key + 1 != count($card_data))
            <div class="page-break"></div>
        @endif
    @endforeach


</body>




</html>
