<!DOCTYPE html>
<html>
<head>
    @php($site=getSiteInfoForPdf())
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no'
          name='viewport'>


    <title>{{$page_tittle}}</title>

    <style>

        @font-face {
            font-family: 'Verdana';
            font-weight: 100;
            font-style: normal;
            font-variant: normal;
            src: url("{{public_path()}}/fonts/Verdana.ttf") format("truetype");
        }

        body {
            font-family: "Verdana", sans-serif;
            font-size: 12px;
        }

        .st-image {
            margin-top: 50px;
            text-align: center;
            width: 104px;
            height: 112px;
            border-top-left-radius: 35 5;
            border-top-right-radius: 35 5;
        }

        .data-table th {
            font-size: 10px;
            text-align: left;
            line-height: 90%;
        }

        .data-table td {
            font-size: 10px;
            text-align: left;
            line-height: 90%;
        }

        .page-break {
            page-break-after: always;
        }

        .main-div {

            background-image: url({{asset("/img/site/idcard/".Session::get('ALIAS1').".png")}});
            background-position: center;
            background-size: cover;
            background-repeat: no-repeat;
            border: .0px solid black;
             
            transform: rotate(89deg);
            width: 192px;
            padding: 2px 6px;
            height: 320px;
            margin: 0 0 0 0;
            margin-top: -34px;
            margin-left: 184px;
            border-radius: 5px;
            float: center;
            overflow: hidden;
    
        }

        .site-logo {
            background: transparent;
            height: 50px;
        }

    </style>

</head>
<body>

{{--
@include('default.site.layout.pdf-header')


--}}


@foreach($card_data as $key => $value)

    {{--
        <div class="bg-image"
             style="width:199px; padding: 2px 6px; height:326px; margin:0 10px 10px 20px; border-radius: 5px;float: left; overflow: hidden">
    --}}

    <div class="main-div">

        <table cellspacing="0" border="0" width="100%;">

            <tbody>
            <tr>
                <td style="width: 100%;text-align: center">
                    <img class="site-logo" style="text-align: center" width="50"
                         src="{!! asset(Session::get('LOGO_PATH')) !!}">
                </td>
            </tr>
            <tr>
                <td style="width: 100%;text-align: center">

                    @if(file_exists(public_path("uploads").'/'.$value['latest_photo']))
                        <img class="st-image"
                             src="{{asset("uploads").'/'.$value['latest_photo'] ?? 'image-not.png'}}">
                    @else
                        <img class="st-image"
                             src="{{asset("uploads").'/image-not.png'}}">
                    @endif

                </td>
            </tr>
            <tr>
                <td style="width: 100%;text-align: center; padding: 2px">

                   
                </td>
            </tr>
            <tr>
                <td style="width: 100%;text-align: center">
                    <span style="text-transform:uppercase;font-size: 11px; font-weight: bold; color: #0b2c89"> {{  $value['full_name'] ?? '--'}} </span>
                </td>
            </tr>
            <tr>
                
                <td style="text-align: center">
                    <b> ({{$value['username']}})</b>
                </td>
            </tr>
           
            </tbody>
             
        </table>

        <table class="data-table" cellspacing="0" border="0" width="100%;" style="">

            <tbody>
                <tr>
                <td style="width: 100%;text-align: center; padding: 5px">

                   
                </td>
            </tr>
            
            @if($value['department_name'])
                <tr>
                    <th>
                        Department : {{$value['department_name'] ?? '--'}}
                    </th>
                    
                </tr>
            @endif


            <tr>
                <th style="width="40%">
                    Class
                

                    @if($value['class_name'] == 'XI')

                        <nobr>: HSC</nobr>

                    @else


                        <nobr>
                            : {{$value['class_name'] ?? '--'}}   @if($value['group_name']) <b>
                                ({{$value['group_name'] ?? '--'}})</b> @endif</nobr>
                    @endif

                </th>
            

            </tr>


            @if($value['student_roll_number'])
                <tr>
                    <th>
                        Roll <nobr> : {{sprintf("%03d", $value['student_roll_number'] ?? '')}}</nobr>
                    </th>
                    <td colspan="2" style="text-align:right;line-height: 30%; padding-right:15px;width: 100%;">
                    <br>
                    <br>
                    <img style="text-align: center; " width="80"
                         src="{{asset($signature)}}">
                    <br>
                    <br>
                    <span style="border-top: 1px dotted black;padding: 0 5px;">{{$designation}}</span>
                        
                    </td>
                </tr>

            @endif


            @if($value['blood_group'])

                <tr>
                    <th>
                        B. Group <nobr> : {{$value['blood_group'] ?? '--'}} </nobr>
                    </th>
                    <td>
                        <nobr> : ({{$value['blood_group'] ?? '--'}})</nobr>
                    </td>
                </tr>

            @endif

            
            </tbody>
        </table>

    </div>


    @if(($key+1) % 1== 0)
        <div style="clear:both; height:-96px; margin-right: 0;"></div>
    @endif


    @if(($key+1) % 2 == 0 )
        <div class="page-break"></div>
    @endif


@endforeach


</body>


<style>

    @page {
        size: a4;
        margin: 0;
        

    }

    body {
        margin:10px 5px 3px;
        background-color: #ffffff;
    }


</style>

</html>












