@extends('default.admin.layouts.master')


@section('style')
    {!! Html::style('datepicker/css/datepicker.css') !!}
    {!! Html::style('datepicker/css/timepicker.css') !!}
    {!! Html::style('select/css/select2.min.css') !!}
@endsection

@section('content')

    <div class="container-fluid min_height_area">
        <div class="row">
            <div class="col-md-12">
                <div class="student-box-header">
                    <div class="col-md-6 col-xs-5">
                        <span class="glyphicon glyphicon-user "
                              aria-hidden="true"></span>{{ trans('sidebar.building_create') }}
                    </div>
                    <div class="col-md-6 col-xs-7 snt">
                        <ul class="breadcrumb text-right">
                            <li>
                                <span class="glyphicon glyphicon-folder-close" aria-hidden="true"></span>
                                <a href="#">{{ trans('translate.dashboard') }}</a></li>
                            <li class="active">{{ trans('sidebar.building_create') }}</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div> <!--row-->
        <div class="inner-box">
            <div class="row">
                <div class="col-md-12 snt form-horizontal">
                    <div class="col-md-12" id="successMessage">
                        @if (count($errors) > 0)
                            <div class="alert alert-danger row">
                                <ul>
                                    @foreach ($errors->all() as $error)
                                        <li>{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        @endif
                        @if(session()->has('success'))
                            <div class="alert alert-success row">
                                <ul>
                                    <li>{{ session()->get('success') }}</li>
                                </ul>
                            </div>
                        @endif
                    </div>


                    <div class="custom_row">
                        <h2 class="form_title">
                            {{--                            {{ trans('sidebar.building_enrole_form') }}--}}
                            Academic year
                        </h2>
                    </div>


                    @if($mode)

                        {!! Form::open(array('route' => 'academic-year-create')) !!}

                        <div class="row">
                            <div class="field_wrap col-sm-12">
                                {!! Form::label('startdate','Start Date:',['class'=>'col-sm-12']) !!}
                                {!! Form::text('startdate',null,['class'=>'form-control datepick']) !!}
                            </div>
                        </div>

                        <div class="row">
                            <div class="field_wrap col-sm-12">
                                {!! Form::label('enddate','End Date:',['class'=>'col-sm-12']) !!}
                                {!! Form::text('enddate',null,['class'=>'form-control datepick']) !!}
                            </div>
                        </div>

                        <div class="row">
                            <div class="field_wrap col-sm-12">
                                {!! Form::label('yearname','Academic1',['class'=>'col-sm-12']) !!}
                                {!! Form::text('yearname',null,['class'=>'form-control']) !!}
                            </div>
                        </div>


                        <div class="row">
                            <div class="field_wrap col-sm-12">
                                {!! Form::label('academicYearStatus','Condition:',['class'=>'col-sm-12']) !!}
                                {!! Form::radio('academicYearStatus', 1 , true) !!}Active
                                {!! Form::radio('academicYearStatus', 0 , false) !!}Inactive
                            </div>
                        </div>

                        <div class="row">
                            <div class="submig_button">
                                <input class="sub btn btn-success" style="background-color:#0073b7" readonly="readonly" type="submit" value="Submit"></div>
                        </div>

                        {!!  Form::close()   !!}

                    @else

                        {!! Form::model($singleAcademicYear, ['route' => ['academic-year-edit', $singleAcademicYear->id]]) !!}
                        <div class="row">
                            <div class="field_wrap col-sm-12">

                                {!! Form::label('start_date','Start Date:',['class'=>'col-sm-12']) !!}

                                {!! Form::text('start_date',null,['class'=>'form-control datepick']) !!}

                            </div>
                        </div>
                        <div class="row">

                            <div class="field_wrap col-sm-12">

                                {!! Form::label('end_date','End Date:',['class'=>'col-sm-12']) !!}

                                {!! Form::text('end_date',null,['class'=>'form-control datepick']) !!}

                            </div>


                        </div>

                        <div class="row">
                            <div class="field_wrap col-sm-12">

                                {!! Form::label('year_name','Academic',['class'=>'col-sm-12']) !!}

                                {!! Form::text('year_name',null,['class'=>'form-control']) !!}

                            </div>
                        </div>


                        <div class="row">
                            <div class="field_wrap col-sm-12">

                                {!! Form::label('status','Condition:',['class'=>'col-sm-12']) !!}

                                {!! Form::radio('status', 1) !!}Active
                                {!! Form::radio('status', 0) !!}Inactive
                            </div>
                        </div>

                        <div class="row">
                            <div class="submig_button">
                                <input class="sub btn btn-success" style="background-color:#0073b7"
                                       readonly="readonly" type="submit" value="Update"></div>
                        </div>

                        {!!  Form::close()   !!}

                    @endif

                </div>
            </div>


            <div class="row">
                <div class="col-md-12 table-responsive">
                    <table class="table table-responsive table-bordered">
                        <thead>

                        <tr>
                            <th>#</th>
                            <th>Year Name</th>
                            <th>Start Date</th>
                            <th>End Date</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>

                        </thead>

                        <tbody>
                        @set('sl',1)
                        @if(!$academicYearList->isEmpty())
                            @foreach($academicYearList as $academicyear)
                                <tr>
                                    <td>{{$sl++}}</td>
                                    <td>{{$academicyear->year_name}}</td>
                                    <td>{{date('d M y', strtotime($academicyear->start_date))}}</td>
                                    <td>{{date('d M y', strtotime($academicyear->end_date))}}</td>
                                    <td>
                                        {{--{{getActiveInactive($academicyear->status)}}--}}
                                        @if($academicyear->status==1)
                                            <div class="btn-group" role="group" aria-label="Basic example">
                                                <a  href="{{ route('academic-year-activeinactive',
                                                [$academicyear->id]) }}" type="button" class="btn btn-secondary">InActive</a>
                                            </div>
                                        @else
                                            <div class="btn-group" role="group" aria-label="Basic example">
                                                <a  href="{{ route('academic-year-activeinactive',
                                                [$academicyear->id]) }}" type="button" class="btn btn-info">Active</a>
                                            </div>
                                        @endif

                                    </td>
                                    <td>
                                        <a class="btn btn-success btn-xs mrg"
                                           data-original-title="Edit"
                                           data-toggle="tooltip"
                                           href="{{ route('academic-year-edit',[$academicyear->id]) }}">
                                            <i class="fa fa-edit"></i>
                                        </a>

                                        <a class="btn btn-danger btn-xs mrg"
                                           onClick="return confirm('Are you confirm to delete this data!')"
                                           href="{{ route('academic-year-delete',[$academicyear->id]) }}">
                                            <i class="fa fa-trash-o"></i>
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                        @else
                            <tr>
                                <td colspan="4">
                                    <strong>No data found</strong>
                                </td>
                            </tr>
                        @endif
                        </tbody>
                    </table>

                </div>
            </div>


        </div>
    </div>



@endsection

@section('scripts')
    {!! Html::script('datepicker/js/bootstrap-datepicker.js') !!}
    @parent




@endsection

