@extends('default.admin.layouts.master')

@section('style')
    {!! Html::style('css/styles.css') !!}
    {!! Html::style('select/css/select2.min.css') !!}
@endsection

@section('content')

    <div class="container-fluid min_height_area">
        <div class="row">
            <div class="col-md-12">
                <div class="student-box-header">
                    <div class="col-md-6 col-xs-5">
                        <a href="{{route('district-list')}}">
                        <span class="glyphicon glyphicon-backward" aria-hidden="true"></span>{{ trans('sidebar.district-list') }}
                        </a>
                       => For  <b> <i> {{$the_dis->division->division_name}}</i></b> Division
                    </div>
                    <div class="col-md-6 col-xs-7 snt">
                        <ul class="breadcrumb text-right">
                            <li>
                                <span class="glyphicon glyphicon-folder-close" aria-hidden="true"></span>
                                <a href="#">{{ trans('sidebar.dashboard') }}</a></li>
                            <li class="active">{{ trans('sidebar.district_edit') }}</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div> <!--row-->
        <div class="inner-view">
            <div class="row">
                <div class="col-md-12 snt form-horizontal">

                    @if (count($errors) > 0)
                        <div class="alert alert-danger row">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    @if(session()->has('success'))
                        <div class="alert alert-success row">
                            <ul>

                                <li>{{ session()->get('success') }}</li>

                            </ul>
                        </div>
                    @endif

                  <div class="custom_row">
                        {!! inputLangControl() !!}
                    </div>

                    <div class="custom_row">                      
                        <h2 class="form_title">
                            {{ trans('sidebar.district_edit') }}
                        </h2>                                          
                    </div>

                    {!! Form::model(
                                $districtData,
                                array(
                                'route' => ['district-edit',$districtData->id],
                                'files' => true,
                                'id'=>'create-form',
                                'class'=>'form-create',
                                'method'=>'PATCH'
                                ))
                    !!}

                        {!! Form::hidden('division_id',$the_dis->division->id) !!}

                    {!! formFields($editDistrict,$mode='edit',$districtData->id)  !!}

                    {!!  Form::close()   !!}

                </div>
            </div>
        </div>
    </div>



@endsection
@section('scripts')


    @parent

    {{-- <script src="{{ asset('jquery-validation/dist/jquery.validate.min.js') }}"></script>--}}
    {!! Html::script('select/js/select2.min.js') !!}

    <script type="text/javascript">
        $(document).ready(function(){
            $('#country_id').select2();
            $('#division_id').select2();
            $(".translation_wrap").hide();
            $(".translation_wrap.trans_en"/*+lang_def*/).show();
            $(".control_lang").on("click",function(){
                var selected_lang = $(this).val();
                $(".translation_wrap").hide();
                $(".translation_wrap.trans_"+selected_lang).show();
                $(".control_lang").val(selected_lang);
            });
            $('#country_id').change(function () {
                var host = window.location.origin ;

                var divisionId = $('#country_id').find('option:selected').val();
                $('#division_id').html('mmm');
                $.ajax({
                    'url': host+'/division/list-by-country-id/'+divisionId,
                    'dataType': 'json',
                    success: function(data){
                        console.log(data.length);
                        var divisionList ='';
                        if(data.length){
                             divisionList = "<option value='' selected='selected' >Select Division Now </option>";
                            $(data).each(function(index,item){
                                divisionList += "<option value ="+ item.id +">"+item.division_name+" </option>";
                            });
                            $('#division_id').html(divisionList);
                            $('#division_id').val('').trigger('change.select2');
                        }else {
                             divisionList = "<option value='' selected='selected' >No Data Found </option>";
                            $('#division_id').html(divisionList);
                            $('#division_id').val('').trigger('change.select2');
                        }


                    },error: function (data) {
                        console.log(data)
                        $.growl.error({ message: data.responseText });
                    }
                });
            });
        });
    </script>

@endsection