@extends('default.admin.layouts.master')


@section('style')
    {!! Html::style('select/css/select2.min.css') !!}
@endsection

@section('content')


    <div class="container-fluid min_height_area">

        <div class="row">
            <div class="col-md-12">
                <div class="view-header">
                    <section class="content-header">
                        <ol class="breadcrumb">
                            <li>
                                <span class="fa fa-dashboard" aria-hidden="true"></span>
                                <a href="{{route('admin')}}">{{ trans('translate.dashboard') }}</a>
                            </li>
                            <li class="active text-capitalize">
                                <a href="{{ route('menu-list') }}">{{ trans('breadcrumb.menu.list') }}</a>

                            </li>
                            <li class="active text-capitalize">{{ request()->route()->getName() }}</li>
                        </ol>
                    </section>
                </div>
            </div>

        </div> <!--row-->
        <div class="inner-box-1">
            <div class="row">
                <div class="col-md-12 ">

                    @if (count($errors) > 0)
                        <div class="alert alert-danger row">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    @if(session()->has('success'))
                        <div class="alert alert-success row">
                            <ul>

                                <li>{{ session()->get('success') }}</li>

                            </ul>
                        </div>
                    @endif


                    <div class="col-sm-12 col-md-12">

                        @if(count($all_sites))
                            <table class="table table-bordered table-striped">
                                <thead>
                                <tr>
                                    <td>Sl</td>
                                    <td>Site Name</td>
                                    <td>Action</td>
                                </tr>
                                </thead>
                                <tbody>

                                @foreach($all_sites as $k=>$site)

                                    <tr>
                                        <td>{{$k+1}}</td>
                                        <td>

                                            {{$site->site_name}}
                                        </td>
                                        <td>
                                            {!! Form::open(array('route' =>'edu-site-impersonate', 'class'=>'form-horizontal')) !!}
                                            {!! Form::hidden('site_id',$site->id,['class'=>'form-control']) !!}

                                            <button class="btn btn-dropbox" type="submit"> Impersonate <i
                                                        class="fa fa-arrow-circle-right"></i></button>
                                            {!! Form::close() !!}
                                        </td>
                                    </tr>


                                @endforeach
                                </tbody>

                            </table>
                        @endif

                        {{-- <div class="input-group">

                             {!! Form::select('site_id',$all_sites,null,['class'=>'form-control']) !!}

                             <span class="input-group-btn">
                             <button class="btn btn-dropbox" type="submit"> Impersonate  <i class="fa fa-arrow-circle-right"></i></button>
                         </span>
                         </div>--}}
                    </div>
                </div>
            </div>
        </div>
    </div>


@endsection
@section('scripts')


    {!! Html::script('select/js/select2.min.js') !!}
    <script type="text/javascript">
        $(document).ready(function () {
            $('select1').select2();

        });
    </script>

@endsection