@if(Auth::check())
    @php($authUser=request()->user())
@endif
<aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->

    <section class="sidebar">
        <!-- Sidebar user panel -->
        <div class="user-panel">
            <div class="pull-left image" style="min-height: 25px">
                <img src="{{asset($authUser->photos->last()->path ?? "/uploads/image-not.png")}}"
                     class="user-image img-circle" alt="User Image">
            </div>

            @if(Session::get('SITE_ID'))
                <div class="pull-left info">
                    <p>    {{Session::get('ACADEMIC_GROUP_NAME')}}
                        <br>

                        <span style="color: #fffef0; font-size: 10px; text-transform: capitalize"> {{ $authUser->roles[0]->name ?? 'not available' }}
                            Panel</span>
                    </p>
                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true"
                       aria-expanded="true"><span class="caret"></span> &nbsp;Switch</a>
                    <ul class="dropdown-menu">

                        @php($acc_group_list=getAllAcademicGroupsBySite(Session::get('SITE_ID')))
                        @if($acc_group_list)
                            @foreach($acc_group_list as $k=>$v)
                                <li>
                                    <a href="{{route('edu-impersonate-academic-group',[$v->id])}}">{{$v->academic_group_name}}</a>
                                </li>
                            @endforeach
                        @endif

                        <li role="separator" class="divider"></li>
                        <li>
                            <a href="{{route('back-to-main-panel')}}">
                                <i class="fa fa-refresh"></i> Refresh
                            </a>
                        </li>
                    </ul>
                    <a href="#"><i class="fa fa-circle text-success"></i> Online</a>

                </div>
            @elseif(Session::get('SITE_GROUP_ID'))

                <div class="pull-left info">
                    <p>    {{Session::get('ACADEMIC_GROUP_NAME')}}
                        <br>

                        <span style="color: #fffef0; font-size: 10px; text-transform: capitalize"> {{ $authUser->roles[0]->name ?? 'not available' }}
                            Panel</span>
                    </p>

                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true"
                       aria-expanded="true"><span class="caret"></span> &nbsp;Switch</a>
                    <br>
                    <ul class="dropdown-menu">

                        @php($acc_group_list=academicGroupsBySiteGroup(Session::get('SITE_GROUP_ID')))

                        @if($acc_group_list)
                            @foreach($acc_group_list as $k=>$v)
                                <li>
                                    <a href="{{route('edu-impersonate-academic-group',[$v->id])}}">{{$v->academic_group_name}}</a>
                                </li>
                            @endforeach
                        @endif

                        <li role="separator" class="divider"></li>
                        <li>
                            <a href="{{route('back-to-main-panel')}}">
                                <i class="fa fa-refresh"></i> Refresh 
                            </a>
                        </li>
                    </ul>
                    <a href="#"><i class="fa fa-circle text-success"></i> Online</a>

                </div>
            @else

                <div class="pull-left info">
                    <p>

                        @if( isset($authUser))
                            {{ $authUser->full_name ?? ''}}
                        @endif
                        <br>
                        <span style="color: #fffef0; font-size: 10px; text-transform: capitalize"> ({{ $authUser->roles[0]->name ?? 'not available' }}
                            Panel)</span>
                    </p>

                    <a href="#" class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true"
                       aria-expanded="true"><span class="caret"></span> &nbsp;Switch</a>
                    <ul class="dropdown-menu">

                        <li role="separator" class="divider"></li>
                        <li>
                            <a href="{{route('back-to-main-panel')}}">
                                <i class="fa fa-refresh"></i> Refresh
                            </a>
                        </li>
                    </ul>
                    <a href="#"><i class="fa fa-circle text-success"></i> Online</a>
                </div>

            @endif

        </div>
        
        @if(view()->exists('default.sidebars.'. Session::get('ALIAS').'.'.$authUser->id))
            @include('default.sidebars.'. Session::get('ALIAS').'.'.$authUser->id)
        @else
            {{generateSideBar()}}
            @include('default.sidebars.'.Session::get('ALIAS').'.'.$authUser->id)
        @endif
    </section>
</aside>

