
@section('style')
    {!! Html::style('css/styles.css') !!}
@endsection


<div class="">
    <div class="box-body auto_scroll auto_scroll_other">


    <table id="studentList" class="table table-bordered table-striped">

        <caption class="report_details_ad text-bold">
             @if(isset($studentSection))
                <span>{{ trans('translate.exam') }} : {{ $exam->examination_name }}</span>
                @endif
                <br>
                @if(isset($studentSection))

                <span>{{ trans('translate.class') }} : {{ $studentClass->class_name }}</span>
                @endif
                 <br>
                @if(isset($studentSection))
                    <span>{{ trans('translate.section') }} : {{ $studentSection->section_name }}</span>
                @endif
                <br>
                @if(isset($studentSubject))
                    <span>{{ trans('translate.subject') }} : {{ $studentSubject->subject_name }}</span>
                @endif
        </caption>
        <thead>
        <tr>
            <th>{{ trans('translate.sl') }}</th>
            <th>{{ trans('translate.name') }}</th>
            <th>{{ trans('translate.roll_no') }}</th>

            @if(isset($markTypeWisePssMark) && !empty($markTypeWisePssMark))
                @foreach($markTypeWisePssMark as $type)
                    <th> {{ $type['markTypes']->marks_type }} ({{ $type['markTypeWisePssMark'] }} )</th>
                @endforeach
            @endif


            {{-- @if(isset($marksType) && !empty($marksType))
                @foreach($marksType as $type)
                    <th> {{ $type->marks_type }} </th>
                @endforeach
            @endif--}}
            <th>{{ trans('translate.total') }}</th>
            <th>{{ trans('translate.action') }}</th>
            <th>{{ trans('translate.results') }}</th>
        </tr>
        </thead>
        <tbody>
        @set('sl',1)

        @if(isset($studentList) && !$studentList->isEmpty() )

            @foreach($studentList as $stKey => $students)


                    <tr>
                        <td>{{$sl++}}</td>
                        <td>
                            {{ $students->translate($locale)? $students->first_name.' '.$students->last_name:$students->translate($defaultLocale)->first_name.' '.$students->translate($defaultLocale)->last_name }}
                        </td>
                        <td>
                            {{ $students->roll_no ?? 'NA' }}
                        </td>

                        @if(!is_null($studentMarks[$students->id]))

                            @set('stMarksTypes',json_decode($studentMarks[$students->id]->mark_types))
                        @else
                            @set('stMarksTypes',null)
                        @endif

                        @if(isset($markTypeWisePssMark) && !empty($markTypeWisePssMark))
                            @foreach($markTypeWisePssMark as $type)

                                <td>
                                    <input title="" type="text" class="form-control" value="{{ isset($stMarksTypes->{$type['markTypes']->id})? $stMarksTypes->{$type['markTypes']->id} : 0 }} "
                                           id ="mrk_tp_{{ $students->id."_".$type['markTypes']->id }}"
                                           name ="mrk_tp_{{ $students->id."_".$type['markTypes']->marks_type }}" class="mrk_tp_{{ $students->id."_".$type['markTypes']->marks_type }}" />

                                </td>

                            @endforeach
                        @endif



                        <td>
                            <input title="" type="text" value="{{ !is_null($studentMarks[$students->id]) && isset($studentMarks[$students->id]->total)? $studentMarks[$students->id]->total : 0 }} "
                                   id="mrk_ttl_{{ $students->id }}" class="form-control mrk_ttl_{{ $students->id }} mrk_ttl_common_cls" data-stdnid = "{{ $students->id }}"
                                   name="mrk_ttl_{{ $students->id }}"/>
                        </td>

                        <td>
                            <input type="button" data-roll = "{{ $students->roll_no }}" data-stdnid = "{{ $students->id }}" class=" btn btn-primary btn-block mrk_add_{{ $students->id }} mrk_add_common_cls" name="mrk_add_{{ $students->id }}" id="mrk_add_{{ $students->id }}" value="{{ isset($studentMarks[$students->id]->total) ? "Update" : "Add" }}"/>
                        </td>

                        <td>
                            <span id="mrk_rslt_{{ $students->id }}" class="mrk_rslt_{{ $students->id }}">{{ isset($studentMarks[$students->id]->total) ? "Saved" : "Not Saved" }}</span>
                        </td>


                    </tr>


            @endforeach
        @else

            <tr>
                <td>
                    <strong>Sorry !!!! ..No Students Found</strong>
                </td>
            </tr>

        @endif
        </tbody>

    </table>

    </div>
</div>
