@extends('default.admin.layouts.master')


@section('style')
    {!! Html::style('css/styles.css') !!}
@endsection
<style>
    .inner-view {
        padding: 10px 30px 0px 30px !important;
    }

    .table>tbody>tr>td, .table>tbody>tr>th, .table>tfoot>tr>td, .table>tfoot>tr>th, .table>thead>tr>td, .table>thead>tr>th {
        padding: 4px !important;

    }
</style>


@section('content')
    <div class="container-fluid min_height_area" >
        <div class="row">
            <div class="col-md-12">
                <div class="view-header">
                    <div class="col-md-7 col-md-6">

                        <button class="btn btn-primary"><span class="fa fa-file"></span> {{ trans('translate.edit') }}</button>
                    </div>
                    <div class="col-md-5 col-md-6 view">
                        <ul class="breadcrumb text-right">
                            <li>
                                <span class="glyphicon glyphicon-folder-close" aria-hidden="true"></span>
                                <a href="#"> {{ trans('sidebar.dashboard') }}</a></li>
                            <li class="active"> {{ trans('sidebar.notice') }}</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div> <!--row-->

        <div class="inner-view">
            <div class="row">
<div class="col-md-12">
    <table class="table table-bordered table-responsive ">
        <thead>
        <tr class="bg-info">
            <th colspan="4" class="th_font text-center" style="color:black">
                {{ trans('sidebar.notice_details') }}
            </th>
        </tr>
        </thead>
        <tbody>

        <tr>
            <td class="th_width_100">{{ trans('sidebar.title') }} </td>
            <td>  {{ $noticeData->translate($locale)? $noticeData->notice_name:$noticeData->translate($defaultLocale)->notice_name }}</td>
        </tr>

        <tr>
            <td>{{ trans('translate.description') }} </td>
            <td> {!! html_entity_decode($noticeData->translate($locale)? $noticeData->notice_description:$noticeData->translate($defaultLocale)->notice_description)!!}</td>
        </tr>

        <tr>
            @if($noticeData->notice_image != null)
                <td>Attachment</td>

                <td><a href="#" data-toggle="modal" data-target="#myModal"> View</a> </td>
            @endif
        </tr>


        <!-- Modal -->
        <div id="myModal" class="modal fade" role="dialog">
            <div class="modal-dialog">

                <!-- Modal content-->
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                        <h5 class="modal-title">{{ $noticeData->translate($locale)? $noticeData->notice_name:$noticeData->translate($defaultLocale)->notice_name }}</h5>
                    </div>
                    <div class="modal-body">
                        <p style="text-align: center">  {!!  Html::image('/img/noticeImage/'.$noticeData->notice_image, 'User Image', ['class'=>'rounded mx-auto d-block']) !!}</p>

                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    </div>
                </div>

            </div>
        </div>
        <tr>
            <td>{{ trans('sidebar.date') }} </td>

            <td>{{ date('d-m-y',strtotime($noticeData->notice_publish_date))}} </td>
        </tr>

        </tbody>
    </table>

    <div class="clearfix"></div>
</div>

            </div>
        </div>

    </div>



@endsection


