@extends('default.site.layout.master')


@section('style')
    {!! Html::style('css/styles.css') !!}
@endsection



@section('content')
    <div class="container-fluid" style="min-height: 1215px;">
        <div class="row">
            <div class="col-md-12">
                <div class="view-header">
                    <section class="content-header">
                        <ol class="breadcrumb">

                            <li>
                                <span class="glyphicon glyphicon-folder-close" aria-hidden="true"></span>
                                <a href="#"> {{ trans('sidebar.dashboard') }}</a></li>
                            <li>Leave Management</li>
                            <li>Leave</li>
                            <li class="active"> {{ trans('sidebar.notification') }}</li>


                        </ol>
                    </section>
                </div>
            </div>
        </div>



            <div class="row">
                <div class="col-xs-12 col-sm-12 col-md-12">
                    <div class="panel panel-default">
                        <div class="panel-heading">
                            <i class="fa fa-address-card-o"></i>   {{ $notification->data['title'] ?? '' }}
                        </div>
                        <div class="panel-body">
                            <div class="col-xs-12 col-sm-12 col-md-4"></div>
                            <div class="col-xs-12 col-sm-12 col-md-4" style="text-align:justify">
                                {!! html_entity_decode( $notification->data['data'])!!}
                            </div>
                            <div class="col-xs-12 col-sm-12 col-md-4"></div>

                        </div>

                        <br>
                        <div class="panel-footer">
                            <a href="#" data-toggle="modal" data-target="#myModal"><i class="fa fa-paperclip"></i>
                                Attachment
                            </a>
                          <span style="float: right;"> <i class="fa fa-clock-o"></i> {{ date('d-m-Y h:i:s A',strtotime($notification->created_at))}} </span>
                        </div>
                    </div>
                </div>

                <!-- Modal -->
                <div id="myModal" class="modal fade" role="dialog">
                    <div class="modal-dialog">
                        <!-- Modal content-->
                        <div class="modal-content">
                            <div class="modal-header">
                                <button type="button" class="close" data-dismiss="modal">&times;</button>
                                <h5 class="modal-title"></h5>
                            </div>
                            <div class="modal-body">
                                <p style="text-align:center">  {!!  Html::image($notification->data['image_link'] ?? null, 'Notice Image', ['class'=>'img-responsive']) !!}</p>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            </div>
                        </div>
                    </div>
                </div>

            </div>


    </div>



@endsection


