<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>{{$view_title}}</title>

    <style type="text/css">

        * {
            font-family: Verdana, Arial, sans-serif;
        }
        table{
            font-size: x-small;
        }
        tfoot tr td{
            font-weight: bold;
            font-size: x-small;
        }

        .amount-right{
            text-align:right;
        }

        .gray {
            background-color: lightgray
        }

    </style>

</head>
<body>
@include('default.site.layout.pdf-header')

    <table width="100%">

        <thead style="background-color: #e2e6e9;">
        <tr>
            <td align="center" width="8%" style="padding:3px !important"><b>Code</b></td>
            <td align="left" style="padding:3px !important"><b>Particular</b></td>
            <td align="right" style="padding:3px !important"><b>Debit</b></td>
            <td align="right" style="padding:3px !important"><b>Credit</b></td>
        </tr>
        </thead>
        <tbody>
        @foreach($final_ledger_data_list as $key=>$value)

                <tr>
                    <td width="8%" class="no-padding" style="text-align:center; padding:3px !important;"
                    >

                            {{$value['ledger_account']['ledger_code']}}

                    </td>
                    <td  class="no-padding" style="text-align:left; padding:3px !important;"
                    >

                            {{$value['ledger_account']['name']}}

                    </td>
                    <td  class="no-padding"  style="text-align:right; padding:3px !important;">
                        @if($value['total_amount'] >= 0)
                            <span>{{number_format($value['total_amount'])}}</span>
                        @endif

                    </td>
                    <td  class="no-padding" style="text-align:right; padding:3px !important;">
                        @if($value['total_amount'] < 0)
                            <span>{{number_format($value['total_amount'] * -1)}}</span>
                        @endif
                    </td>
                </tr>
        @endforeach
        @foreach($fixed_depriciation_list as $kk=>$vl)

                <tr>
                    <td class="no-paddng" style="text-align:center; padding:3px !important;">
                        <span>{{$vl['ledger_code']}}</span>
                    </td>
                    <td class="no-paddng" style="text-align:left; padding:3px !important;">
                        <span>{{$vl['ledger_account']}}</span>
                    </td>
                    <td class="no-padding" style="text-align:right; padding:3px !important;">
                        @if($vl['entry'] == 'dr')
                            <span>
                              {{
                              $vl['amount']
                              }}
                            </span>
                        @endif
                    </td>
                    <td class="no-padding" style="text-align:right; padding:3px !important;">
                        @if($vl['entry'] == 'cr')
                            <span>
                              {{
                              $vl['amount']
                              }}
                            </span>
                        @endif
                    </td>
                </tr>
        @endforeach
        <tr>
            <td colspan="2" class="no-padding"  style="text-align:right; padding:3px !important; background-color:whitesmoke">
                <span><b>Total</b></span>
            </td>
            <td class="no-padding"  style="text-align:right; padding:3px !important; background-color:whitesmoke">
                <span><b>TK {{number_format($total_debit_amount)}}</b></span>
            </td>
            <td class="no-padding"  style="text-align:right; padding:3px !important; background-color:whitesmoke">
                <span><b>TK {{number_format($total_credit_amount)}}</b></span>
            </td>

        </tr>


        </tbody>


        {{--<tbody></tbody>--}}
    </table>
    <table width="100%">
{{--        <span>Print Date: {{$print_date}}</span>--}}
    </table>
</body>


<style>
    @page {
        size: a4;
        margin: 1px 0;
    }
    body {
        margin: 6px 6px;
        /*border:1px dotted black;*/
    }

</style>
</html>
