<!DOCTYPE html>
<html>
<head>
    <title>{{$viewType}}</title>
    <meta charset="utf-8">
    <meta http-equiv="Content-Type" content="text/html; charset=utf8_decode"/>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <style type="text/css">


        body, h1 {
            font-family: 'bangla', 'Arial', 'verdana', sans-serif;
        }
        tr:not(:first-child) {
            border-style: dotted;
        }
        table {
            border-collapse: collapse;
            text-align: center;
        }

        .student-info tr td{
            border: 0.5px solid gray;
            text-align:left;
            padding:2px;

            @if ($language_set=='bn' || \Session::get('language')=='Bangla')
                font-size: 13px;
            @else
                @if (count($student_list->siteStudentAdmissionEducationQualification)==1)
                    font-size: 12px;
                @else
                    font-size: 11.5px;
                @endif;

            @endif;
        }

        .localguarding-info tr td{
            border: 0.5px solid gray;
            text-align:left;
            padding:2px;

            @if ($language_set=='bn' || \Session::get('language')=='Bangla')
                font-size: 13px;
            @else
                @if (count($student_list->siteStudentAdmissionEducationQualification)==1)
                    font-size: 12px;
                @else
                    font-size: 11.5px;
                @endif;
            @endif
        }

        .signaturepart tr td{
            text-align:left;


            @if ($language_set=='bn' || \Session::get('language')=='Bangla')
                font-size: 13px;
            @else
                @if (count($student_list->siteStudentAdmissionEducationQualification)==1)
                    font-size: 12px;
                @else
                    font-size: 11.5px;
                @endif;
            @endif
        }

        .custom-font{
            @if ($language_set=='bn' || \Session::get('language')=='Bangla')
                font-size: 13px;
            @else
                @if (count($student_list->siteStudentAdmissionEducationQualification)==1)
                    font-size: 12px;
                @else
                    font-size: 11.5px;
                @endif;
            @endif
        }

        .title{
            @if ($language_set=='bn' || \Session::get('language')=='Bangla')
                font-size: 20px;
            @else
                font-size: 17px;
            @endif
        }


        .styleapply span{
            @if ($language_set=='bn' || \Session::get('language')=='Bangla')
                font-weight:bolder;
            @else
                font-weight:bold;
            @endif

        }

        @page {
            /*    size: 8.5in 11in;  <length>{1,2} | auto | portrait | landscape */
            /* 'em' 'ex' and % are not allowed; length values are width height */
            margin: 1%; /* <any of the usual CSS values for margins> */
        }

    </style>
</head>

<body style="margin-left:20px">
{{--@include('header')--}}

<div style="padding:0px 25px;">


    <table style="width:100%">
        <tr>

            <td width="20%" style="text-align: left">

                {{ __('web.form.form_no',[],$language_set) }}:

              <b>{{$student_list->admission_form_no}}</b><br>

                 @if($getDeclaredList->unique_code_show_status)
                    {{ __('web.form.unicode',[],$language_set) }}:
                    <b>{{$student_list->unique_code}}</b><br>
                @endif
            </td>
            <td width="60%" style="text-align: center; padding:10px 10px 2px 10px;">
                {{--<span><img style=" padding-top: 0px;" width="40px" height="30px;"   src="{!! asset(Session::get('LOGO_PATH')) !!}"></span>--}}
                {{--<span  style="font-size: 20px;font-weight: bolder;">  {{\Session::get('FULL_NAME')}}</span><br>--}}
                @if ($language_set=='bn' || \Session::get('language')=='Bangla')
                    <span style="font-size: 22px;"> {{trans($site_list->site_name,[],$language_set)}}</span><br>
                @else
                    <span style="font-size: 22px;"> <b>{{trans($site_list->site_name,[],$language_set)}}</b></span><br>
                @endif

            </td>
            <td width="20%">
                @if ($student_list->studentType)
                    <span style="font-size: 14px;">{{ __('web.form.student_type',[],$language_set) }}:
                        &nbsp; <b>{{$student_list->studentType->student_type_name}} </b>
                    </span>
                @endif
            </td>
        </tr>
        <tr>
            <td colspan="3" style="text-align: center; padding:2px;">
                @if ($language_set=='bn' || \Session::get('language')=='Bangla')
                    <span style="font-size: 10px;"> {{trans($site_list->address,[],$language_set)}}</span><br>
                @else
                    <span style="font-size: 10px;"> {{trans($site_list->address,[],$language_set)}}</span><br>
                @endif
            </td>
        </tr>
        <tr>
            <td colspan="3" style="text-align: center; padding:2px;">
                <span style="font-size: 10px;">{{ __('web.form.phone',[],$language_set) }}: {{$site_list->site_phone}}</span>
            </td>
        </tr>
        <tr>
            <td colspan="3" style="text-align: center; padding:2px;">
                 @if($site_list->eiin)
                  <span style="font-size: 10px;">{{ __('web.form.eiin',[],$language_set) }} :</span>
                  <span style="font-size: 10px;">{{$site_list->eiin}}</span>
                @endif
                @if($site_list->college_code)
                  <span style="font-size: 10px;">, {{ __('web.form.college_code',[],$language_set) }} :</b></span>
                  <span style="font-size: 10px;">{{$site_list->college_code}}</span>
                @endif
                @if($site_list->nu_code)
                  <span style="font-size: 10px;">, {{ __('web.form.nu_code',[],$language_set) }} :</span>
                  <span style="font-size: 10px;">{{$site_list->nu_code}}</span>
                @endif
            </td>
        </tr>



    </table>

    <table style="width:100%; height: 50% !important;">
        <tr >
            <td class="no-padding custom-font" style="text-align: left; width:25%">
                {{-- || \Session::get('language')=='Bangla' --}}
                @if($getDeclaredList->office_will_fillup_text_show_status)
                    <span style="font-size: 13px;">{{ __('web.form.nu_code',[],$language_set) }}</span><br>
                <br>
                 @endif
                {{-- <span>{{ __('general.year',[],$language_set) }}: <b>{{trans($student_list->year->year_name,[],$language_set)}}</b></span><br> --}}
                <span>{{ __('web.form.admission_year',[],$language_set) }}: <b>2025</b></span><br>
                <span>{{ __('general.class',[],$language_set) }}: <b>{{trans($student_list->stClass->class_name,[],$language_set)}}</b></span><br>
                @if($student_list->classGroup)
                    <span>{{ __('general.acc_class_group',[],$language_set) }}: <b>{{$student_list->classGroup->group_name}}</b></span><br>
                @endif
                <span>{{ __('general.roll_no',[],$language_set) }}: <b>{{$student_list->student_roll_number?$roll_number:''}}</b></span><br>
                <span>{{ __('general.section',[],$language_set) }}:</span><br>
                <span>{{ __('general.acc_session',[],$language_set) }}: <b>{{trans($student_list->session?$student_list->session->session_name:'',[],$language_set)}}</b></span><br>
                <span>{{ __('web.form.admission_date',[],$language_set) }}:<b> {{date('d-m-Y', strtotime($student_list->created_at))}}</b></span><br>

            </td>
            <td  style="text-align: center;  padding:5px; width:50%">
                <span  style="font-size: 20px;font-weight: bolder;">
                    <img style="padding-top: 0px;" width="80px" height="80px;" src="{!! public_path($site_list->site_logo) !!}">
                </span><br>

                @if ($language_set=='bn' || \Session::get('language')=='Bangla')
                    <span  class="styleapply title">{{ __('web.form.admission_form_title',[],$language_set) }}</span><br>

                @else
                    <span  class="title"><b>{{ __('web.form.admission_form_title',[],$language_set) }}</b></span><br>
                @endif

                {{-- @if($student_list->stClass)
                    @if ($language_set=='bn' || \Session::get('language')=='Bangla')
                        <span class="styleapply" style="font-size: 15px;">{{trans($student_list->stClass->class_name,[],'bn')}}</span><br>
                    @else
                        <span style="font-size: 15px;"><b>{{$student_list->stClass->class_name}}</b></span><br>
                    @endif
                @endif --}}

                {{-- @if($student_list->classGroup)
                    @if ($language_set=='bn' || \Session::get('language')=='Bangla')
                        <span  class="styleapply" style="font-size: 17px;">{{$student_list->classGroup->group_name}}</span><br>
                    @else
                        <span style="font-size: 17px;"><b>{{$student_list->classGroup->group_name}}</b></span><br>
                    @endif
                @endif --}}
            </td>
            <td  style="text-align: center; padding:5px; width:25%">
                <img style="padding-top: 0px;" width="120px" height="120px;" src="{!! public_path('/uploads/' . $student_list->student_image) !!}">
            </td>
        </tr>
    </table>

    <table class="signaturepart" style="width:100%">
        <tr>
            <td style="text-align: left;  width:100%">
                @if ($student_list->transaction_number)
                    <span width="100%">{{ __('web.form.transaction_number',[],$language_set) }}:</span>
                    <span style="color:maroon;font-size:14px"><b>{{$student_list->transaction_number}}</b></span>
                @endif
            </td>

            {{--<td style="text-align: left;  width:100%">--}}
                {{--@if ($student_list->transaction_number)--}}
                    {{--<span width="100%">{{ __('web.form.board_roll_number') }}:</span>--}}
                    {{--<span style="color:maroon"><b>{{$student_list->board_roll_number}}</b></span>--}}
                {{--@endif--}}
            {{--</td>--}}
        </tr>
    </table>




    <table class="student-info" style="width:100%">

        <tr>
            <td>
                {{ __('web.form.name_english',[],$language_set) }}
            </td>


            @if ($language_set=='bn' || \Session::get('language')=='Bangla')
                <td style="width: 80%">
                    {{$student_list->full_name}}
                </td>

            @else
                <td style="width: 70%">
                    {{$student_list->full_name}}
                </td>
            @endif


        </tr>
        <tr>
            <td>
                {{ __('web.form.name_native_language',[],$language_set) }}
            </td>

            @if ($language_set=='bn' || \Session::get('language')=='Bangla')
                <td style="width: 80%">
                    @if ($student_list->name_native_language)
                        {{$student_list->name_native_language}}
                    @endif

                </td>

            @else
                <td style="width: 70%">
                    @if ($student_list->name_native_language)
                        {{$student_list->name_native_language}}
                    @endif
                </td>
            @endif
        </tr>


        {{--Father Name--}}

        <tr>
            <td>
                {{ __('web.form.father_name_english',[],$language_set) }}
            </td>

            @if ($language_set=='bn' || \Session::get('language')=='Bangla')
                <td style="width: 80%">
                    @if ($student_list->father_name)
                        {{$student_list->father_name}}
                    @endif
                </td>

            @else
                <td style="width: 70%">
                    @if ($student_list->father_name)
                        {{$student_list->father_name}}
                    @endif
                </td>
            @endif
        </tr>
        <tr>
            <td>
                {{ __('web.form.father_name_native_language',[],$language_set) }}
            </td>

            @if ($language_set=='bn' || \Session::get('language')=='Bangla')
                <td style="width: 80%">
                    @if ($student_list->father_name_native_language)
                        {{$student_list->father_name_native_language}}
                    @endif
                </td>

            @else
                <td style="width: 70%">
                    @if ($student_list->father_name_native_language)
                        {{$student_list->father_name_native_language}}
                    @endif
                </td>
            @endif
        </tr>


        {{--Mother Name--}}

        <tr>
            <td>
                {{ __('web.form.mother_name_english',[],$language_set) }}
            </td>

            @if ($language_set=='bn' || \Session::get('language')=='Bangla')
                <td style="width: 80%">
                    @if ($student_list->mother_name)
                        {{$student_list->mother_name}}
                    @endif

                </td>

            @else
                <td style="width: 70%">
                    @if ($student_list->mother_name)
                        {{$student_list->mother_name}}
                    @endif
                </td>
            @endif
        </tr>
        <tr>
            <td>
                {{ __('web.form.mother_name_native_language',[],$language_set) }}
            </td>

            @if ($language_set=='bn' || \Session::get('language')=='Bangla')
                <td style="width: 80%">
                    @if ($student_list->mother_name_native_language)
                        {{$student_list->mother_name_native_language}}
                    @endif

                </td>

            @else
                <td style="width: 70%">
                    @if ($student_list->mother_name_native_language)
                        {{$student_list->mother_name_native_language}}
                    @endif
                </td>
            @endif
        </tr>

        {{--present Address--}}

        <tr>
            <td>
                {{ __('web.form.present_address',[],$language_set) }}
            </td>

            @if ($language_set=='bn' || \Session::get('language')=='Bangla')
                <td style="width: 80%">
                    @if ($student_list->present_address_care_of)
                        {{$student_list->present_address_care_of}}
                    @endif

                    @if ($student_list->present_address)
                        ,{{$student_list->present_address}}
                    @endif

                    @if ($student_list->presentThana)
                        ,{{$student_list->presentThana->thana_name}}
                    @endif

                    @if ($student_list->presentDistrict)
                        ,{{$student_list->presentDistrict->district_name}}
                    @endif


                </td>

            @else
                <td style="width: 70%">
                    @if ($student_list->present_address_care_of)
                        {{$student_list->present_address_care_of}}
                    @endif

                    @if ($student_list->present_address)
                        ,{{$student_list->present_address}}
                    @endif

                    @if ($student_list->presentThana)
                        ,{{$student_list->presentThana->thana_name}}
                    @endif

                    @if ($student_list->presentDistrict)
                        ,{{$student_list->presentDistrict->district_name}}
                    @endif
                </td>
            @endif
        </tr>

        {{--Permanent Address--}}

        <tr>
            <td>
                {{ __('web.form.permanent_address',[],$language_set) }}
            </td>

            @if ($language_set=='bn' || \Session::get('language')=='Bangla')
                <td style="width: 80%">

                    @if ($student_list->permanent_address_care_of)
                        {{$student_list->permanent_address_care_of}}
                    @endif

                    @if ($student_list->permanent_address)
                        ,{{$student_list->permanent_address}}
                    @endif

                    @if ($student_list->permanentThana)
                        ,{{$student_list->permanentThana->thana_name}}
                    @endif

                    @if ($student_list->permanentDistrict)
                        ,{{$student_list->permanentDistrict->district_name}}
                    @endif

                </td>

            @else
                <td style="width: 70%">
                    @if ($student_list->permanent_address_care_of)
                        {{$student_list->permanent_address_care_of}}
                    @endif

                    @if ($student_list->permanent_address)
                        ,{{$student_list->permanent_address}}
                    @endif

                    @if ($student_list->permanentThana)
                        ,{{$student_list->permanentThana->thana_name}}
                    @endif

                    @if ($student_list->permanentDistrict)
                        ,{{$student_list->permanentDistrict->district_name}}
                    @endif
                </td>
            @endif
        </tr>

    </table>




    <div class="styleapply" style="margin-top:5px;">
        <table class="student-info" style="width:100%">

            <tr>
                <td style="width:34%">

                    <span>{{ __('web.form.date_of_birth',[],$language_set) }}:</span>
                    &nbsp;{{date('d-m-Y', strtotime($student_list->date_of_birth))}}

                </td>
                <td style="width:33%">

                    <span>{{ __('web.form.contact_number',[],$language_set) }}:</span>
                    @if ($student_list->student_contact_number)
                        {{$student_list->student_contact_number}}
                    @endif

                </td>
                <td style="width:33%">
                <span>{{ __('web.form.bcn',[],$language_set) }}:</span>
                    @if ($student_list->bcn)
                        {{$student_list->bcn}}
                    @endif
                </td>
            </tr>

        </table>
        <table class="student-info" style="width:100%">

        <tr>
            <td style="width:34%">

                <span>{{ __('web.form.religion',[],$language_set) }}:</span>
                &nbsp;{{$student_list->religion->name}}
            </td>
            <td style="width:33%">

                <span>{{ __('web.form.gender',[],$language_set) }}:</span>
                &nbsp;{{$student_list->gender->gender_name}}
            </td>
            <td style="width:33%">

                <span>{{ __('web.form.blood_group',[],$language_set) }}:</span>

                @if ($student_list->bloodGroup)
                    &nbsp;{{$student_list->bloodGroup->blood_group_name}}
                @endif


            </td>

        </tr>
        {{-- <tr>
            <td>
                <span>{{ __('web.form.student_type',[],$language_set) }}:</span>
                @if ($student_list->studentType)
                    &nbsp;{{$student_list->studentType->student_type_name}}
                @endif
             </td>
            <td> </td>
            <td> </td>
        </tr> --}}

    </table>
    </div>

    <div class="styleapply" style="margin-top:5px;">
        <table class="student-info" style="width:100%">
            <tr>
                <td style="width:40%">

                    <span>{{ __('web.form.father_contact_number',[],$language_set) }}:</span>
                    @if ($student_list->father_contact_number)
                        &nbsp;{{$student_list->father_contact_number}}
                    @endif
                </td>
                <td style="width:30%">

                    <span>{{ __('web.form.father_nid',[],$language_set) }}:</span>
                    @if ($student_list->father_nid)
                        &nbsp;{{$student_list->father_nid}}
                    @endif
                </td>
                <td style="width:30%">
                    <span>{{ __('web.form.father_bcn',[],$language_set) }}:</span>
                    @if ($student_list->father_bcn)
                        &nbsp;{{$student_list->father_bcn}}
                    @endif
                </td>
            </tr>

            <tr>
                <td style="width:33%">

                    <span>{{ __('web.form.mother_contact_number',[],$language_set) }}:</span>
                    @if ($student_list->mother_contact_number)
                        &nbsp;{{$student_list->mother_contact_number}}
                    @endif
                </td>
                <td style="width:33%">

                    <span>{{ __('web.form.mother_nid',[],$language_set) }}:</span>
                    @if ($student_list->mother_nid)
                        &nbsp;{{$student_list->mother_nid}}
                    @endif
                </td>
                <td style="width:33%">

                    <span>{{ __('web.form.mother_bcn',[],$language_set) }}:</span>
                    @if ($student_list->mother_bcn)
                        &nbsp;{{$student_list->mother_bcn}}
                    @endif
                </td>
            </tr>
        </table>
    </div>
    @if($getDeclaredList->guardian_information_add)
        <div class="styleapply" style="margin-top:5px;">
            <table class="student-info" style="width:100%">
                <tr>
                    <td><b>{{__('web.form.father_occupation')}}:</b> {{$student_list->fatherOccupation?$student_list->fatherOccupation->occupation_name:''}}</td>
                    <td><b>{{__('web.form.father_yearly_income')}}:</b> {{$student_list->father_yearly_income}} </td>
                    <td><b>{{__('web.form.father_email')}}:</b> {{$student_list->father_email}} </td>
                </tr>
                <tr>
                    <td><b>{{__('web.form.mother_occupation')}}:</b> {{$student_list->motherOccupation?$student_list->motherOccupation->occupation_name:''}}</td>
                    <td><b>{{__('web.form.mother_yearly_income')}}:</b> {{$student_list->mother_yearly_income}} </td>
                    <td><b>{{__('web.form.mother_email')}}:</b> {{$student_list->mother_email}} </td>
                </tr>
            </table>
        </div>
    @endif
    @if($getDeclaredList->local_guardian_detail_information_add)
        <div class="styleapply" style="margin-top:5px;">
            <table class="localguarding-info" style="width:100%">
            <tr>
                <td rowspan="3" style="width: 20%">
                    <span> {{ __('web.form.local_guardian_info',[],$language_set) }} </span>
                </td>
                <td colspan="2">
                    <span>{{ __('web.form.name',[],$language_set) }}  :</span>
                    @if ($student_list->local_guardian_name)
                        &nbsp;{{$student_list->local_guardian_name}}
                    @endif
                </td>
            </tr>
            <tr>
                <td>
                    <span> {{ __('web.form.relation',[],$language_set) }} :</span>
                    @if ($student_list->relation)
                        &nbsp;{{$student_list->relation->relation_name}}
                    @endif
                </td>
                <td>
                    <span> {{ __('web.form.guardian_contact_number',[],$language_set) }} :</span>
                    @if ($student_list->local_gurdian_mobile)
                        &nbsp;{{$student_list->local_gurdian_mobile}}
                    @endif
                </td>
            </tr>

            <tr>
                <td colspan="2">
                    <span> {{ __('web.form.address',[],$language_set) }} :</span>
                    @if ($student_list->local_gurdian_address)
                        &nbsp;{{$student_list->local_gurdian_address}}
                    @endif
                </td>
            </tr>
        </table>
        </div>
    @endif

    <div class="styleapply" style="margin-top:5px;">
        @if (count($student_list->siteStudentAdmissionEducationQualification)>0)
            @foreach($student_list->siteStudentAdmissionEducationQualification as $key=>$item)

                <table class="localguarding-info" style="width:100%">

                    <tr>

                        <td rowspan="5" style="width: 20%">
                            @if ($language_set=='bn' || \Session::get('language')=='Bangla')
                                {{trans($item->examination->examination_name,[],'bn')}}
                            @else
                                <span>{{$item->examination->examination_name}}</span>
                            @endif

                        </td>
                        <td colspan="2">
                            <span>{{ __('web.form.institution_name',[],$language_set) }}  :</span>


                            {{$item->institution_name}}

                        </td>


                    </tr>
                    <tr>
                        <td colspan="2">
                            <span>{{ __('web.form.board_university',[],$language_set) }} :</span>

                            &nbsp; {{$item->academicBoard->name}}
                        </td>

                    </tr>


                    <tr>
                        <td>
                            <span> {{ __('web.form.roll_number',[],$language_set) }} :</span>
                            &nbsp; {{$item->board_roll_number}}
                        </td>
                        <td>
                            <span> {{ __('web.form.registration_number',[],$language_set) }} :</span>
                            &nbsp; {{$item->board_registration_number}}
                        </td>
                    </tr>

                    <tr>
                        <td>
                            <span> {{ __('web.form.session',[],$language_set) }} :</span>
                            &nbsp; {{$item->academicSession?$item->academicSession->session_name:''}}
                        </td>
                        <td>
                            <span> {{ __('web.form.passing_year',[],$language_set) }} :</span>
                            &nbsp; {{$item->passing_year}}
                        </td>

                    </tr>
                    <tr>
                        <td>
                            <span> {{ __('web.form.gpa_with_optional',[],$language_set) }} :</span>
                            &nbsp; {{$item->gpa_with_optional}}
                        </td>
                        <td>
                            <span> {{ __('web.form.gpa_without_optional',[],$language_set) }} :</span>
                            &nbsp; {{$item->gpa_without_optional}}
                        </td>
                    </tr>




                </table>

            @endforeach
        @endif
    </div>


    <div class="styleapply" style="margin-top:5px;">
        <table class="localguarding-info" style="width:100%">

        <tr>

            <td rowspan="3" style="width: 20%">

                <span> {{ __('web.form.study_subjects',[],$language_set) }} (HSC)</span></span>
            </td>
            <td>
                <span> {{ __('web.form.general_subject',[],$language_set) }}  :</span>
                @foreach($general_subject_list as $key=>$item)
                    {{ $loop->first ? '' : '; ' }}
                    {{$item->subject_name}}

                    @if($item->subject_code)
                        - {{$item->subject_code}}
                    @endif

                @endforeach
            </td>


        </tr>
        <tr>
            <td>
                <span> {{ __('web.form.compulsory_subject',[],$language_set) }}  :</span>
                @foreach($compulsory_subject_list as $key=>$item)
                    {{ $loop->first ? '' : '; ' }}
                    {{$item->subject_name}}

                    @if($item->subject_code)
                        - {{$item->subject_code}}
                    @endif

                @endforeach
            </td>
        </tr>


        <tr>
            <td>
                <span> {{ __('web.form.optional_subject',[],$language_set) }}  :</span>
                @foreach($optional_subject_list as $key=>$item)
                    {{ $loop->first ? '' : '; ' }}
                    {{$item->subject_name}}

                    @if($item->subject_code)
                        - {{$item->subject_code}}
                    @endif

                @endforeach
            </td>
        </tr>
    </table>
    </div>

    <div class="styleapply" style="margin-top:5px;">
        <table class="signaturepart" style="width:100%">
        <tr>
            <td>
                {{ __('web.form.commitment_one',[],$language_set) }}
            </td>
        </tr>
    </table>
    </div>
    <br>

    <div class="styleapply">
        <table class="signaturepart" style="width:100%">
            <tr>
                <td>
                    {{ __('web.form.date',[],$language_set) }}
                    ........................
                </td>
                <td style="text-align:right;">
                    {{ __('web.form.applicant_signature',[],$language_set) }}
                     ....................................
                </td>
            </tr>
        </table>
        <br>
        <table class="signaturepart" style="width:100%">
            <tr>
                <td>
                    {{ __('web.form.guardian_commitment',[],$language_set) }}
                </td>
            </tr>
        </table>
        <br>
        <table class="signaturepart" style="width:100%">
            <tr>
                <td>
                </td>
                <td style="text-align:right;">
                    {{ __('web.form.guardian_signature',[],$language_set) }}
                    ....................................

                </td>
            </tr>
        </table>

        <table class="signaturepart" style="width:100%">
            <tr>
                <td>
                    {{ __('web.form.permition_granted',[],$language_set) }}
                </td>
            </tr>
        </table>
        <br>
        <br>


        <table class="signaturepart" style="width:100%">
        <tr>
            <td colspan="2">
                 .................................... <br>
                <span>{{$designation_name}} </span><br>
                {{trans($site_list->site_name,[],$language_set)}}
            </td>
        </tr>
    </table>
    </div>
    <br>

    <div class="styleapply" style="margin-top:5px;">
        <table class="signaturepart" style="width:100%">
            <tr>
                <td colspan="2">
                   <span>
                    {{ __('web.form.form_nb',[],$language_set) }}
                    </span>
                    {{ __('web.form.nb_one',[],$language_set) }}

                    @if (count($student_list->siteStudentAdmissionEducationQualification)>0)
                        @foreach($student_list->siteStudentAdmissionEducationQualification as $key=>$item)
                            {{ $loop->first ? '' : '; ' }}
                            {{$item->examination->examination_name}}

                        @endforeach
                    @endif
                    {{ __('web.form.nb_two',[],$language_set) }}
                    {{ __('web.form.nb_three',[],$language_set) }}


                </td>
            </tr>
        </table>
    </div>


</div>
<div style="page-break-after: avoid;page-break-inside:avoid;"></div>


</body>
</html>
