@extends('default.site.layout.master')
@section('content')

    <div class="container-fluid min_height_area">
        <div class="row">
            <div class="col-md-12">
                <div class="view-header">
                    <section class="content-header">
                        <ol class="breadcrumb">
                            <li>
                                <span class="fa fa-dashboard" aria-hidden="true"></span>
                                <a href="{{route('admin')}}">{{ trans('translate.dashboard') }}</a></li>
                            <li class="active text-capitalize">{{ request()->route()->getName() }}</li>
                        </ol>
                    </section>
                </div>
            </div>
        </div>


        <div class="box box-for-table">
            <div class="box-header">
                <div class="row">
                    <div class="col-sm-5 col-md-5">

                        Attendance List
                    </div>

                    <div class="col-sm-5 col-md-5 no-padding">
                        <div class="box-tools">
                        </div>
                    </div>
                </div>
            </div>
            <!-- /.box-header -->
            <div class="box-body table-responsive no-padding">
                <table class="table table-bordered table-hover">
                    <thead>
                    <tr>
                        <th>{{ trans('translate.sl') }}
                        </th>
                        <th>Date
                        </th>
                        <th>In
                        </th>
                        <th>Out</th>
                        <th>Late</th>
                    </tr>
                    </thead>
                    <tbody>
                    @set('sl',1)
                    @foreach($data as $key =>  $att)
                        <tr>
                            <td>{{$sl++}} </td>
                            <td>
                                {{date('d M Y', strtotime($att->present_date)) }}
                            </td>
                            <td>   @if($att->in_time)
                                    {{ date('h:i:s A', strtotime( $att->in_time))}}
                                @endif
                            </td>
                            <td>
                                @if($att->out_time)
                                    {{ date('h:i:s A', strtotime($att->out_time)) }}
                                @endif
                            </td>
                            <td>{{ $att->late_status ?'Yes':'No' }}</td>
                        </tr>
                    @endforeach

                    </tbody>
                    <tfoot>
                    <tr>
                        <td colspan="8">
                            <div class="pagination">
                                {!!   str_replace('/?','?',$data->render() ) !!}
                            </div>
                        </td>
                    </tr>
                    @if(count($data)<1)
                        <tr>
                            <td colspan="8" class="error">No Data Found!</td>
                        </tr>
                    @endif
                    </tfoot>
                </table>
            </div>
            <!-- /.box-body -->
        </div>

    </div>



@endsection


@section('hscripts')



@endsection

