<!DOCTYPE html>
<html>
<head>

    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no'
          name='viewport'>

    <title>{{$report_tittle}}</title>

    <style>

        @font-face {
            font-family: 'Verdana';
            font-weight: 100;
            font-style: normal;
            font-variant: normal;
            src: url("{{public_path()}}/fonts/Verdana.ttf") format("truetype");
        }


        body{
            font-family: "Verdana", sans-serif;
            font-size: 12px;
        }


        .tittle {

            font-size: 11px;
        }

        .data-table td {
            border: 1px solid #999999;
            text-align: center;
        }




    </style>

</head>
<body>

@include('default.site.layout.pdf-header')

<p style="margin-top:-10px; font-size: 12px; text-align: right;">Date: {{$att_date}}</p>

<div>
    <table class="data-table" cellspacing="0" border="0" width="100%;" style="">

        <thead class="tittle">
        <tr>
            <td style="width: 1px">S/L</td>
            <td>Name</td>
            <td>Shift</td>
            <td>In</td>
            <td>Out</td>
            {{-- <td>Late Status</td> --}}

        </tr>
        </thead>


        <tbody>
        @foreach($emp_list as $key => $value)

            <tr>
                <td>{{$key +1}}</td>
                <td>
                    {{$value->employee->first_name ?? 'na'}}    {{$value->employee->last_name ?? ''}}
                    <br>
                  <span style="font-size: 10px">  ( {{$value->employee->designation->name ?? 'n/a'}} )</span>
                </td>
                <td>{{$value->shiftDetail->shift->shift_name ?? 'n/a'}}</td>
                <td>
                  {{$value->in_time ? date('h:i:s A',strtotime($value->in_time)) : 'n/a'}}
                </td>
                <td>
                    {{$value->out_time ? date('h:i:s A',strtotime($value->out_time)) : 'n/a'}}
                </td>

                {{-- <td>
                    {{getLateIntime( $value->late_status)}}
                </td> --}}

            </tr>


        @endforeach
        </tbody>


    </table>
</div>


</body>


<style>

    @page {
        size: a4;
        margin: 0px;
    }

    body {
        margin: 10px 20px 50px 20px;
    }


</style>

</html>












