<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payroll PDF</title>
    <style>
        body {
            font-family: Arial, sans-serif;
        }

        h2 {
            text-align: center;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        th {
            font-size: 10px;
            border: 1px solid #ddd;
            padding: 4px;
            text-align: center;
        }

        td {
            border: 1px solid #ddd;
            padding: 4px;
            text-align: center;
            font-size: 10px;


        }

        .bg-info {
            background-color: #5bc0de;
            color: #fff;
        }

        .error {
            text-align: center;
            color: red;
        }

        .color {
            color: red;
        }

        .total-row {
            color: red;
            font-weight: bold;
        }

        .bacgound {
            background: #f4f4f4
        }

        .badge-success {
            color: #468847;
        }

        .badge-danger {
            color: #f11c00;
        }
    </style>
</head>

<body>
    <div>
        @php
            $originalDate = "$year-$month";
            $carbonDate = \Carbon\Carbon::parse($originalDate);
            $formattedDate = $carbonDate->format('M-Y');
        @endphp
        {{-- <div class="headerco" style="width: 100%; ">
            <table style="width: 100%; border: none;">
                <tr>
                    <td style="width: 33.33%; text-align: left; border: none;">
                        <img style="text-align: center; padding-top: 0px;" width="70px" height="70px;"
                    src="{!! public_path(Session::get('LOGO_PATH')) !!}">
                    </td>
                    <td style="width: 33.33%; text-align: center; border: none;">
                        <span style="font-size:20px">{{ session('FULL_NAME') }}</span> <br>
                        Employee Payroll Report
                    </td>

                </tr>
            </table>
        </div>
        <div class="text-right" style="text-align: right">
            <span style="color: red;font-size:15px">{{ $formattedDate }}</span>
        </div> --}}

        <div class="headerco" style="width: 100%; ">
            <table style="width: 100%; border: none;">
                <tr>
                    <td style="width: 10%; text-align: left; border: none;">
                        <img style="text-align: center; padding-top: 0px;" width="70px" height="70px;"
                            src="{!! public_path(Session::get('LOGO_PATH')) !!}">
                    </td>
                    <td style="width: 100%; text-align:center;  padding-right:100px;  border: none;">
                        <span style="font-size:20px">{{ $site_info->site_name }}</span> <br>
                        {{ $site_info->address }}
                    </td>
                </tr>
            </table>
        </div>
        <div class="header-right" style="text-align: center">
            <strong>Payroll Report</strong>
        </div>


        <div class="new" style="text-align: right">
            <span>{{ $formattedDate }}</span>
        </div>


        <!-- Employee Data Table -->
        <table>
            <thead>
                <tr style="background-color: 	#c4c4c3">
                    <th>#</th>
                    <th>Name</th>
                    <th>User ID</th>
                    <th>Base salary</th>
                    <th>Bonus</th>
                    <th>Total pres.</th>
                    <th>Total abs.</th>
                    <th>Allowan.</th>
                    <th>Gross pay</th>
                    <th>Deduct.</th>

                    <th>Late Day </th>
                    <th>Late status</th>
                    <th>Late deductions</th>
                    <th>Unpaid leave deductions</th>
                    <th>Half Day leave deductions</th>
                    <th>Abs. status</th>
                    <th>Abs. deductions</th>

                    <th>Net pay</th>
                    <th>Pay date</th>
                </tr>
            </thead>

            <tbody>
                <tr>
                    <td>{{ 1 }}</td>
                    <td>{{ $data['full_name'] }}</td>
                    <td>{{ $data['username'] }}</td>
                    <td>{{ $data['base_salary'] }}</td>
                    <td>{{ $data['bonus'] }}</td>
                    <td>{{ $data['total_present'] }}</td>
                    <td>{{ $data['total_absent'] }}</td>
                    <td>{{ $data['allowances'] }}</td>
                    <td>{{ $data['gross_pay'] }}</td>
                    <td>{{ $data['deductions'] }}</td>
                    <td>{{ $data['totalCountableLateness'] }}</td>
                    <td><span
                            class="badge-{{ $data['late_status'] == 1 ? 'danger' : 'success' }}">{{ $data['late_status'] == 1 ? 'Active' : 'Inactive' }}</span>
                    </td>
                    <td>{{ $data['late_deductions'] }}</td>
                    <td>{{ $data['unpaid_leave_deduction'] }}</td>
                    <td>{{ $data['half_day_leave_deduction'] }}</td>
                    <td><span
                            class="badge-{{ $data['absent_status'] == 1 ? 'danger' : 'success' }}">{{ $data['absent_status'] == 1 ? 'Active' : 'Inactive' }}</span>
                    </td>
                    <td>{{ $data['absent_deductions'] }}</td>

                    <td class="color">tk.{{ number_format($data['net_pay']) }}</td>
                    <td>{{ $data['pay_date'] }}</td>
                </tr>



            </tbody>
        </table>
        @if ($employee_bonus->count() || $employee_allowances->count() || $employee_deductions->count())

            <table style="float: left;">
                <tr>
                    <td Colspan="15">Summary</td>
                </tr>
                <!-- Bonus Table -->
                @if ($employee_bonus->count())
                    <tr class="bacgound">
                        <td Colspan="11" class="color">All Bonus</td>
                        <td Colspan="4">Total</td>
                    </tr>
                    <tr>
                        <td Colspan="2">sl</td>
                        <td Colspan="2">Type</td>
                        <td Colspan="3">Amount</td>
                        <td Colspan="4">Date</td>
                        <td Colspan="4" class="color" rowspan="{{ $employee_bonus->count() + 1 }}">
                            tk.{{ $total_bonus_amount }}</td>
                    </tr>
                    @foreach ($employee_bonus as $key => $bonus)
                        <tr>
                            <td Colspan="2">{{ $key + 1 }}</td>
                            <td Colspan="2">{{ $bonus['bonus_type'] }}</td>
                            <td Colspan="3">{{ $bonus['bonus_amount'] }}</td>
                            <td Colspan="4"> {{ \Carbon\Carbon::parse($bonus['bonus_date'])->format('d M Y') }}
                            </td>
                        </tr>
                    @endforeach
                @endif

                <!-- Allowances Table -->
                @if ($employee_allowances->count())
                    <tr class="bacgound">
                        <td Colspan="11" class="color">All Allowance</td>
                        <td Colspan="4">Total</td>
                    </tr>
                    <tr>
                        <td Colspan="2">sl</td>
                        <td Colspan="2">Type</td>
                        <td Colspan="3">Amount</td>
                        <td Colspan="4">Date</td>
                        <td Colspan="4" class="color" rowspan="{{ $employee_allowances->count() + 1 }}">
                            tk.{{ $total_allowance_amount }}</td>
                    </tr>
                    @foreach ($employee_allowances as $key => $allowance)
                        <tr>
                            <td Colspan="2">{{ $key + 1 }}</td>
                            <td Colspan="2">{{ $allowance['allowance_type'] }}</td>
                            <td Colspan="3">{{ $allowance['allowance_amount'] }}</td>
                            <td Colspan="4">
                                {{ \Carbon\Carbon::parse($allowance['allowance_date'])->format('d M Y') }} </td>
                        </tr>
                    @endforeach
                @endif

                <!-- Deductions Table -->
                @if ($employee_deductions->count())
                    <tr class="bacgound">
                        <td Colspan="11" class="color">All Deductions</td>
                        <td Colspan="4">Total</td>
                    </tr>
                    <tr>
                        <td Colspan="2">sl</td>
                        <td Colspan="2">Type</td>
                        <td Colspan="3">Amount</td>
                        <td Colspan="4">Date</td>
                        <td Colspan="4" class="color" rowspan="{{ $employee_deductions->count() + 1 }}">
                            tk.{{ $total_deductions_amount }}</td>
                    </tr>
                    @foreach ($employee_deductions as $key => $deduction)
                        <tr>
                            <td Colspan="2">{{ $key + 1 }}</td>
                            <td Colspan="2">{{ $deduction['deduction_type'] }}</td>
                            <td Colspan="3">{{ $deduction['deduction_amount'] }}</td>
                            <td Colspan="4">
                                {{ \Carbon\Carbon::parse($deduction['deduction_date'])->format('d M Y') }} </td>
                        </tr>
                    @endforeach
                @endif

            </table>
        @endif




    </div>
</body>

</html>
