<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
        }

        table {
              /* Forces columns to have consistent widths */
            width: 100%;
            border-collapse: collapse;  /* Remove any spacing between borders */
        }

        /* Style for table headers and cells */
        th, td {
            border: 1px solid black;  
            padding: 5px;  
            text-align: center; 
            vertical-align: top;
        }

       .text-middle{
            text-align: center;  
            vertical-align: middle;  
        }




        .report-card {
            width: 100%;
            margin: 0 auto;
            border: 1px solid black;
        }

        .report-card th, .report-card td {
            border: 1px solid black;
            padding: 3px;
            text-align: center;
        }

        .header {
            text-align: center;
            font-weight: bold;
            padding: 5px;
        }

        .table-header {
            background-color: #f1f1f1;
            font-weight: bold;
        }

        .header-table {
            width: 100%;
            margin-top: 10px;
            margin-bottom: 20px;
            padding:5px;
        }

        .subject-table{
            /* table-layout: fixed; */
            width: 100%;
            border-collapse: collapse;
            font-size: 10px;
        }

        .gradesystem {
            width: 100%;
            font-size: 10px;
            padding:3px;
        }

        .gradesystem td{
           border:1px solid black;
           padding: 0px;
        }

        .footer {
            width: 100%;
            margin-top: 20px;
        }

        .footer .sign {
            text-align: center;
            padding-top: 30px;
        }

        .footer .sign p {
            border-top: 1px solid black;
            display: inline-block;
            padding: 5px;
        }

        /* Specific styling for different parts */
        .highlight {
            font-weight: bold;
            font-size: 16px;
        }

        .result-summary th, .result-summary td {
            font-weight: bold;
        }
/* 
        .exam_table tr th, .exam_table tr td{
            border-collapse: collapse;
            border: 1px solid black;
        } */
        /* .exam_table tr td, .exam_table tr th{
            border: 1px solid black;
        } */

        .exam_table{
            border-collapse: collapse;
            padding: 5px;
            font-size: 10px;
        }

        .border_none{
            border:none !important;
        }
        .signature-box{
            font-size: 10px;
            padding:3px;
        }
        .signature tr th{
            text-align: center;
            border:none;
        }


    </style>
</head>
<body>

    <div style="display: none;">
     
        <?php
        
        echo $size=sizeof($student_array);
        ?>
    </div>

    @foreach($student_array as $key=>$student_result)
    <div class="report-card">
        <table style="padding-bottom: 10px; border:none">
            <tr>
                <td style="width: 25%; height:auto" class="border_none">
                    <span style="padding: 6px">
                        <img style="float: left;" src="{{public_path($site_info->site_logo)}}" width="60" height="55">
                    </span>
                    </td>
                <td style="width: 50%; text-align: center; /*border: 1px solid green*/" class="border_none">
        
                    <div style="width: 100%; text-align: center">
                    <span class="sitename" style="font-size: 18px; font-weight:bold ">{!! $site_info->site_name !!}</span> <br>
                    @if($resultSetting['site_address_show_status'])
                        <span style="font-size: 11px;">{!! $site_info->address !!}</span><br>
                    @endif
                    <span style="font-weight: bold">{{$student_result['result_type_name']}} Report Card</span>
                    </div>
                </td>
                <td class="border_none" style="width: 25%;font-size: 10px;text-align: right;vertical-align: top;">
                    <b>Printed :</b> {{date('d M Y h:i:s A',time())}}
                </td>
            </tr>
        </table>
      
        <table class="header-table">
            <tr>
                <td>Student Name:</td>
                <td colspan="2" class="highlight">{{$student_result['student_name']}}</td>

                <td>Father's Name:</td>
                <td colspan="2">{{$student_result['father_name']}}</td>
                <td>Mother's Name:</td>
                <td colspan="2">{{$student_result['mother_name']}}</td>
               
              
            </tr>
            <tr>
                <td>Academic Year:</td>
                <td colspan="2">{{$student_result['academic_year_name']}}</td>
                <td>Shift</td>
                <td colspan="2">{{$student_result['academic_shift_name']}}</td>
                <td>Class:</td>
                <td colspan="2" class="highlight">{{$student_result['class_name']}}</td>
               
            </tr>
            <tr>
                <td>Group</td>
                <td colspan="2">{{$student_result['class_group_name']}}</td>
              
                <td>Section</td>
                <td colspan="2">{{$student_result['section_name']}}</td>
                <td>Roll:</td>
                <td colspan="2" class="highlight">{{$student_result['student_roll']}}</td>
            </tr>
            <tr>
                <td>Grade:</td>
                <td colspan="2">{{$student_result['grade']}}</td>
                <td>GPA:</td>
                <td colspan="2">{{$student_result['gpa']}}</td>

                @if($resultSetting['merit_list_show_status'])
                    <td>Merit Position:</td>
                    <td colspan="2">
                        @if($student_result['gpa'])
                            <span>{{$student_result['student_rank']}}</span>
                        @else
                            <span>-</span>
                        @endif
                       
                    </td>
                @else
                    <td></td>
                    <td colspan="2"></td>
                @endif
            </tr>
        </table>

        {{-- subject list --}}

        <table class="border_none marks_table">
            <tr>
                <td style="width:75%" class="border_none">
                    <table class="subject-table" style="width: 100%; border-collapse: collapse; padding:5px">
                        <thead>
                            <tr class="table-header">
                                <th rowspan="2">Subject Name</th>
                                @if($student_result['student_combine_subject_present_status'])
                                <th rowspan="2">Individual Subject</th>
                                @endif
                                <th rowspan="2" style="width: 20px">Marks </th> 
                               
                                    @foreach($student_result['table_header']->primary_result_type_list as $pri_result)
                                        <th colspan="3">{{$pri_result->academic_result_primary_type_name}}</th>
                                    @endforeach
                                <th rowspan="2">Total Marks</th> 
                                <th rowspan="2">Average Marks</th> 
                                <th rowspan="2">GPA</th> 
                                <th rowspan="2">Grade</th>
                            </tr>
                            <tr class="table-header">
                                @foreach($student_result['table_header']->primary_result_type_list as $pre_result)
                                <th>Obtain Marks</th>
                                <th>Grade</th>
                                <th>GPA</th>
                                @endforeach
                              
                            </tr>
                        </thead>

                        <tbody>
                            @foreach($student_result['subject_list'] as $key=>$subject)
                            @foreach($subject['individual_subject_array'] as $keys=>$individual_subject)
                            <tr>
                                @if($keys==0)
                                    <td class="text-middle" rowspan="{{count($subject['individual_subject_array'])}}">{{$subject['exam_dependent_academic_subject']}}</td>
                                @endif
                                @if($student_result['student_combine_subject_present_status'])
                                @if($subject['combine_subject_present_status'])
                                    <td class="text-middle">{{$individual_subject->academic_subject_name}}</td>
                                @else
                                    <td></td>
                                @endif
                                @endif
                                <td class="text-middle">{{$individual_subject->average_exam_mark}}</td>

                                @foreach($student_result['table_header']->primary_result_type_list as $pri_result)
                                    @foreach($individual_subject->primary_result_array as $primary_result)
                                        @if($pri_result->academic_result_primary_type_id==$primary_result->academic_result_primary_type_id)
                                            <td class="text-middle">{{$primary_result->obtain_subject_total_marks}}</td>
                                            <td class="text-middle">{{$primary_result->grade}}</td>
                                            <td class="text-middle">{{$primary_result->point}}</td>
                                        @endif
                                    @endforeach
                                @endforeach
                                @if($keys==0)
                                    <td class="text-middle" rowspan="{{count($subject['individual_subject_array'])}}">{{$subject['total_subject_mark']}}</td>
                                    <td class="text-middle" rowspan="{{count($subject['individual_subject_array'])}}">{{$subject['average_subject_mark']}}</td>
                                    <td class="text-middle" rowspan="{{count($subject['individual_subject_array'])}}">{{$subject['subject_point']}}</td>
                                    <td class="text-middle" rowspan="{{count($subject['individual_subject_array'])}}">{{$subject['subject_grade']}}</td>
                                
                                @endif
                            </tr>
                            @endforeach
                            @endforeach
                        </tbody>
                    </table>

                </td>
                <td width="25%" class="border_none">

                    <table class="gradesystem">
                        <tr>
                            <th>From</th>
                            <th>To</th>
                            <th>Point</th>
                            <th>Grade</th>
                        </tr>
                        @foreach($result_system_list as $systemkey=>$opt)
                            <tr>
                                <td>{{floor($opt['number_from'])}}</td>
                                <td>{{floor($opt['number_to'])}}</td>
                                <td>{{$opt['point']}}</td>
                                <td>{{$opt['academicResultSystem']['name']}}</td>
                            </tr>
                        @endforeach
                    </table>
                    <table class="gradesystem">
                      
                        <tr>
                            <th>Examination</th>
                            <th>Position</th>
                            <th>Total Student</th>
                            {{-- <th>Total Cariculam Days</th> --}}
                            <th>Present Days</th>
                            {{-- <th>Absent Days</th> --}}
                            {{-- <th>Final Result (grade)</th> --}}
                        </tr>
                        @foreach($student_result['individual_primary_result_list'] as $result)
                        <tr>
                            <th>{{$result->academic_result_primary_type_name}}</td>
                            <td class="text-middle">
                                @if($result->gpa)
                                   <span>{{$result->student_rank}}</span>
                                @else
                                    <span>-</span>
                                @endif
                            </td>
                            <td class="text-middle">{{$result->total_student}}</td>
                            {{-- <td>{{$result->academic_days}}</td> --}}
                            <td class="text-middle">{{$result->present_days}}</td>
                            {{-- <td>{{$result->absent_days}}</td> --}}
                            {{-- <td class="text-middle">{{$result->grade}}</td> --}}
                        </tr>
                        @endforeach
                      
                    </table>
                
                </td>
            </tr>
        </table>

        <div style="margin-top:50px; margin-bottom:10px">
            <table class="signature"  width="100%" >
                <tr>
                    <th style="float: left !important;">
                        @if($resultSetting['left_designation'])
                        <span>..............................</span><br>
                        <span>{{$resultSetting['left_designation']}}</span>
                        @endif
                    </th>

                    <th width='40%'>
                        @if($resultSetting['center_designation'])
                        <span>..............................</span><br>
                        <span>{{$resultSetting['center_designation']}}</span>
                        @endif
                    </th>

                    <th style="float: right !important;">
                        @if($resultSetting['head_signature_show_status'])
                        <img style="text-align: center; padding-top: 0px;" width="200px" height="40px;"
                                   src="{!! public_path($institute_head_signature) !!}">
                        @endif
                        <br>
                        <span>..............................</span><br>
                        <span>{{$institute_head_designation}}</span><br>
                       
                        @if($resultSetting['site_address_show_status'])
                        <span>{!! $site_info->address !!}</span>
                        @endif
                    </th>
                </tr>
            </table>

        </div>

    </div>
    @if($size>1)
    <div style="page-break-after: always;page-break-inside:avoid;"></div>
    @endif
    @endforeach
</body>
</html>
