<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">

    <style>
   

        table {
            border-collapse: collapse;
            font-size:12px;
            font-family: Verdana, Geneva, Tahoma, sans-serif;

        }

        .resultlist th, .resultlist td {
            border: 1.5px solid black;
            text-align: center;
            font-size:10px;
            font-size: 12px !important;
            font-family: Verdana, Geneva, Tahoma, sans-serif;

        }

        .resultlist th{
            height: 25px;
            font-family: Verdana, Geneva, Tahoma, sans-serif;

        }

        .signature tr th{
            text-align: center;
            border:none !important;

        }

        .sitename{
            font-size:15px !important;
        }
        .result_table_header{
            font-family: Verdana, Geneva, Tahoma, sans-serif;
            font-size:12px;

        }

       
    </style>

</head>
<body>

<div>
        @include('default.site.layout.pdf-header')

        <div style="margin-top:10px; text-align: center;">
            <div class="result_table_header"><b>Total Student Result<b></div>
            <table width="100%" heigth="100px" class="resultlist table" style="margin-top: 4px">
                <thead>
                    <tr>
                        <th>Total Student</th>
                        <th>Total Perticepent</th>
                        <th>Passed Student</th>
                        <th>Failed Student</th>
                        <th>Absent Student</th>
                        <th>Percentage of Passed Student</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>{{ $primaryResult['total_student'] }}</td>
                        <td>{{ $primaryResult['total_perticepent_student'] }}</td>
                        <td>{{ $primaryResult['passed_student_count'] }}</td>
                        <td>{{ $primaryResult['failed_student_count'] }}</td>
                        <td>{{ $primaryResult['absent_student_count'] }}</td>
                        <td>{{ $primaryResult['class_passed_percentage'] }}</td>
                    </tr>
                </tbody>
            </table>
        </div>

        <div style="margin-top:10px; text-align: center;">
            <div class="result_table_header"><b>Student Roll and Result<b></div>
            @if($data['full_show_status'])
            <table width="100%" heigth="100px" class="resultlist table" style="margin-top: 4px">
                <thead>
                    <tr>
                        <th style="width: 40px">Sl. No.</th> 
                        <th style="width: 80px">Roll</th> 
                        <th>Student Name</th> 
                        <th>Total Mark</th> 
                        <th>GPA</th> 
                        <th>Rank</th>            
                    </tr>
                 
                </thead>
                <tbody>
                    @foreach($resultList as $key=>$result_item)
                        <tr>
                            <td>{{$key+1}}</td>
                            <td>
                                {{$result_item['student_roll_number']}}

                                @if ($result_item['academic_student_category_id']==2)
                                     (Ex)
                                @endif
                            </td>
                            <td>
                                {{$result_item['student_full_name']}}
                            </td>
                            <td>{{$result_item['sum_of_obtain_raw_total_marks']}}</td>
                            <td>{{$result_item['gpa']}}</td>
                            <td>{{$result_item['student_rank']}}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            @else
            <table width="100%" heigth="100px" class="resultlist table" style="margin-top: 4px">
                <thead>
                    <tr>
                        @for ($i=1; $i<=$column_number; $i++)
                            <th>Roll</th> 
                            <th>GPA</th> 
                        @endfor                      
                    </tr>
                 
                </thead>
                <tbody>
                    @foreach($resultList->chunk($column_number) as $chunked_item)
                        <tr>
                            @foreach( $chunked_item as $key=>$item )
                                <td>
                                    {{$item['student_roll_number']}}
                                    @if ($result_item['academic_student_category_id']==2)
                                        (Ex)
                                    @endif
                                </td>
                                <td>{{$item['gpa']}}</td>
                            @endforeach
                            @if (count($chunked_item)<$column_number)
                                @for ($i=1; $i<=($column_number-count($chunked_item)); $i++)
                                    <td></td>
                                    <td></td>
                                @endfor
                            @endif
                        </tr>
                    @endforeach
                </tbody>
            </table>
            @endif
        </div>


        <div>
            <table style="margin-top:100px;" class="signature"  width="100%" >
                <tr>
                    <th style="float: left !important;">
                        <span>..............................</span><br>
                        <span>Convenor</span>
                    </th>

                    <th width='40%'>
                        {{-- <span>..............................</span><br>
                        <span>Class Teacher</span> --}}
                    </th>

                    <th style="float: right !important;">
                        
                        <br>
                        <span>..............................</span><br>
                        <span>{{$get_institute_head_designation}}</span>
                    
                    </th>
                </tr>
            </table>
        </div>

</div>

</body>



<style>

    @page {
        size: 7in 9.25in;
        margin: 1px 0;
    } 
    body {
        margin: 10px 10px 10px 20px;
    }


</style>


</html>