<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Primary Result Overview</title>
    <style>
        body {
            font-family: Verdana, sans-serif;
            font-size: 12px;
            margin: 20px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        th,
        td {
            border: 1px solid #000;
            padding: 6px;
            text-align: center;
        }

        th {
            background-color: #f2f2f2;
        }

        .header th,
        .header td {
            border: none;

        }

        .header th {
            border: none;
        }

        .section-title {
            font-size: 16px;
            margin: 20px 0 10px;
            text-align: center;
            font-weight: bold;
        }

        .passed-list {
            padding: 10px;
            background-color: #eef;
        }
    </style>
</head>

<body>

    @php($site = getSiteInfoForPdf())

    <div class="header">
        <table width="100%;" border="0" style="border: none">
            <tr>
                <td style="width: 25%;">
                    <span>
                        <img style="float: left" src="{{ public_path($site->site_logo) }}" width="60" height="55">
                    </span>
                </td>
                <td style="width: 50%; text-align: center; /*border: 1px solid green*/">

                    <div style="width: 100%; text-align: center">
                        <span class="sitename" style="font-size: 16px; font-weight:bold ">{!! $site->site_name !!}</span>
                        <br>
                        <span style="font-size: 11px;">{!! $site->address !!}</span><br>
                        <br>

                        <span style="font-weight: bold">{!! $report_tittle !!} </span>
                    </div>
                </td>
                <td style="width: 25%;font-size: 10px;text-align: right;vertical-align: top;">
                    <b>Printed :</b> {{ date('d M Y h:i:s A', time()) }}
                </td>
            </tr>
        </table>

        @if ($report_tittle2)
            <span class="tittle" style="font-weight: bold">{!! $report_tittle2 !!}</span>
            {{-- <table width="100%;" border="0">
                <tr>
                    <td style="width: 50%; font-size: 10px;">

                    </td>

                    <td style="width: 30%; font-size: 10px; text-align: right; vertical-align: bottom; margin-top:50px">
                        <b>Printed :</b> {{date('d M Y h:i:s A',time())}}
                    </td>
                </tr>
            </table> --}}
        @endif
    </div>

    {{-- Summary Table --}}
    <div>
        <div class="section-title">Primary Result Summary</div>
        <table>
            <thead>
                <tr>
                    <th>Total Student</th>
                    <th>Participant Student</th>
                    <th>Passed Student</th>
                    <th>Failed Student</th>
                    <th>Absent Student</th>
                    <th>Pass Percentage</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>{{ $site_primary_result_overview['total_student'] ?? 0 }}</td>
                    <td>{{ $site_primary_result_overview['total_perticepent_student'] ?? 0 }}</td>
                    <td>{{ $site_primary_result_overview['passed_student_count'] ?? 0 }}</td>
                    <td>{{ $site_primary_result_overview['failed_student_count'] ?? 0 }}</td>
                    <td>{{ $site_primary_result_overview['absent_student_count'] ?? 0 }}</td>
                    <td>{{ $site_primary_result_overview['class_passed_percentage'] ?? 0 }}%</td>
                </tr>
            </tbody>
        </table>
    </div>

    {{-- Merit List --}}
    @if (!empty($site_primary_result_overview['merit_list']))
        @if ($settings['merit_list'] == 1)
            <div>
                <div class="section-title">Merit List</div>
                <table>
                    <thead>
                        <tr>
                            <th>#</th>
                            <th>Name</th>
                            <th>Roll</th>
                            <th>Total</th>
                            <th>%</th>
                            <th>Grade</th>
                            <th>GPA</th>
                            <th>Rank</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($site_primary_result_overview['merit_list'] as $index => $item)
                            <tr>
                                <td>{{ $index + 1 }}</td>
                                <td>{{ $item['student_name'] }}</td>
                                <td>{{ $item['roll'] }}</td>
                                <td>{{ $item['total_mark'] }}</td>
                                <td>{{ $item['mark_percentage'] }}</td>
                                <td>{{ $item['grade'] }}</td>
                                <td>{{ $item['gpa'] }}</td>
                                <td>{{ $item['rank'] }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @endif
    @endif

    {{-- Passed Student List --}}
    @if ($settings['passed_list'] == 1)
    <div>
        <div class="section-title">
            Passed Students ({{ $site_primary_result_overview['passed_student_count'] ?? 0 }})
        </div>
        <div class="passed-list">
            {{ $site_primary_result_overview['passed_student_full_roll_numbers_string'] ?? '-' }}
        </div>
    </div>
    @endif

    {{-- Failed Subject Breakdown --}}
    @if (!empty($site_primary_result_overview['failed_subject_list']))
        @if ($settings['failed_list'] == 1)
            <div>
                <div class="section-title">Failed Subjects Count (Without 4th Subject)</div>

                @foreach ($site_primary_result_overview['failed_subject_list'] as $failed_item)
                    <p><strong>{{ $failed_item['failed_subject_count'] }}
                            {{ $failed_item['failed_subject_count'] == 1 ? 'Subject' : 'Subjects' }} Failed
                            ({{ $failed_item['failed_subject_student'] }})
                        </strong></p>
                    <ul style="margin-left: 20px;">
                        @foreach ($failed_item['academic_subject_list'] as $subject)
                            <li style="font-size: 14px;">
                                {{ $subject['academic_subject']['subject_name'] ?? '-' }}
                                ({{ $subject['academic_subject']['subject_name'] ?? '-' }})
                                :
                                @foreach ($subject['student_history_list'] as $student)
                                    {{ $student['student_full_roll_number'] }}
                                    @if ($student['academic_student_category_id'] == 2)
                                        (Ex)
                                    @endif
                                    ,
                                @endforeach
                            </li>
                        @endforeach
                    </ul>
                @endforeach
            </div>
        @endif
    @endif

</body>

<style>
    @page {
        size: A4;
        margin: 20px;
    }
</style>

</html>
