<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>{{$title_view}}</title>

    <style type="text/css">

        * {
            font-family: Verdana, Arial, sans-serif;
        }
        table{
            font-size: x-small;
        }
        tfoot tr td{
            font-weight: bold;
            font-size: x-small;
        }

        .amount-right{
            text-align:right;
        }

        .gray {
            background-color: lightgray
        }

        .slot-table td {
            border: 1px solid #999999;
            border-width: thin;
            border-spacing: 2px;
            /*border-style: none;*/

        }

        .slot-table th {
            border: 1px solid #999999;
            border-width: thin;
            border-spacing: 2px;
            font-weight: bold;
            font-size: x-small
            /*border-style: none;*/

        }

        .heading-slot-bg {
            background-color: #dcdcdc;
            color: #000000;
            text-align: center;
            width: 25px;
            vertical-align: middle;
            padding-left: 20px;
        }

        .slot {
            width: 100px;
            min-height: 200px;
            padding: 0 3px;
        }

    </style>

</head>
<body>
@include('default.site.layout.pdf-header')



<table class="slot-table" width="100%" cellspacing="0" border="0">
    <thead style="background-color:  #e6e6e6;">
    {{--<tr>--}}

        {{--<td  border="1" cellpadding="0" cellspacing="0" style="text-align: left; padding: 2px;" class="amount-left"><b>Fee Item</b></td>--}}
        {{--<td border="1" cellpadding="0" cellspacing="0" style="text-align: left; padding: 2px;" class="amount-left"><b>Fee Type</b></td >--}}
        {{--<td  border="1" cellpadding="0" cellspacing="0" style="text-align: left; padding: 2px;" class="amount-left"><b>Received By</b></td>--}}
        {{--<td border="1" cellpadding="0" cellspacing="0" style="text-align: center; padding: 2px;"><b>Received Date</b></td>--}}
        {{--<td  border="1" cellpadding="0" cellspacing="0" style="text-align: right; padding: 2px;" class="amount-right"><b>Generate Amount</b></td>--}}

    {{--</tr>--}}
    <tr>
        <th border="1" cellpadding="0" style="text-align: center">SL</th>
        <th border="1" cellpadding="0" style="text-align: center">
            <nobr>Transaction Date</nobr>
        </th>
        <th border="1" cellpadding="0" style="text-align: left">
            <nobr>Transaction Type</nobr>
        </th>
        <th border="1" cellpadding="0" style="text-align: center">
            <nobr>Transaction ID</nobr>
        </th>
        <th border="1" cellpadding="0" style="text-align: left">Particulars</th>
        <th border="1" cellpadding="0" style="text-align: right">Debit</th>
        <th border="1" cellpadding="0" style="text-align: right">Credit</th>
        <th border="1" cellpadding="0" style="text-align: right">Balance</th>
    </tr>
    </thead>
    <tbody>


    @php($sl=1)
    <tr v-if="dataList.length > 0">
        <td style="text-align: center">1</td>
        <td style="text-align: center">{{$upto_date}}</td>
        <td style="text-align: left">Receivable</td>
        <td style="text-align: center"></td>
        <td style="text-align: left">Opening Balance(Upto {{$upto_date}})</td>
        <td style="text-align: right">0</td>
        <td style="text-align: right">0</td>
        <td style="text-align: right">{{$initial_balance}}</td>

    </tr>
    @foreach($final_data as $key=>$value)
        <tr>
            <td style="text-align: center">
                {{ $key + 2 }}
            </td>
            <td style="text-align: center">
                {{ $value['transaction_date'] }}
            </td>
            <td style="text-align: left">
                {{ $value['transaction_type'] }}
            </td>
            <td style="text-align: center">
                {{ $value['transaction_id'] }}
            </td>
            <td style="text-align: left">
                {{ $value['particular'] }}
            </td>
            <td style="text-align: right">
                {{ number_format($value['debit_amount']) }}
            </td>
            <td style="text-align: right">
                {{ number_format($value['credit_amount']) }}
            </td>
            <td style="text-align: right">
                {{ number_format($value['balance']) }}
            </td>

        </tr>
    @endforeach
    @if(count($final_data)>0)
        <tr>
            <td colspan="7" style="text-align: right">
                <b>Dues(TK)</b>
            </td>
            <td style="text-align: right">
                <b>{{ $balance }}</b>
            </td>

        </tr>
    @endif

    </tbody>
    <tfoot >


    </tfoot>

</table>

</body>



<style>
    @page {
        size: a4;
        margin: 1px 0;
    }
    body {
        margin: 5px 20px 0;
        /*border:1px dotted black;*/
    }

</style>
</html>