<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>{{$title_view}}</title>

    <style type="text/css">

        * {
            font-family: Verdana, Arial, sans-serif;
        }
        table{
            font-size: x-small;
        }
        tfoot tr td{
            font-weight: bold;
            font-size: x-small;
        }

        .amount-right{
            text-align:right;
        }

        .gray {
            background-color: lightgray
        }

        .slot-table td {
            border: 1px solid #999999;
            border-width: thin;
            border-spacing: 2px;
            /*border-style: none;*/

        }

        .heading-slot-bg {
            background-color: #dcdcdc;
            color: #000000;
            text-align: center;
            width: 25px;
            vertical-align: middle;
            padding-left: 20px;
        }

        .slot {
            width: 100px;
            min-height: 200px;
            padding: 0 3px;
        }

        /*#tbl {*/
            /*border-collapse: collapse;*/
        /*}*/

        /*#tbl, td, th {*/
            /*border: 1px solid black;*/
        /*}*/

    </style>

</head>
<body>
@include('default.site.layout.pdf-header')


<table width="100%">
    <tr>
        <td align="left"> <b>Std Name:</b> {{$stdDetailsArray['std_name']}}</td>
        @if($stdDetailsArray['department_name'])
        <td align="left">
            <b> Department:</b> {{$stdDetailsArray['department_name']??""}}
        </td>
        @endif
        <td align="left">
            <b> Class:</b> {{$stdDetailsArray['class_name']??""}}
        </td>
        @if($stdDetailsArray['group_name'])
        <td align="left">
            <b> Group:</b> {{$stdDetailsArray['group_name']??""}}
        </td>
        @endif
        @if($stdDetailsArray['section_name'])
        <td align="left">
            <b>Section:</b> {{$stdDetailsArray['section_name'] ?? ""}}
        </td>
        @endif

        {{--<td align="left"><b> From Date:</b> {{$from_date ?? ""}}</td>--}}
        {{--<td align="left"><b> To Date:</b> {{$to_date ?? ""}}</td>--}}
    </tr>

</table>

<table class="slot-table" width="100%" cellspacing="0" border="0">
    <thead style="background-color:  #e6e6e6;">
    <tr>

        <td  border="1" cellpadding="0" cellspacing="0" style="text-align: center; padding: 2px;" class="amount-left"><b>Srl</b></td>
        <td  border="1" cellpadding="0" cellspacing="0" style="text-align: center; padding: 2px;" class="amount-left"><b>Voucher No</b></td>
        <td border="1" cellpadding="0" cellspacing="0" style="text-align: left; padding: 2px;" class="amount-left"><b>Taken By</b></td >
        <td border="1" cellpadding="0" cellspacing="0" style="text-align: center; padding: 2px;" class="amount-left"><b>Payment Date</b></td >
        {{--<td  border="1" cellpadding="0" cellspacing="0" style="text-align: left; padding: 2px;" class="amount-left"><b>Received By</b></td>--}}
        {{--<td border="1" cellpadding="0" cellspacing="0" style="text-align: center; padding: 2px;"><b>Received Date</b></td>--}}
        <td  border="1" cellpadding="0" cellspacing="0" style="text-align: right; padding: 2px;" class="amount-right"><b>Paid Amount</b></td>

    </tr>
    </thead>
    <tbody>


    @php($sl=1)
    @foreach($dataArr as $key=>$value)
        <tr>
            <td  class="amount-left" border="1" style="text-align: center; padding: 2px;" cellpadding="0" cellspacing="0">{{$key+1}}</td>
            <td  class="amount-left" border="1" style="text-align: center; padding: 2px;" cellpadding="0" cellspacing="0">{{$value['voucher_no']}}</td>
            <td  class="amount-left" border="1" style="text-align: left; padding: 2px;" cellpadding="0" cellspacing="0">{{$value['created_by']}}</td>
            <td  class="amount-left" border="1" style="text-align: center; padding: 2px;" cellpadding="0" cellspacing="0">{{$value['payment_date']}}</td>
            {{--<td  class="amount-left" border="1" style="text-align: left; padding: 2px;" cellpadding="0" cellspacing="0">{{$vl['taken_by']['full_name']}}</td>--}}
            {{--<td  class="amount-center" border="1" style="text-align: center; padding: 2px;" cellpadding="0" cellspacing="0">{{$vl['taken_date']}}</td>--}}
            <td class="amount-right" style="text-align: right; padding: 2px;" border="1" cellpadding="0" cellspacing="0">{{$value['paid_amount']==0?"0.00":number_format($value['paid_amount']).".00"}}</td>

        </tr>
    @endforeach
    <tr  style="background-color:  #e6e6e6;">
        <td colspan="4" style="text-align: right; padding: 2px;" border="1" cellpadding="0" cellspacing="0" class="amount-right"><b>Total(TK)</b></td>
        <td class="amount-right" style="text-align: right; padding: 2px;" border="1" cellpadding="0" cellspacing="0"><b>{{$total_paid_amount.".00"}}</b></td>

    </tr>

    </tbody>
    <tfoot >

    </tfoot>

</table>
<table>
    {{--<tr>--}}

        {{--<td>--}}
            {{--Print Date: {{date('d-m-Y h:i:s A',time())}}--}}
        {{--</td>--}}
    {{--</tr>--}}
</table>




<style>
    @page {
        size: a4;
        margin: 1px 0;
    }
    body {
        margin: 5px 20px 0;
        /*border:1px dotted black;*/
    }

</style>
</html>