<!doctype html>
<html lang="en">

<head>
    <meta charset="UTF-8">


    <style>
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        th,
        td {
            border: 1px solid #ddd;
            padding: 4px;
            text-align: center;
            font-size: 10px;
        }


        body {

            margin: 0;
            padding: 5px;

        }

        .badge {
            padding: 5px;
            border: 1px solid red;
            color: white
        }
    </style>

</head>

<body>

    <div>
        <div class="page">
            <div class="headerco" style="width: 100%;">
                <table style="width: 100%; border: none;">
                    <tr>
                        <td style="width: 10%; text-align: left; border: none;">
                            <img style="text-align: center; padding-top: 0px;" width="70px" height="70px;"
                                src="{!! public_path('img/site_group/logo/' . $SiteGroupInfo['group_logo']) !!}">
                        </td>
                        <td style="width: 100%; text-align: center; padding-right: 100px; border: none;">
                            <span style="font-size: 25px">{{ $SiteGroupInfo['name'] }}</span> <br>
                            <span style="font-size: 15px"> Education Department </span>
                        </td>
                    </tr>
                </table>
            </div>
            <div class="header-right" style="text-align: center">
                <strong>{{ $site->site_name }}</strong> <br>
                <span>Student Attendence Report</span> <br>
                <span>{{ $dateformat }}</span>

            </div>

            <table class="table table-bordered table-responsive table-striped">
                <thead>
                    <tr>
                        <th scope="col">#</th>
                        <th scope="col">Name</th>
                        <th scope="col">Designation</th>
                        <th scope="col">Status</th>
                        <th scope="col">In Time</th>
                        <th scope="col">Out Time</th>
                        {{-- <th scope="col">Contact</th> --}}
                    </tr>
                </thead>
                <tbody>


                    @foreach ($student_lists as $index => $employeeAttendence)
                        <tr>
                            <th scope="row">{{ $index + 1 }}</th>
                            <td>{{ $employeeAttendence['full_name'] }}</td>
                            <td>
                                <span class="">
                                    {{ $employeeAttendence['designation_name'] }}
                                </span>
                            </td>

                            @if ($Single_site_off_day)
                                <td colspan="4">
                                    <span class="badge" style="background: red;">Day Off</span>
                                </td>
                            @else
                                <td>
                                    <span class="badge"
                                        style="background-color: {{ $employeeAttendence['bg_color'] }}">
                                        {{ $employeeAttendence['attendence_status'] }}
                                    </span>
                                </td>
                                <td>{{ $employeeAttendence['in_time'] }}</td>
                                <td>{{ $employeeAttendence['out_time'] }}</td>
                                {{-- <td>{{ $employeeAttendence['contact_number'] }}</td> --}}
                            @endif
                        </tr>
                    @endforeach

                </tbody>
            </table>



        </div>

    </div>

</body>



<style>
    @page {
        size: Landscape;
        margin: 1px 0;
    }

    /*@page {*/
    /*size: a4;*/
    /*margin: 1px 0;*/
    /*}*/
    body {
        margin: 10px 10px 10px 20px;
    }
</style>

</html>
