<!doctype html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <style>
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        th,
        td {
            border: 1px solid #ddd;
            padding: 4px;
            text-align: center;
            font-size: 10px;
        }

        body {
            margin: 0;
            padding: 5px;

        }

        .badge {
            padding: 4px 8px;
            border-radius: 4px;
            font-weight: bold;
            font-size: 12px;
        }

        .bg-success {
            background-color: #28a745;
            color: white;
        }

        .bg-info {
            background-color: #17a2b8;
            color: white;
        }

        .bg-warning {
            background-color: #ffc107;
            color: black;
        }

        .bg-danger {
            background-color: #dc3545;
            color: white;
        }
        .font-size {
            font-size: 10px;
        }
    </style>
</head>

<body>

    {{-- Header Section --}}
    <div class="page">
        <div class="headerco" style="width: 100%;">
            <table style="width: 100%; border: none;">
                <tr>
                    <td style="width: 12%; text-align: left; border: none;">
                        <img width="70px" height="70px"
                            src="{!! public_path('img/site_group/logo/' . $SiteGroupInfo['group_logo']) !!}">
                    </td>
                    <td style="width: 65%; text-align: center; border: none;">
                        <span style="font-size: 25px">{{ $SiteGroupInfo['name'] }}</span><br>
                        <span style="font-size: 15px">Education Department</span><br><br>
                        <h1>General Fee Report</h1>
                    </td>
                    <td style="width: 15%; text-align: center; border: none;">
                        <span style="font-size: 13px">Printed: {{ date('d M Y') }}</span>
                    </td>
                </tr>
            </table>
        </div>
    </div>

    {{-- Gross Summary Section --}}
    @if (!empty($gross_report))
        <table style="margin-top: 20px;">
            <tr>
                <td class="bg-success badge">Total Generate Amount: {{ number_format($gross_report['gross_total_generate_amount']) }}</td>
                <td class="bg-success badge">Total Fine Amount: {{ number_format($gross_report['gross_total_fine_amount']) }}</td>
                <td class="bg-info badge">Total Waiver Amount: {{ number_format($gross_report['gross_total_waiver_amount']) }}</td>
                <td class="bg-warning badge">Total Payable Amount: {{ number_format($gross_report['gross_total_payable_amount']) }}</td>
                <td class="bg-success badge">Total Paid Amount: {{ number_format($gross_report['gross_total_paid_amount']) }}</td>
                <td class="bg-danger badge">Total Due Amount: {{ number_format($gross_report['gross_total_due_amount']) }}</td>
            </tr>
        </table>
    @endif

    {{-- Table Data --}}
    <table>
        <thead>
            <tr class="bg-info">
                <th class="font-size">SL</th>
                <th class="font-size">Institution</th>
                <th class="font-size">Class</th>
                <th class="font-size">Generate Amount</th>
                <th class="font-size">Fine</th>
                <th class="font-size">Waiver Amount</th>
                <th class="font-size">Payable Amount</th>
                <th class="font-size">Paid Amount</th>
                <th class="font-size">Due</th>
            </tr>
        </thead>
        <tbody>
            @forelse ($final_data as $index => $item)
                <tr>
                    <td class="font-size">{{ $index + 1 }}</td>
                    <td class="font-size">{{ $item['site_name'] }}</td>
                    <td class="font-size">{{ $item['class_name'] }}</td>
                    <td class="font-size" style="text-align: right;">{{ number_format($item['total_generate_amount']) }}</td>
                    <td class="font-size" style="text-align: right;">{{ number_format($item['total_fine_amount']) }}</td>
                    <td class="font-size" style="text-align: right;">{{ number_format($item['total_waiver_amount']) }}</td>
                    <td class="font-size" style="text-align: right;">{{ number_format($item['total_payable_amount']) }}</td>
                    <td class="font-size" style="text-align: right;">{{ number_format($item['total_paid_amount']) }}</td>
                    <td class="font-size" style="text-align: right;">{{ number_format($item['total_due_amount']) }}</td>
                </tr>
            @empty
                <tr>
                    <td colspan="9" style="color:red;">No Data Found!</td>
                </tr>
            @endforelse
        </tbody>
    </table>

</body>

<style>
    @page {
        size: Landscape;
        margin: 1px 0;
    }

    body {
        margin: 10px 10px 10px 20px;
    }
</style>

</html>
