
@extends('default.admin.layouts.master')

@section('style')
    {!! Html::style('css/styles.css') !!}
@endsection

@section('content')

    <div class="container-fluid min_height_area">
        <div class="row">

            <div class="col-md-12">
                <div class="view-header">
                    <section class="content-header">
                        <ol class="breadcrumb">
                            <li>
                                <span class="fa fa-dashboard" aria-hidden="true"></span>
                                <a href="{{route('admin')}}">{{ trans('translate.dashboard') }}</a></li>
                            <li class="active text-capitalize">
                                <a>{{ trans('breadcrumb.student_offer_type.list') }}</a>
{{--                                <a href="{{route('student-attendance-list')}}">{{ trans('breadcrumb.student_offer_type.list') }}</a>--}}
                            </li>
                            <li class="active text-capitalize">{{ trans('breadcrumb.student_offer_type.over_view') }}</li>
                        </ol>
                    </section>
                </div>
            </div>

        </div>

        <div class="inner-box">
            <div class="row">
                <div class="col-md-12 snt form-horizontal">

                    @if (count($errors) > 0)
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    @if (session()->has('success'))
                        <div class="alert alert-success">
                            <ul>

                                <li>{{ session()->get('success') }}</li>

                            </ul>
                        </div>
                    @endif
                    {{--<a href="{{ route('add-student-attendance-form') }}"><i class="fa fa-plus"></i>  {{ trans('sidebar.add-student-attendance') }}</a>--}}
                </div>
            </div>
        </div>
        <div class="row">
            <site-student-offer-type-view-component></site-student-offer-type-view-component>
        </div>
    </div>

@endsection


@section('scripts')

    @parent

    {!! Html::script('select/js/select2.min.js') !!}



@endsection
