@inject('TcForm','App\Forms\TcForm')

@extends('default.admin.layouts.master')

@section('style')
    {!! Html::style('css/styles.css') !!}
    {!! Html::style('select/css/select2.min.css') !!}
@endsection

@section('content')

    <div class="container-fluid min_height_area">
        <div class="row">
            <div class="col-md-12">
                <div class="student-box-header">
                    <div class="col-md-6 col-xs-5">
                        <span class="glyphicon glyphicon-user " aria-hidden="true"></span>{{ trans('sidebar.get_tc') }}
                    </div>
                    <div class="col-md-6 col-xs-7 snt">
                        <ul class="breadcrumb text-right">
                            <li>
                                <span class="glyphicon glyphicon-folder-close" aria-hidden="true"></span>
                                <a href="#">{{ trans('sidebar.dashboard') }}</a></li>
                            <li class="active">{{ trans('sidebar.get_tc') }}</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div> <!--row-->
        <div class="inner-view">
            <div class="row">
                <div id="datatable">
                    <div class="row last">
                        <div class="col-sm-12">
                            <div class="box">                             
                                <div class="box-body">
                                     <div class="print_none">
                                        @if (count($errors) > 0)
                                            <div class="alert alert-danger">
                                                <ul>
                                                    @foreach ($errors->all() as $error)
                                                        <li>{{ $error }}</li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                        @endif

                                        <div class="custom_row">
                                             <h2 class="form_title">
                                                {{ trans('sidebar.get_tran_cer') }}
                                            </h2>
                                        </div>

                                        {!! formFields($TcForm) !!}
                                        <div class="row custom_padding">
                                        {!! Form::submit('Transfer Certificate',['class'=>'btn btn-primary','id'=>'tc-btn','readonly'=>'readonly']) !!}

                                        </div>
                                    </div>
                                    
                                </div><!-- /.box-body -->
                                  <div id="tc-report">


                                </div>
                            </div><!-- /.box -->
                        </div>
                    </div> <!--row last-->
                </div>
            </div>
        </div>
    </div>
@endsection


@section('scripts')

    @parent
    {!! Html::script('theme_components/admin/plugins/datatables/dataTables.bootstrap.min.js') !!}
    {!! Html::script('select/js/select2.min.js') !!}

    <script type="text/javascript">
        $(document).ready(function(){
            $('#student_class_id').select2();
            $('#section_id').select2();
            $('#student_id').select2();
            /*start choose section onchange event of class*/
            $('#student_class_id').change(function(){
                var host = window.location.origin ;
                var studentClassId = $('#student_class_id').find('option:selected').val();
                $.ajax({
                    'url': host + '/student-class/' + studentClassId,
                    'dataType': 'json'
                }).success(function (data) {
                    console.log(data);
                    var sectionForClass = "<option value=''>Select </option>";
                    $(data[0]).each(function(index,item){
                        sectionForClass += "<option value ="+ item.id +">"+item.section_name+" </option>";
                    });
                    $('#section_id').html(sectionForClass);
                })
            });
            /*end choose section onchange event of class*/

            /*start choose student onchange event of section*/
            $('#section_id').change(function(){
                var host = window.location.origin ;
                var sectionId = $('#section_id').find('option:selected').val();
                $.ajax({
                    'url': host + '/report/' + sectionId,
                    'dataType': 'json'
                }).success(function (data) {
                    console.log(data);
                    var studentForSection = "<option value=''>Select </option>";
                    $(data[0]).each(function(index,item){
                        studentForSection += "<option value ="+ item.id +">"+item.first_name+ ' ' +item.last_name+" </option>";
                    });
                    $('#student_id').html(studentForSection);
                })
            });
            /*end choose student onchange event of section*/

            $('#tc-btn').click(function () {
                var applicationSubject = $('#application_subject').val();
                var studentClassId = $('#student_class_id').find('option:selected').val();
                var sectionId = $('#section_id').find('option:selected').val();
                var studentId = $('#student_id').find('option:selected').val();
                var host = window.location.origin ;

                if(applicationSubject == '' || studentClassId == 0 || sectionId == 0 || studentId == 0){
                    alert('please select class, section and student and type subject of application');
                }else {
                    $.ajax({
                        url: host + '/report/tc-report/' +applicationSubject+'/'+studentClassId+'/'+ sectionId+'/'+studentId,
                        type: "GET", // not POST, laravel won't allow it
                        success: function(data){
                            /*alert(data);*/
                            $data = $(data); // the HTML content your controller has produced

                            $('#tc-report').html($data);
                        }
                    });
                }


            });
        });
    </script>

@endsection