@extends('default.admin.layouts.master')

@section('style')
    {!! Html::style('css/styles.css') !!}
@endsection

@section('content')
    <div class="container-fluid min_height_area">
        <div class="row">
            <div class="col-md-12">
                <div class="student-box-header">
                    <div class="col-md-6 col-xs-6">
                        <span class="glyphicon glyphicon-user " aria-hidden="true"></span>{{ trans('sidebar.teacher_list') }}
                    </div>
                    <div class="col-md-6 col-xs-6 snt">
                        <ul class="breadcrumb text-right">
                            <li>

                                <a href="{{ route('teacher-add-form') }}"><i class="fa fa-plus"></i> {{ trans('sidebar.teacher-add') }}</a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div> <!--row-->
        <div class="row">
            <div class="col-md-12">
                <div class="view-header">
                    <button onclick="javascript:window.print()" class="btn btn-primary"><span class="fa fa-print"></span> {{ trans('translate.print') }} </button>
                    <button onclick="javascript:window.print()" class="btn btn-primary"><span class="fa fa-file"></span> {{ trans('translate.print_preview') }} </button>
                    <button class="btn btn-primary"><span class="fa fa-file"></span> {{ trans('translate.edit') }}</button>
                </div>
            </div>
        </div> <!--row-->
        <div class="inner-box">
            <div class="row">
                <div id="datatable">
                    <div class="row last">
                        <div class="col-sm-12 col-xs-12">
                            <div class="box">
                                <div class="box-body auto_scroll">
                                    <table id="example1" class="table table-bordered table-striped">
                                        <thead>
                                        <tr>
                                             <th>{{ trans('translate.sl') }}</th>
                                            <th class="text-center">{{ trans('translate.photo') }}</th>
                                            <th class="text-center">{{ trans('translate.name') }}</th>
                                            <th class="text-center">{{ trans('translate.email') }}</th>
                                            <th class="text-center">{{ trans('translate.department') }}</th>
                                            <th class="text-center">{{ trans('translate.designation') }}</th>
                                            <th class="text-center">{{ trans('translate.address') }}</th>
                                            <th class="text-center">{{ trans('translate.phone') }}</th>
                                            <th class="text-center">{{ trans('translate.gender') }}</th>
                                            <th class="text-center">{{ trans('translate.religion') }}</th>
                                            <th class="text-center th_width_100">{{ trans('translate.action') }}</th>

                                        </tr>
                                        </thead>
                                        <tbody>

                                        @set('sl',1)
                                        @if(isset($teacherList) && !empty($teacherList))
                                            @foreach($teacherList as $key => $teacher)
                                                <tr>
                                                    <td>{{$sl++}}</td>

                                                    <td class="text-center">
                                                        {{--{!!  Html::image('/uploads/'.$photo, 'style="height: 40px; width: 40px;"') !!}--}}
                                                        <img class="img-responsive text-center" src="/uploads/@if(count($teacher->photos)>0){{$teacher->photos->last()->name}} @else{{'image-not.png'}}@endif"  id="dImg" style="height:40px; width: 40px;" />

                                                    </td>
                                                    {{--<td><span class="glyphicon glyphicon-user fa-man" aria-hidden="true"></span></td>--}}
                                                    <td class="text-center">
                                                            {{ $teacher->first_name.' '.$teacher->last_name ?? 'Not Available' }}
                                                                                                            </td>

                                                    <td class="text-center">{{ $teacher->email ?? 'not given'}}</td>
                                                    <td class="text-center">
                                                            {{ $teacher->department->name ?? 'not given'}}
                                                    </td>
                                                    <td class="text-center">
                                                            {{ $teacher->designation->name ?? 'not given' }}</td>

                                                        <td class="text-center">
                                                            {{ $teacher->address ?? 'not given' }}
                                                    </td>
                                                    <td class="text-center">{{ $teacher->phone ?? 'not given'  }}</td>
                                                    <td class="text-center">
                                                        {{$teacher->gender->gender_name }}
                                                    </td>
                                                    <td class="text-center">
                                                            {{ $teacher->religion->name ?? 'not given'  }}
                                                    </td>
                                                    <td>
                                                        <a class="btn btn-primary btn-xs mrg" data-original-title="{{ trans('translate.view') }}" data-toggle="tooltip" href="{{ route('teacher-view',[$teacher->id]) }}">
                                                            <i class="fa fa-check-square-o"></i></a>
                                                        <a class="btn btn-success btn-xs mrg" data-original-title="{{ trans('translate.edit') }}" data-toggle="tooltip" href="{{ route('teacher-edit-form',[$teacher->id]) }}"><i class="fa fa-edit"></i></a>

                                                        <a  class="btn btn-danger delete_btn btn-xs mrg" onclick="return confirm('Are you sure?')" data-original-title="{{ trans('translate.delete') }}" data-toggle="tooltip" href="{{ route('teacher-delete',[$teacher->id]) }}"><i class="fa fa-trash-o"></i></a>
                                                    </td>

                                                </tr>
                                            @endforeach
                                        @else
                                            <tr>
                                                <td>
                                                    Sorry !!! No Teachers Found........
                                                </td>
                                            </tr>


                                        @endif
                                        </tbody>
                                    </table>
                                    <div class="pagination">{!!   str_replace('/?','?',$teacherList->render() ) !!} </div>
                                    {{--this function is described in the helper/formFunctionHelper.php page and the
                                    parameteres are provided from the relevant controller i.e UsersController in this case--}}
                                    {{--                                    {!! dataTableList($usersList,null,null,$model) !!}--}}
                                </div><!-- /.box-body -->
                            </div><!-- /.box -->
                        </div>
                    </div> <!--row last-->
                </div>
            </div>
        </div>
    </div>
@endsection