@extends('default.admin.layouts.master')

@section('style')
    {!! Html::style('css/styles.css') !!}
@endsection

@section('content')

    <div class="container-fluid min_height_area" id="timetable">
        <div class="row">
            <div class="col-md-12">
                <div class="student-box-header">
                    <div class="col-md-6 col-xs-6">
                        <span class="glyphicon glyphicon-user "
                              aria-hidden="true"></span>{{ trans('sidebar.timetable_list') }}
                    </div>
                    <div class="col-md-6 col-xs-6 snt">
                        <ul class="breadcrumb text-right">
                            <li>
                                <a href="{!! route('timetable-create-form') !!}"><i
                                            class="fa fa-plus"></i> {{ trans('sidebar.create_timetable') }}</a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div> <!--row-->
        <div class="row">
            <div class="col-md-12">
                <div class="view-header">
                    <button onclick="javascript:window.print()" class="btn btn-primary"><span
                                class="fa fa-print"></span> {{ trans('translate.print') }} </button>
                    <button onclick="javascript:window.print()" class="btn btn-primary"><span
                                class="fa fa-file"></span> {{ trans('translate.print_preview') }} </button>
                    <button class="btn btn-primary"><span class="fa fa-file"></span> {{ trans('translate.edit') }}
                    </button>

                </div>
            </div>


            @if(session()->has('success'))
                <div class="col-md-8 col-md-offset-2 text-center">
                    <div class="alert alert-success successOrErrorMsgDiv">
                        <p>{{session()->get('success')}}</p>
                    </div>
                </div>
            @endif
            @if(session()->has('error'))
                <div class="col-md-8 col-md-offset-2 text-center">
                    <div class="alert alert-danger successOrErrorMsgDiv">
                        <p class="">{{session()->get('error')}}</p>
                    </div>
                </div>
            @endif
            @if ($errors->any())
                <div class="col-md-8 col-md-offset-2 text-capitalize">
                    <div class="alert alert-warning successOrErrorMsgDiv">
                        @foreach ($errors->all() as $error)
                            <p>{{ $error }}</p>
                        @endforeach
                    </div>
                </div>
            @endif
        </div> <!--row-->


        <div class="inner-box">
            <div class="row">
                <div id="datatable">
                    <div class="row last">
                        <div class="col-sm-12 col-xs-12">
                            <div class="box">
                                <div class="box-body auto_scroll">

                                    <table id="example1" class="table table-bordered table-striped table-responsive">
                                        <thead>

                                        <tr>
                                            <th colspan="4"></th>
                                            <th>


                                            </th>
                                        </tr>
                                        <tr>
                                            <th>{{ trans('translate.sl') }}</th>
                                            <th>{{ trans('translate.start_time') }}</th>
                                            <th>{{ trans('translate.end_time') }}</th>
                                            <th>{{ trans('translate.status') }}</th>

                                            <th class="text-center">{{ trans('translate.action') }}</th>
                                        </tr>
                                        </thead>
                                        <tbody>

                                        @foreach($timetableList as$key=>$timetable)
                                            <tr>
                                                <td>{{ $key+1 }}</td>
                                                <td>{{date('d F o', strtotime($timetable->start_date)) }}</td>
                                                <td>{{date('d F o', strtotime($timetable->end_date)) }}</td>
                                                <td>{{ getActiveInactive($timetable->status)}}</td>

                                                <td class="text-center">

                                                    <a class="btn btn-success btn-xs mrg"
                                                       data-original-title="Allocation" data-toggle="tooltip"
                                                       href="{{ route('timetable-manage-allocation',[$timetable->id]) }}">
                                                        <i class="fa fa-clock-o"></i> Allocation</a>

                                                    <a class="btn btn-info btn-xs mrg"
                                                       data-original-title="Manage Section" data-toggle="tooltip"
                                                       href="{{ route('timetable-manage-section',[$timetable->id]) }}">
                                                        <i class="fa fa-clock-o"></i> Section</a>
                                                    <a class="btn btn-success btn-xs mrg"
                                                       data-original-title="{{ trans('translate.edit') }}"
                                                       data-toggle="tooltip"
                                                       href="{{ route('timetable-edit',[$timetable->id]) }}"><i
                                                                class="fa fa-edit"></i></a>
                                                </td>
                                            </tr>
                                        @endforeach
                                        </tbody>

                                    </table>
                                    <div class="pagination">{!!   str_replace('/?','?',$timetableList->render() ) !!} </div>
                                </div><!-- /.box-body -->
                            </div><!-- /.box -->
                        </div>
                    </div> <!--row last-->
                </div>
            </div>
        </div>

    </div>

@endsection


@section('scripts')


@endsection


