@extends('default.admin.layouts.master')

@section('style')
    {!! Html::style('css/styles.css') !!}
@endsection

@section('content')

    <div class="container-fluid min_height_area">
        <div class="row">
            <div class="col-md-12">
                <div class="student-box-header">
                    <div class="col-md-6 col-xs-6">
                        <span class="glyphicon glyphicon-user " aria-hidden="true"></span>
                        {{ trans('sidebar.employee_list') }}
                    </div>
                    <div class="col-md-6 col-xs-6 snt">
                        <ul class="breadcrumb text-right">
                            <li>
                                <a href="{!! route('user-add-form') !!}"><i class="fa fa-plus"></i> {{ trans('sidebar.user-create') }}</a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
        </div> <!--row-->
        <div class="row">
            <div class="col-md-12">
                <div class="view-header">
                    <button onclick="javascript:window.print()" class="btn btn-primary"><span class="fa fa-print"></span> {{ trans('translate.print') }} </button>
                     <button onclick="javascript:window.print()" class="btn btn-primary"><span class="fa fa-file"></span> {{ trans('translate.print_preview') }} </button>
                    <button class="btn btn-primary"><span class="fa fa-file"></span> {{ trans('translate.edit') }}</button>
                </div>
            </div>
        </div> <!--row-->
        <div class="inner-box">
            <div class="row">
                <div id="datatable">
                    <div class="row last">
                        <div class="col-sm-12 col-xs-12">
                            <div class="box">
                               
                                <div class="box-body auto_scroll">
                                    <table id="example1" class="table table-bordered table-striped">
                                        <thead>
                                        <tr>
                                             <th>{{ trans('translate.sl') }}</th>
                                            <th class="text-center">{{ trans('translate.photo') }}</th>
                                            <th class="text-center">{{ trans('translate.name') }}</th>
                                            <th class="text-center">{{ trans('translate.email') }}</th>
                                            <th class="text-center">{{ trans('translate.department') }}</th>
                                            <th class="text-center">{{ trans('translate.designation') }}</th>
                                            <th class="text-center">{{ trans('translate.address') }}</th>
                                            <th class="text-center">{{ trans('translate.phone') }}</th>
                                            <th class="text-center">{{ trans('translate.gender') }}</th>
                                           {{-- <th class="text-center">{{ trans('translate.religion') }}</th>--}}
                                            <th class="text-center th_width_100">{{ trans('translate.action') }}</th>

                                        </tr>
                                        </thead>
                                        <tbody>

                                        @set('sl',1)

                                        @if(count($employeeList)>0 && !empty($employeeList))

                                            @foreach($employeeList as $key => $user)
                                                <tr>
                                                    <td>{{$sl++}}</td>

                                                    <td class="text-center">
                                                        @if( count($user->photos)>0)
                                                            {{--{!!  Html::image('imagecache/dummy/'.$user->photos->last()->name) !!}--}}
                                                            {!!  Html::image('uploads/'.$user->photos->last()->name, 'alt', array( 'width' => 70, 'height' => 70,'class' => 'img-rounded' )) !!}
                                                        @else
                                                            {{--<img class="img-thumbnail " src="http://www.bsmc.net.au/wp-content/uploads/No-image-available.jpg " alt="">--}}
                                                        @endif

                                                    </td>     {{--<td><span class="glyphicon glyphicon-user fa-man" aria-hidden="true"></span></td>--}}
                                                    <td class="text-center">
                                                            {{$user->first_name.' '.$user->last_name }}
                                                    </td>

                                                    <td class="text-center">{{ $user->email ?? 'Not Available'}}</td>
                                                    <td class="text-center">
                                                            {{ $user->department->name ?? 'Not Available'}}
                                                    </td>
                                                    <td class="text-center">
                                                            {{ $user->designation->name ?? 'Not Available' }}

                                                    </td>
                                                    <td class="text-center">
                                                       {{ $user->address ?? 'Not Available' }}

                                                    </td>
                                                    <td class="text-center">{{ $user->phone ?? 'Not Available' }}</td>

                                                    <td class="text-center">
                                                       {{ $user->gender->gender_name ?? 'Not Available'}}
                                                    </td>
                                                    {{--<td class="text-center">
                                                            {{ $user->religion->name ?? 'Not Available' }}
                                                    </td>--}}
                                                    <td>
                                                        <a class="btn btn-primary btn-xs mrg" data-original-title="{{ trans('translate.view') }}" data-toggle="tooltip" href="{{ route('user-view',[$user->id]) }}">
                                                            <i class="fa fa-check-square"></i></a>
                                                        <a class="btn btn-success btn-xs mrg" data-original-title="{{ trans('translate.edit') }}" data-toggle="tooltip" href="{{ route('emp-position-edit-form',[$user->id]) }}">
                                                            <i class="fa fa-edit"></i></a>

                                                        <a  class="btn btn-danger btn-xs" data-original-title="{{ trans('translate.delete') }}" data-toggle="tooltip" href="{{ route('emp-position-delete',[$user->id]) }}">
                                                            <i class="fa fa-trash-o"></i></a>
                                                    </td>

                                            </tr>


                                        @endforeach
                                    @else

                                            <tr>
                                                <td colspan="10" class="text-center text-danger">
                                                    Sorry !!! No Employees Found........
                                                </td>
                                            </tr>

                                        @endif
                                        </tbody>
                                    </table>
                                    <div class="pagination">{!!   $employeeList->links()  !!} </div>
                                    {{--this function is described in the helper/formFunctionHelper.php page and the
                                    parameteres are provided from the relevant controller i.e UsersController in this case--}}
{{--                                    {!! dataTableList($usersList,null,null,$model) !!}--}}
                                </div><!-- /.box-body -->
                            </div><!-- /.box -->
                        </div>
                    </div> <!--row last-->
                </div>
            </div>
        </div>
    </div>



@endsection
@section('scripts')

    @parent
    <script src="{{ asset('theme_components/admin/plugins/datatables/jquery.dataTables.min.js') }}"></script>
    {!! Html::script('theme_components/admin/plugins/datatables/dataTables.bootstrap.min.js') !!}

@endsection