<div class="box box-solid bg-teal-gradient">
    <div class="box-header">
        <i class="fa fa-th"></i>
        <h3 class="box-title">Employee Attendance Graph</h3>
        <input type="hidden" value="3">
        <div class="box-tools pull-right">
            <button class="btn bg-teal btn-sm" id="3-reload" title="Reload Graph Data"><i class="fa fa-refresh"></i>
            </button>
            <button class="btn bg-teal btn-sm" data-widget="collapse"><i class="fa fa-minus"></i></button>
            <button class="btn bg-teal btn-sm" data-widget="remove"><i class="fa fa-times"></i></button>

        </div>
    </div>
    <div class="box-body border-radius-none">
        <div class="chart" id="line-chart" style="height: 250px;"></div>
    </div><!-- /.box-body -->
   {{-- <div class="box-footer no-border">
        <div class="row">
            <div class="col-xs-4 text-center" style="border-right: 1px solid #f4f4f4">
                <input type="text" class="knob" id="3-office_day" data-readonly="true" value="70" data-width="60"
                       data-height="60" data-fgColor="#39CCCC">
                <div class="knob-label">Office Day</div>

            </div><!-- ./col -->
            <div class="col-xs-4 text-center" style="border-right: 1px solid #f4f4f4">
                <input type="text" class="knob" id="3-holy_day" data-readonly="true" value="18" data-width="60"
                       data-height="60" data-fgColor="#39CCCC">
                <div class="knob-label">Holiday</div>
            </div><!-- ./col -->
            <div class="col-xs-4 text-center">
                <input type="text" class="knob" id="3-friday" data-readonly="true" value="12" data-width="60"
                       data-height="60" data-fgColor="#39CCCC">
                <div class="knob-label">Friday</div>
            </div><!-- ./col -->
        </div><!-- /.row -->
    </div><!-- /.box-footer -->--}}
</div><!-- /.box -->



@section('scripts')

    <script src="https://cdnjs.cloudflare.com/ajax/libs/raphael/2.1.0/raphael-min.js"></script>
    {!! Html::script('theme_components/admin/plugins/morris/morris.min.js') !!}


    <script>
        $(function () {

            'use strict';

            function getData() {

                $('#3-reload > i').removeClass('fa-refresh');
                $('#3-reload > i').addClass('fa-refresh fa-spin');

                var line = new Morris.Line({
                    element: 'line-chart',
                    resize: true,
                    data: []
                });

                var val = [];

                $.ajax({
                    type: "GET",
                    url: "{{route('site-employee-attendance-dashboard-date-wise-attendance-graph',[''])}}",
                    data: {
                        'month': 10,
                    },
                    success: function (data) {

                        console.log(data[0]);

                        val = data[0];
                        var office_day = data[1];
                        var holy_day = data[2];
                        var friday = data[3];

                        $("#3-office_day").val(office_day);
                        $("#3-holy_day").val(holy_day);
                        $("#3-friday").val(friday);


                        var line = new Morris.Line({
                            element: 'line-chart',
                            resize: true,
                            data: val,
                            xkey: 'y',
                            ykeys: ['Employee'],
                            labels: ['Present Employee'],
                            lineColors: ['#efefef'],
                            lineWidth: 2,
                            hideHover: 'auto',
                            gridTextColor: "#fff",
                            gridStrokeWidth: 0.4,
                            pointSize: 4,
                            pointStrokeColors: ["#efefef"],
                            gridLineColor: "#efefef",
                            gridTextFamily: "Open Sans",
                            gridTextSize: 10
                        });

                    },
                    error: function (data) {
                        console.log(data)
                        $.growl.error({message: data.responseText});
                        $('#3-reload').css('display', 'block');
                    }, complete: function () {
                        $('#3-reload > i').removeClass('fa-refresh fa-spin');
                        $('#3-reload > i').addClass('fa-refresh');
                    }
                });
            }

            getData();

            $('#3-reload').on('click', function () {
                getData();
            });


        });
    </script>

@endsection