<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Non Site Institute</title>

    <style>
        @font-face {
            font-family: 'Verdana';
            font-weight: normal;
            font-style: normal;
            src: url("{{ public_path() }}/fonts/Verdana.ttf") format("truetype");
        }

        @page {
    size: A4 landscape;
    margin: 20px;
}

        body {
            font-family: 'Verdana', sans-serif;
            font-size: 12px;
            margin: 0;
            padding: 0;
        }

        h2 {
            text-align: center;
            margin-bottom: 20px;
        }

        table.data-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        table.data-table thead {
            background-color: #f0f0f0;
            font-weight: bold;
        }

        table.data-table th,
        table.data-table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: center;
        }

        table.data-table tbody tr:nth-child(even) {
            background-color: #f9f9f9;
        }

        .footer {
            position: fixed;
            bottom: 10px;
            left: 0;
            right: 0;
            text-align: center;
            font-size: 10px;
            color: #888;
        }
    </style>
</head>

<body>

    <div class="header">
        <table width="100%;" border="0" style="border: none">
            <tr>
                <td style="width: 25%;">
                    <span>

                        <img style="float: left" src="{{ public_path('image/edu.png') }}" width="100" height="60">
                    </span>
                    </td>
                <td style="width: 50%; text-align: center; /*border: 1px solid green*/">

                    <div style="width: 100%; text-align: center">
                        <span class="sitename" style="font-size: 16px; font-weight:bold ">EDU WORLD</span>
                        <br>
                        <span style="font-size: 11px;">{{ $report_tittle }}</span><br>
                        <br>

                        {{-- <span style="font-weight: bold">dfg</span> --}}
                    </div>
                </td>
                <td style="width: 25%;font-size: 10px;text-align: right;vertical-align: top;">
                    <b>Printed :</b> {{ date('d M Y h:i:s A', time()) }}
                </td>
            </tr>
        </table>


    </div>

    <table class="data-table">
        <thead >
            <tr>
                <th>#</th>
                <th>Division</th>
                <th>District</th>
                <th>Thana</th>
                <th>
                    Institute
                </th>
                <th>Mobile</th>
                <th>E-mail</th>

            </tr>
        </thead>
        <tbody>
            @forelse ($NonSiteInstituteList as $index => $item)
            <tr>
                <td>{{ $loop->iteration }}</td>
                <td>{{ $item['division_name'] }}</td>
                <td>{{ $item['district_name'] }}</td>
                <td>{{ $item['thana_name'] }}</td>
                <td>{{ $item['institution_name'] }}</td>
                <td>{{ $item['institution_mobile'] ?? '-' }}</td>
                <td>{{ $item['institution_email'] ?? '-' }}</td>
            </tr>
        @empty
            <tr>
                <td class="text-center" colspan="8">No institutes found.</td>
            </tr>
        @endforelse
        </tbody>
    </table>

    <div class="footer">
        Printed on: {{ \Carbon\Carbon::now()->format('Y-m-d H:i') }}
    </div>

</body>

</html>
