<!doctype html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Employee CV</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            color: #333;
        }
        .container {
            width: 80%;
            margin: 0 auto;
            padding: 20px;
        }
        .header, .section {
            margin-bottom: 20px;
        }
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-bottom: 2px solid #007BFF;
            padding-bottom: 10px;
        }
        .header img {
            width: 100px;
            height: 100px;
        }
        .header h1 {
            margin-top: 80px;
            font-size: 24px;
            color: #007BFF;
            position: absolute
        }
        .section h2 {
            margin: 0;
            font-size: 20px;
            border-bottom: 2px solid #007BFF;
            color: #007BFF;
            padding-bottom: 5px;
        }
        .section table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }
        .section table th, .section table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }
        .section table th {
            background-color: #007BFF;
            color: white;
        }
        .footer {
            text-align: center;
            padding: 10px;
            background-color: #007BFF;
            color: white;
            position: fixed;
            bottom: 0;
            width: 100%;
        }
    </style>
</head>
<body>
    @foreach ($employees as $employee)
        <div class="container">
            <div class="header">
                @if(file_exists(public_path("uploads").'/'.$employee->latestPhoto->name))
                <img class="img"
                     src="{{public_path("uploads").'/'.$employee->latestPhoto->name  ?? 'image-not.png'}}">
            @else
                <img class="img"
                     src="{{public_path("uploads").'/image-not.png'}}">
            @endif
                <h1>{{ $employee['full_name'] }}</h1>
            </div>
            <div class="section personal-info">
                <h2>Personal Information</h2>
                <table>
                    <tbody>
                        <tr>
                            <th>ID</th>
                            <td>{{ $employee['username'] }}</td>
                        </tr>
                        <tr>
                            <th>Email</th>
                            <td>{{ $employee['email'] }}</td>
                        </tr>
                        <tr>
                            <th>Contact</th>
                            <td>{{ $employee['contact_number'] }}</td>
                        </tr>
                        <tr>
                            <th>Gender</th>
                            <td>{{ $employee['gender_name'] }}</td>
                        </tr>
                        <tr>
                            <th>Religion</th>
                            <td>{{ $employee['religion_name'] }}</td>
                        </tr>
                        <tr>
                            <th>Designation</th>
                            <td>{{ $employee['designation_name'] }}</td>
                        </tr>
                        <tr>
                            <th>Address</th>
                            <td>{{ $employee['address'] ?? 'N/A' }}</td>
                        </tr>
          
                        <tr>
                            <th>Mother</th>
                            <td>{{ $employee['mother_name'] ?? 'N/A' }}</td>
                        </tr>
                        <tr>
                            <th>Father</th>
                            <td>{{ $employee['father_name'] ?? 'N/A' }}</td>
                        </tr>
                        <tr>
                            <th>Permanent Address</th>
                            <td>{{ $employee['permanent_address'] ?? 'N/A' }}</td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="section education">
                <h2>Education</h2>
                <table>
                    <thead>
                        <tr>
                            <th>Examination</th>
                            <th>Board/University</th>
                            <th>Passing Year</th>
                            <th>GPA</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($employee['EmployeeEducationBackground'] as $education)
                            <tr>
                                <td>{{ $education['examination'] ?? 'N/A' }}</td>
                                <td>{{ $education['board_university_name'] ?? 'N/A' }}</td>
                                <td>{{ $education['passing_year'] ?? 'N/A' }}</td>
                                <td>{{ $education['gpa'] ?? 'N/A' }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="section experience">
                <h2>Experience</h2>
                <table>
                    <thead>
                        <tr>
                            <th>Company</th>
                            <th>Position</th>
                            <th>From</th>
                            <th>To</th>
                            <th>Responsibilities</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($employee['empExperiance'] as $experience)
                            <tr>
                                <td>{{ $experience['company_name'] ?? 'N/A' }}</td>
                                <td>{{ $experience['position_held'] ?? 'N/A' }}</td>
                                <td>{{ $experience['from_date'] }}</td>
                                <td>{{ $experience['to_date'] }}</td>
                                <td>{{ $experience['responsibilites'] ?? 'N/A' }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        <div style="page-break-after: always;page-break-inside:avoid;"></div>
    @endforeach
</body>
</html>
