<!doctype html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Employee CV</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
            color: #333;
        }

        .container {
            width: 100%;
            /* margin: 0 auto; */
            /* padding: 20px; */
        }

        .header,
        .section {
            margin-bottom: 20px;
        }

        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            border-bottom: 2px solid #007BFF;
            padding-bottom: 10px;
        }

        .header img {
            width: 100px;
            height: 100px;
        }

        .header h1 {
            margin-top: 80px;
            font-size: 24px;
            color: #007BFF;
            position: absolute
        }

        .section h2,
        {
        margin: 0;
        font-size: 20px;
        border-bottom: 2px solid #007BFF;
        color: #007BFF;
        padding-bottom: 5px;
        }

        .section table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        .section table th,
        .section table td {
            border: 1px solid #ddd;
            padding: 8px;
            text-align: left;
        }

        .section table th {
            background-color: #007BFF;
            color: white;
        }

        .footer {
            text-align: center;
            padding: 10px;
            background-color: #007BFF;
            color: white;
            position: fixed;
            bottom: 0;
            width: 100%;
        }
    </style>
</head>

<body>
    @php($site = getSiteInfoForPdf())


    <div class="container">


        <div style="width: 100%; ">

            <table>
                <tr>
                    <td style="width: 50%;">
                        <span>
                            <img style="float: left" src="{{public_path($site->site_logo)}}" width="60" height="55">
                        </span>
                        </td>
                    <td style="width: 900%; text-align: center; /*border: 1px solid green*/">

                        <div style="width: 100%; text-align: center">
                        <span class="sitename" style="font-size: 28px; font-weight:bold ">{!! $site->site_name !!}</span> <br>
                        <span style="font-size: 20px;">{!! $site->address !!}</span><br>


                        {{-- <span style="font-weight: bold">sdffd </span> --}}
                        </div>
                    </td>
                    <td style="width: 50%;font-size: 10px;text-align: right;vertical-align: top;">
                        <b>Printed :</b> {{date('d M Y h:i:s A',time())}}
                    </td>
                </tr>
            </table>

            <div class="section personal-info" style="margin-top: 30px;">

                <span style="font-size: 25px;color:#007BFF">ব্যক্তিগত তথ্য বিবরণী <span style="font-size:20px">(Personal
                        Data Sheet) </span></span>
                <h2></h2>
                <table>
                    <tbody>

                        <tr>
                            <td>নাম</td>
                            <td>{{$employee->first_name}}</td>
                            <td rowspan="4" style="width:20px"><img width="130" height="150" src="{{ public_path($employee->latestPhoto->path) }}" alt=""></td>
                        </tr>
                        <tr>
                            <td> পিতার নাম </td>
                            <td>{{$employee->father_name}}</td>
                        </tr>
                        <tr>
                            <td>মাতার নাম</td>
                            <td>{{$employee->mother_name}}</td>
                        </tr>
                        <tr>
                            <td> মোবাইল নম্বর </td>
                            <td>{{$employee->contact_number}}</td>
                        </tr>
                        <tr>
                            <td>বর্তমান ঠিকানা</td>
                            <td colspan="2">{{$employee->address}}</td>
                        </tr>
                        <tr>
                            <td>স্থায়ী ঠিকানা</td>
                            <td colspan="2">{{$employee->permanent_address}}</td>
                        </tr>

                    </tbody>
                </table>
            </div>
            <div class="section personal-info" style="margin-top: 30px;">

                <table>
                    <tbody>

                        <tr>
                            <td style="background:#b5d0ee;color:black">এনআইডি নম্বর</td>
                            <td>{{$employee->nid_number}}</td>
                            <td style="background:#b5d0ee;color:black">জন্ম তারিখ</td>
                           <td> {{$employee->date_of_birth}}</td>
                            <td style="background:#b5d0ee;color:black">জাতীয়তা</td>
                            <td>{{$employee->nationality}}</td>
                        </tr>
                        <tr>
                            <td style="background:#b5d0ee;color:black">জন্ম নিবন্ধন নম্বর</td>
                            <td>{{$employee->birth_certificate_no}}</td>
                            <td style="background:#b5d0ee;color:black"> ধর্ম </td>
                            <td>{{$employee->religion->name}}</td>
                            <td style="background:#b5d0ee;color:black">বৈবাহিক অবস্থা</td>
                            <td></td>
                        </tr>
                        <tr>
                            <td style="background:#b5d0ee;color:black">ই-মেইল</td>
                            <td>{{$employee->email}}</td>
                            <td style="background:#b5d0ee;color:black"> ব্লাড গ্রুফ</td>
                            <td>{{$employee->blood_group}}</td>
                            <td style="background:#b5d0ee;color:black">লিঙ্গ</td>
                            <td>{{$employee->gender->gender_name}}</td>
                        </tr>


                    </tbody>
                </table>
            </div>

            <div class="section personal-info">

                <span style="font-size: 25px;color:#007BFF">পেশাগত পরিচিতি </span></span>
                <h2></h2>
                <table>
                    <tbody>

                        <tr>
                            <td style="width: 30%">প্রথম শিক্ষা প্রতিষ্ঠানের নাম</td>
                            <td></td>

                        </tr>
                        <tr>
                            <td style="width: 30%"> প্রথম যোগদানের তারিখ </td>
                            <td></td>
                        </tr>
                        <tr>
                            <td style="width: 30%">যোগদানের ধরণ</td>
                            <td></td>
                        </tr>
                        <tr>
                            <td style="width: 30%"> যোগদানের সময় পদবী </td>
                            <td></td>
                        </tr>
                        <tr>
                            <td style="width: 30%"> যোগদানের সময়ে বিষয় </td>
                            <td></td>
                        </tr>
                        <tr>
                            <td style="width: 30%"> যোগদানের সময়ে বেতন গ্রেড ও বেতন স্কেল </td>
                            <td></td>
                        </tr>
                        <tr>
                            <td style="width: 30%"> বর্তমান পদবী </td>
                            <td></td>
                        </tr>
                        <tr>
                            <td style="width: 30%"> বর্তমান বেতন স্কেল </td>
                            <td></td>
                        </tr>
                        <tr>
                            <td style="width: 30%"> বর্তমান মূল বেতন</td>
                            <td></td>
                        </tr>
                        <tr>
                            <td style="width: 30%"> পাঠদানের বিষয়</td>
                            <td></td>
                        </tr>


                    </tbody>
                </table>
            </div>
            <br>

            <div class="section personal-info">

                <span style="font-size: 25px;color:#007BFF">এমপিও ভুক্তির বিবরণী </span></span>
                <h2></h2>
                <table>
                    <tbody>

                        <tr>
                            <td style="width: 30%">এমপিও ভুক্ত কি না?</td>
                            <td></td>

                        </tr>
                        <tr>
                            <td style="width: 30%"> ১ম এমপিও তে পাপ্ত পদবী </td>
                            <td></td>
                        </tr>
                        <tr>
                            <td style="width: 30%"> ১ম এমপিও ভুক্তির তারিখ</td>
                            <td></td>
                        </tr>
                        <tr>
                            <td style="width: 30%"> ইনডেস্ক নম্বর</td>
                            <td></td>
                        </tr>
                        <tr>
                            <td style="width: 30%"> এমপিও ভুক্ত প্রতিষ্ঠানের নাম</td>
                            <td></td>
                        </tr>
                        <tr>
                            <td style="width: 30%"> এমপিও তে পদোন্নতি পেয়ে থাকলে পদের নাম ও পদোন্নতি প্রাপ্তির তারিখ</td>
                            <td></td>
                        </tr>



                    </tbody>
                </table>
            </div>
            <div class="section education">

                <span style="font-size: 25px;color:#007BFF">শিক্ষাগত যোগ্যতা </span></span>
                <h2></h2>
                <table>

                        <tr>
                            <td>বোর্ড/বিশ্ববিদ্যালয়</td>
                            <td>পাসের সন</td>
                            <td>পরিক্ষা/ডিগ্রির নাম</td>
                            <td>পাসের সন</td>
                        </tr>

                    <tbody>

                        @foreach ($employee['EmployeeEducationBackground'] as $education)
                            <tr>
                                <td>{{ $education['examination']['examination_name'] ?? 'N/A' }}</td>
                                <td>{{ $education['board_university_name'] ?? 'N/A' }}</td>
                                <td>{{ $education['passing_year'] ?? 'N/A' }}</td>
                                <td>{{ $education['gpa'] ?? 'N/A' }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            <div class="section experience">
                <span style="font-size: 25px;color:#007BFF">অভিজ্ঞতার বিবরনী </span></span>
                <h2></h2>
                <table>

                        <tr>
                            <td>প্রতিষ্ঠানের নাম</td>
                            <td>পদবী </td>
                            <td>দায়িত্ব </td>
                            <td>যোগদানের তারিখ </td>
                            <td>Responsibilities</td>
                        </tr>

                    <tbody>
                        @foreach ($employee['empExperiance'] as $experience)
                            <tr>
                                <td>{{ $experience['company_name'] ?? 'N/A' }}</td>
                                <td>{{ $experience['position_held'] ?? 'N/A' }}</td>
                                <td>{{ $experience['from_date'] }}</td>
                                <td>{{ $experience['to_date'] }}</td>
                                <td>{{ $experience['responsibilites'] ?? 'N/A' }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        <div style="page-break-after: always;page-break-inside:avoid;"></div>

</body>

</html>
