<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| Api Routes
|--------------------------------------------------------------------------
|
| Here is where you can register Api routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your Api!
|
*/


Route::group(['namespace' => 'Api'], function () {

    Route::group(['prefix' => 'web'], function () {

        Route::get('get-common-data', 'WebSiteController@commonData')->name('api-web-get-common-data');
        Route::get('get-visitor-count', 'WebSiteController@visitorCount')->name('api-web-get-visitor-count');
        Route::get('get-latest-notice', 'WebSiteController@getLatestNotice')->name('api-web-get-latest-notice');
        Route::get('get-latest-notice-for-sitebar', 'WebSiteController@getLatestNoticeForSiteber')->name('api-web-get-latest-notice-for-sitebar');
        Route::get('get-all-notice', 'WebSiteController@getNoticeListWithPagination')->name('api-web-get-all-notice');
        Route::get('get-slide-item', 'WebSiteController@getSlideItem')->name('api-web-get-slide-item');
        Route::get('get-event-item', 'WebSiteController@getEventItem')->name('api-web-get-event-item');
        Route::get('get-latest-about-us', 'WebSiteController@getLatestAboutUs')->name('api-web-get-latest-about-us');
        Route::get('get-head-of-authority-message', 'WebSiteController@getHeadOfAuthorityMessageList')->name('api-web-get-head-of-authority-message');
        Route::get('get-about-us', 'WebSiteController@getAboutUs')->name('api-web-get-about-us');

        Route::get('get-job-circular', 'WebSiteController@getJobCircular')->name('get-job-circular');
        Route::post('store-job-application', 'WebSiteController@StoreJobApplocation')->name('store-job-application');

        Route::get('get-video-list-for-home', 'WebSiteController@getVideoListForHome')->name('api-web-get-video-list-for-home');
        Route::get('get-class-room-details', 'WebSiteController@getClassRoomDetails')->name('api-web-get-class-room-details');
        Route::get('get-edu-class-room-details', 'WebSiteController@getEduClassRoomDetails')->name('api-web-get-edu-class-room-details');
        Route::get('monthwise-calendar-list', 'WebSiteController@getCalendarList')->name('api-web-get-monthwise-calendar-list');
        Route::get('academic-group-list', 'WebSiteController@getAcademicGroupList')->name('api-web-get-academic-group-list');
        Route::get('yearly-calendar-list', 'WebSiteController@getYearlyCalendarList')->name('api-web-get-yearly-calendar-list');

        Route::get('employee-list-with-pagination', 'WebSiteController@getEmployeeListWithPagination')->name('api-web-get-employee-list-with-pagination');
        Route::get('event-list-with-pagination', 'WebSiteController@getEventListWithPagination')->name('api-web-get-event-list-with-pagination');
        Route::get('video-list-with-pagination', 'WebSiteController@getVideoListWithPagination')->name('api-web-get-video-list-with-pagination');
        Route::get('prospectus-list-with-pagination', 'WebSiteController@getProspectusListWithPagination')->name('api-web-get-prospectus-list-with-pagination');
        Route::get('syllabus-list-with-pagination', 'WebSiteController@getSyllabusListWithPagination')->name('api-web-get-syllabus-list-with-pagination');
        Route::get('institute-document-list-with-pagination', 'WebSiteController@getInstititeDocumentListWithPagination')->name('api-web-get-institute-document-list-with-pagination');
        Route::get('get-office-complaint', 'WebSiteController@getOfficeComplaint')->name('api-web-get-office-complaint');


        Route::get('get-social-icon-list', 'WebSiteController@getSocialIconList')->name('api-web-get-social-icon-list');
//        Route::get('get-class-details', 'WebSiteController@getClassDetails')->name('api-web-get-class-details');

        Route::get('get-student-statistics-details', 'WebSiteController@getStudentStatisticsDetails')->name('api-web-get-student-statistics-details');
        Route::post('student-list-with-pagination', 'WebSiteController@getStudentListWithPagination')->name('api-web-get-student-list-with-pagination');
        Route::get('get-version-year-shift-for-website', 'WebSiteController@getVersionYearShiftForWebsite')->name('api-web-get-version-year-shift-for-website');
        Route::get('get-site-year-version-shift-based-department-class-for-website', 'WebSiteController@getVersionYearShiftBaseDepartmentClassForWebsite')->name('api-web-get-version-year-shift-for-website');
        Route::get('get-class-groups-and-sessions-by-class-for-website', 'WebSiteController@getClassGroupsSessionsByClassForWebsite')->name('api-web-get-class-groups-and-sessions-by-class-for-website');
        Route::get('get-site-class-base-section-for-website', 'WebSiteController@getClassGroupsBaseSectionForWebsite')->name('api-web-get-site-class-base-section-for-website');
    //    Route::get('get-version-year-shift-based-based-sections-or-class-groups-and-sessions-by-class-for-website', 'WebSiteController@getVersionYearShiftBaseDepartmentClassForWebsite')->name('api-web-get-version-year-shift-based-based-sections-or-class-groups-and-sessions-by-class-for-website');

    });

    Route::group(['prefix' => 'web-app'], function () {

         Route::get('get-common-data', 'WebSiteApiController@commonData')->name('api-web-app-get-common-data');
         Route::get('get-visitor-count', 'WebSiteApiController@visitorCount')->name('api-web-app-get-visitor-count');
         Route::get('get-all-notice', 'WebSiteApiController@getNoticeListWithPagination')->name('api-web-app-get-all-notice');
         Route::get('get-about-us', 'WebSiteApiController@getAboutUs')->name('api-web-app-get-about-us');
         Route::get('monthwise-calendar-list', 'WebSiteApiController@getMonthWiseCalendarList')->name('api-web-app-get-monthwise-calendar-list');
         Route::get('academic-group-list', 'WebSiteApiController@getAcademicGroupList')->name('api-web-app-get-academic-group-list');
         Route::get('get-site-info-and-site-settings', 'WebSiteApiController@getSiteInfoAndSiteSettings')->name('api-web-get-site-info-and-site-settings');
         Route::get('yearly-calendar-list', 'WebSiteApiController@getYearlyCalendarList')->name('api-web-app-get-yearly-calendar-list');

         Route::get('event-list-with-pagination', 'WebSiteApiController@getEventListWithPagination')->name('api-web-app-get-event-list-with-pagination');

         Route::get('get-social-icon-list', 'WebSiteApiController@getSocialIconList')->name('api-web-app-get-social-icon-list');

         // exam result
         Route::group(['namespace' => 'Academic'], function () {
            Route::get('get-academic-group-wise-version-year-shift', 'AcademicApiController@getVersionYearShift')->name('api-web-app-get-academic-group-wise-version-year-shift');
            Route::get('get-site-year-version-shift-based-department-class', 'AcademicApiController@getVersionYearShiftBaseDepartmentClass')->name('api-web-app-get-site-year-version-shift-based-department-class');
            Route::get('get-version-year-shift-class-based-class-groups-and-exam-list', 'AcademicApiController@getYearVersionAndShiftBasedDepartmentClassAndExamList')->name('api-web-app-get-version-year-shift-class-based-class-groups-and-exam-list');
            Route::get('get-version-year-shift-class-or-class-group-based-section', 'AcademicApiController@getSiteClassGroupBaseSectionSessionList')->name('api-web-app-get-version-year-shift-class-or-class-group-based-section');
        });



        Route::get('get-student-exam-result', 'AcademicResultApiController@getSiteStudentExamResult')->name('api-web-app-get-student-exam-result');
        Route::get('get-student-exam-result-pdf', 'AcademicResultApiController@getStudentExamResulDetailsPdf')->name('api-web-app-get-student-exam-result-pdf');

        Route::get('get-student-history-list', 'AcademicResultApiController@getStudentAllHistoryListForApi')->name('get-student-history-list-by-student-history');
        Route::post('get-student-primary-result-list-by-student-history', 'AcademicResultApiController@getStudentPrimaryResultListByStudentHistory')->name('get-primary-result-list-by-student-history');
        Route::post('get-student-primary-result-by-student-history', 'AcademicResultApiController@getStudentPrimaryResultByStudentHistory')->name('get-student-primaty-result-by-student-history');
        Route::post('get-student-primary-result-pdf-by-student-history', 'AcademicResultApiController@getStudentPrimaryResultPDFByStudentHistory')->name('get-student-primary-result-pdf-by-student-history');

        Route::get('get-student-fee-info', 'SiteWebPaymentApiController@getStudentFeeInfo')->name('api-web-app-get-student-fee-info');
        Route::get('get-student-fee-info-pdf', 'SiteWebPaymentApiController@getStudentBankSlipPdfForPublic')->name('api-web-app-get-student-fee-info-pdf');
        Route::post('create-student-public-payment', 'SiteWebPaymentApiController@createStudentPublicPayment')->name('api-web-app-create-student-public-payment');
        Route::post('verify-payment-transaction', 'SiteWebPaymentApiController@verifyPaymentTransaction')->name('api-web-app-verify-payment-transaction');
        Route::get('get-site-public-payment-slip/{voucher_no}', 'SiteWebPaymentApiController@getPublicStudentPaymentSlip')->name('api-web-app-get-site-payment-slip');

    });


});


Route::group(['namespace' => 'Api\Site', 'prefix' => 'site'], function () {
    Route::get('get-site-list', 'SiteController@getSiteList')->name('api-get-site-list');//->middleware('client');
    Route::post('get-site-info', 'SiteController@getSiteInfo')->name('api-get-site-info');//->middleware('client');

});
