<?php


//===========================================================StudentPanel=====================================================================
    Route::group(['namespace' => 'SiteGroup', 'prefix' => 'site-group'], function () {

        Route::get('get-site-group-year-month', 'SiteGroupVersionYearShiftDeptClassGroupController@getSiteGroupYearMonthtLoad')->name('get-site-group-year-month');
        Route::get('get-site-group-version-year-shift', 'SiteGroupVersionYearShiftDeptClassGroupController@getSiteGroupVersionYearShiftLoad')->name('get-site-group-version-year-shift');
        Route::get('get-site-group-version-year-shift-base-department-class/{version}/{year}/{shift}', 'SiteGroupVersionYearShiftDeptClassGroupController@getSiteGroupVersionYearShiftBaseDepartmentClass')->name('get-site-version-year-shift-base-department-class');
        Route::get('get-site-group-version-year-base-department-class/{version}/{year}', 'SiteGroupVersionYearShiftDeptClassGroupController@getSiteGroupVersionYearBaseDepartmentClass')->name('get-site-version-year-base-department-class');
        Route::get('get-site-group-department-base-class-list/{department}', 'SiteGroupVersionYearShiftDeptClassGroupController@getSiteGroupDepartmentBaseClassList')->name('get-site-group-department-base-class-list');
        Route::post('get-site-group-class-base-group-session', 'SiteGroupVersionYearShiftDeptClassGroupController@getSiteGroupClassBaseGroupSession')->name('get-site-group-class-base-group-session');

        Route::get('get-site-group-base-site-list', 'SiteGroupVersionYearShiftDeptClassGroupController@getSiteGroupBaseSiteList')->name('get-site-group-base-site-list');

        Route::get('site-group-ata-glance-form', 'SiteGroupGlanceController@siteGroupAtaGlanceGorm')
            ->name('site-group-ata-glance-form');




        Route::group(['prefix' => 'controlling'], function () {
            Route::get('get-site-group-controlling-details-by-site-group-and-academic-group/{sg_id?}/{acc_gr_id?}', 'SiteGroupControllingController@getControllingDetailsBySiteGroupAndAcademicGroup')->name('site-group-get-site-group-controlling-details-by-site-group-and-academic-group');
            Route::post('add', 'SiteGroupControllingController@store')->name('site-group-controlling-insert');

        });

        Route::group(['namespace' => 'Exam', 'prefix' => 'exam'], function () {

            Route::post('get-site-group-exam-controle-list', 'ExamControleSettingController@getSiteGroupExamControleList')->name('get-site-group-exam-controle-list');

        });


        Route::group(['namespace' => 'Fee', 'prefix' => 'fee-setting'], function () {
            Route::get('site-group-fee-setting-form', 'SiteGroupFeeSubHeadAllocationController@index')->name('site-group-fee-setting-form');
            Route::get('get-site-group-fee-head-subhead-group-list', 'SiteGroupFeeSubHeadAllocationController@getSiteGroupFeeHeadSubheadGroupList')->name('get-site-group-fee-head-subhead-group-list');
            Route::post('create-update-fee-head-group-sub-head', 'SiteGroupFeeSubHeadAllocationController@createUpdateFeeHeadGroupSubHead')->name('create-update-fee-head-group-sub-head');

        });
        Route::group(['namespace' => 'Fee\Report', 'prefix' => 'fee-report'], function () {
            // fee management
            Route::get('site-group-wise-stuedent-fee-list', 'SiteGroupStudentFeeController@index')->name('site-group-wise-stuedent-fee-list');
            Route::post('get-group-student-general-fee-list', 'SiteGroupStudentFeeController@getGroupStudentGeneralFeeList')->name('get-group-student-general-fee-list');
            Route::post('general-report-pdf', 'SiteGroupStudentFeeController@GeneralReportPdf')->name('general-report-pdf');

        });


        Route::group(['namespace' => 'Fee', 'prefix' => 'fee-allocation'], function () {
            Route::post('get-site-group-global-fee-head-allocation', 'SiteGroupFeeAllocationController@getSiteGroupGlobalFeeHeadAllocation')->name('get-site-group-global-fee-head-allocation');
            Route::post('get-site-group-classbase-studentbase-fee-head-allocation', 'SiteGroupFeeAllocationController@getSiteGroupClassbaseStudentbaseFeeHeadAllocation')->name('get-site-group-classbase-studentbase-fee-head-allocation');
            Route::post('create-update-site-group-fee-allocation', 'SiteGroupFeeAllocationController@createUpdateSiteGroupFeeAllocation')->name('create-update-site-group-fee-allocation');

        });


        Route::group(['namespace' => 'Fee', 'prefix' => 'fee-generate'], function () {
            Route::post('get-site-group-academic-group-base-site-fee-head-list', 'SiteGroupFeeGenerateController@getSiteGroupAcademicGroupBaseSiteList')->name('get-site-group-academic-group-base-site-fee-head-list');
            Route::post('change-site-base-class-fee-head-list', 'SiteGroupFeeGenerateController@getSiteClassDeptfeeHeadBaseFee')->name('change-site-base-class-fee-head-list');
            Route::post('create-update-site-group-fee-generate', 'SiteGroupFeeGenerateController@createUpdateSiteGroupFeeGenerate')->name('create-update-site-group-fee-generate');
            Route::post('get-site-fee-head-base-type-list', 'SiteGroupFeeGenerateController@getSiteFeeHeadBaseTypeList')->name('get-site-fee-head-base-type-list');

        });


        Route::group(['namespace' => 'Fee', 'prefix' => 'waiver-generate'], function () {
            Route::post('get-site-base-class-fee-list-for-waiver', 'SiteGroupWaiverGenerateController@getSiteBaseClassFeeListForWaiver')->name('get-site-base-class-fee-list-for-waiver');
            Route::post('create-update-site-group-waiver-generate', 'SiteGroupWaiverGenerateController@createUpdateSiteGroupWaiverGenerate')->name('create-update-site-group-waiver-generate');

            Route::get('get-site-group-base-waiver-type-list', 'SiteGroupWaiverGenerateController@getSiteGroupBaseWaiverTypeList')->name('get-site-group-base-waiver-type-list');
            Route::post('get-instent-waiver-base-type-student-list', 'SiteGroupWaiverGenerateController@getInstentWaiverBaseTypeStudentList')->name('get-instent-waiver-base-type-student-list');
            Route::get('get-student-waiver-type-base-waiver-amount/{waivertype}/{studentid}', 'SiteGroupWaiverGenerateController@getStudentWaiverTypeBaseWaiverAmount')->name('get-student-waiver-type-base-waiver-amount');


        });


        Route::group(['namespace' => 'Fee', 'prefix' => 'demand-slip-generate'], function () {
     //       Route::post('get-class-dept-base-site-fee-head-sub-head-list', 'SiteGroupDemandSlipGenerateController@getClassDeptBaseSiteFeeHeadSubHeadList')->name('get-class-dept-base-site-fee-head-sub-head-list');
            Route::post('create-site-group-base-demand-slip', 'SiteGroupDemandSlipGenerateController@createSiteGroupBaseDemandSlip')->name('create-site-group-base-demand-slip');
            Route::post('update-site-group-base-demand-slip', 'SiteGroupDemandSlipGenerateController@updateSiteGroupBaseDemandSlip')->name('update-site-group-base-demand-slip');


        });


        Route::group(['namespace' => 'Fee', 'prefix' => 'payment-slip-generate'], function () {
            Route::post('get-site-group-demand-list-for-payment', 'SiteGroupPaymentSlipGenerateController@getDemandListForPayment')->name('get-site-group-demand-list-for-payment');
            Route::post('create-site-group-base-single-student-fee-payment', 'SiteGroupPaymentSlipGenerateController@createSiteGroupBaseSingleStudentFeePayment')->name('create-site-group-base-single-student-fee-payment');


            Route::post('get-multiple-student-demand-slip-list-for-payment', 'SiteGroupPaymentSlipGenerateController@getMultipleStudentDemandSlipListForPayment')->name('get-multiple-student-demand-slip-list-for-payment');
            Route::post('create-site-group-base-multiple-student-payment', 'SiteGroupPaymentSlipGenerateController@createSiteGroupBaseMultipleStudentPayment')->name('create-site-base-multiple-student-payment');


        });

        Route::group(['prefix' => 'access'], function () {

            Route::get('get-assigned-list-for-the-site-group/{id}', 'SiteGroupAccessController@getAssignedListForTheGroup')->name('site-group-access-get-assigned-list-for-the-site-group');
            Route::post('assign-package-to-site-group', 'SiteGroupAccessController@assignPackagesToSiteGroup')->name('site-group-assign-package-to-site-group');

        });

        Route::group(['prefix' => 'user'], function () {

            Route::get('list', 'SiteGroupUserController@index')->name('site-group-user-list');
            Route::post('add', 'SiteGroupUserController@siteGroupUserStore')->name('site-group-user-store');

            Route::put('edit/{id}', 'SiteGroupUserController@update')->name('site-group-user-edit');

            Route::get('get-site-group-user-list', 'SiteGroupUserController@siteGroupUserList')->name('site-group-user-get-site-group-user-list');
            Route::get('get-site-group-user-list-with-pagination', 'SiteGroupUserController@getsiteGroupUserListWithPagination')->name('site-group-user-get-site-group-user-list-with-pagination');
            Route::get('get-site-group-user-list-and-role-list-and-site-list', 'SiteGroupUserController@getSiteGroupUserListAndRoleListAndSiteList')->name('site-group-user-get-site-group-user-list-and-role-list-and-site-list');

        });

        Route::group(['prefix' => 'setting'], function () {

            Route::get('list', 'SiteGroupSettingController@index')->name('site-group-setting-list');
            Route::get('get-groupnamelist-from-sitegroup/{id}', 'SiteGroupSettingController@getGroupNameListFromSiteGroups')->name('site-group-setting-get-site-group-setting-list');
            Route::get('get-data-from-academic-group-base-details/{academic_group_id}/{site_group_id}', 'SiteGroupSettingController@getDataByChangeAcademicGroup')->name('site-group-setting-get-group-base-details');
            Route::get('get-group-select-academic-settings/{academic_group_id}/{site_group_id}', 'SiteGroupSettingController@getGroupSettingsList')->name('get-group-select-academic-settings');
         //   Route::get('get-data-from-academic-group-base-details/{academic_group_id}/{site_group_id}', 'SiteGroupSettingController@getAllAcademicDataList')->name('site-group-setting-get-group-base-details');
            Route::get('get-site-group-setting-list-data/{id}', 'SiteGroupSettingController@getSiteGroupSettingListData')->name('site-group-setting-edit');
            Route::post('add', ['as' => 'site-group-setting-create', 'uses' => 'SiteGroupSettingController@store']);
            Route::get('get-all-academic-data-list/{site_group_id}/{academic_group_id}', 'SiteGroupSettingController@getAllAcademicDataList')->name('edu-site-group-setting-get-all-academic-data-list');

        });


        Route::group(['namespace' => 'Admission', 'prefix' => 'admission'], function () {

            Route::get('master-form', 'SiteGroupAdmissionDeclareController@index')->name('site-group-admission-master-form');
            Route::get('site-group-admission-declare-form', 'SiteGroupAdmissionDeclareController@index')->name('site-group-admission-declare-form');
            Route::get('site-group-year-dept-class-shift-version-session-admission-declare-list', 'SiteGroupAdmissionDeclareController@getYearDeptClassShiftVersionSessionAdmissionDeclareList')
                ->name('site-group-year-dept-class-shift-version-session-admission-declare-list');
            Route::post('create-site-group-admission-declare', 'SiteGroupAdmissionDeclareController@createSiteGroupAdmissionDeclare')->name('create-site-group-admission-declare');
            Route::post('update-site-group-admission-declare', 'SiteGroupAdmissionDeclareController@updateSiteGroupAdmissionDeclare')->name('update-site-group-admission-declare');
            Route::post('delete-site-group-admission-declare', 'SiteGroupAdmissionDeclareController@deleteSiteGroupAdmissionDeclare')->name('delete-site-group-admission-declare');

            Route::get('get-site-group-admission-applied-count-list', 'SiteGroupAdmissionDeclareController@getSiteGroupAmissionAppliedCountList')
                ->name('get-site-group-admission-applied-count-list');


            Route::get('get-site-group-admission-result-type-for-loterry', 'SiteGroupAdmissionDeclareController@getSiteGroupAdmissionResultTypeForLoterry')
                ->name('get-site-group-admission-result-type-for-loterry');
            Route::get('get-site-group-admission-detail-list-for-loterry/{type_id}', 'SiteGroupAdmissionDeclareController@getSiteGroupAdmissionDetailListForLoterry')
                ->name('get-site-group-admission-detail-list-for-loterry');
            Route::post('individual-site-admission-loterry-from-site-group', 'SiteGroupAdmissionDeclareController@individualSiteAdmissionLoterryFromSiteGroup')
                ->name('individual-site-admission-loterry-from-site-group');

            Route::post('site-admission-loterry-result-site-group', 'SiteGroupAdmissionDeclareController@siteAdmissionLoterryResultSiteGroup')
                ->name('site-admission-loterry-result-site-group');

            Route::post('site-admission-loterry-delete-site-group', 'SiteGroupAdmissionDeclareController@siteAdmissionLoterryDeleteSiteGroup')
                ->name('site-admission-loterry-delete-site-group');

            Route::post('get-class-applied-student-list-for-site-group', 'SiteGroupAdmissionDeclareController@getClassAppliedStudentListForSiteGroup')
                ->name('get-class-applied-student-list-for-site-group');

            Route::post('site-admission-loterry-publish-from-site-group', 'SiteGroupAdmissionDeclareController@siteAdmissionLoterryPublishFromSiteGroup')
                ->name('site-admission-loterry-publish-from-site-group');

            Route::post('site-admission-loterry-pause-from-site-group', 'SiteGroupAdmissionDeclareController@siteAdmissionLoterryPauseFromSiteGroup')
                ->name('site-admission-loterry-pause-from-site-group');

            Route::post('save-single-class-lottery-result', 'SiteGroupAdmissionDeclareController@saveSingleClassLotteryResult')
                ->name('save-single-class-lottery-result');

        });

        Route::group(['namespace' => 'Exam', 'prefix' => 'exam'], function () {

            //====exam setting====
            Route::get('site-group-examination-setting-master', 'SiteGroupExaminationExamTypeSettingsController@index')->name('site-group-examination-setting-master');
            Route::post('get-site-group-examination-list', 'SiteGroupExaminationExamTypeSettingsController@getSiteGroupExaminationList')->name('get-site-group-examination-list');
            Route::post('get-site-group-examination-exam-type-list', 'SiteGroupExaminationExamTypeSettingsController@getSiteGroupExaminationExamTypeList')->name('get-site-group-examination-exam-type-list');
            Route::post('create-update-site-group-examination-exam-type', 'SiteGroupExaminationExamTypeSettingsController@createUpdateSiteGroupExaminationExamType')->name('create-update-site-group-examination-exam-type');

            //====exam subject setting====
            Route::post('get-site-group-department-class-base-examination-list', 'SiteGroupSubjectExaminationMarkSetupController@getSiteGroupDepartmentClassBaseExaminationList')->name('get-site-group-department-class-base-examination-list');
            Route::post('get-site-group-subject-exam-type-list-marks-setup', 'SiteGroupSubjectExaminationMarkSetupController@getSiteGroupSubjectListForExamTypeMarksSetup')->name('get-site-group-subject-exam-type-list-marks-setup');
            Route::post('site-group-subject-exam-type-marks-setup-submit', 'SiteGroupSubjectExaminationMarkSetupController@siteGroupSubjectListForExamTypeMarksSetupSubmit')->name('site-group-subject-exam-type-marks-setup-submit');


            //====exam declare====
            Route::get('site-group-exam-declare-master', 'SiteGroupBaseExamDeclareController@index')->name('site-group-exam-declare-master');
            Route::post('get-examination-list-for-site-group-exam-declare', 'SiteGroupBaseExamDeclareController@siteGroupExaminationList')->name('get-examination-list-for-site-group-exam-declare');
            Route::post('get-examination-site-list', 'SiteGroupBaseExamDeclareController@siteGroupExaminationSiteList')->name('get-examination-site-list');
            Route::post('create-update-site-group-base-exam-declare', 'SiteGroupBaseExamDeclareController@createUpdateSiteGroupBaseExamDeclare')->name('update-site-group-base-exam-declare');

            //====exam routine====
            Route::post('get-site-group-examination-declare-list', 'SiteGroupBaseExamDeclareController@siteGroupExaminationDeclareList')->name('get-site-group-examination-declare-list');
            Route::post('get-exam-subject-list-for-exam-routine', 'SiteGroupBaseExamDeclareController@getExamRoutineSubjectList')->name('get-exam-subject-list-for-exam-routine');
            Route::post('create-update-site-group-base-exam-routine', 'SiteGroupBaseExamDeclareController@createUpdateSiteGroupBaseExamRoutine')->name('create-update-site-group-base-exam-routine');
            Route::post('site-group-base-exam-routine-pdf', 'SiteGroupBaseExamDeclareController@siteGroupBaseExamRoutinePdf')->name('site-group-base-exam-routine-pdf');

            //====exam roll====
            Route::post('get-site-group-exam-roll', 'SiteGroupStudentExamRollController@getSiteGroupExamRoll')->name('get-site-group-exam-roll');
            Route::post('get-site-group-exam-roll-student-list', 'SiteGroupStudentExamRollController@getSiteGroupExamRollStudentList')->name('get-site-group-exam-roll-student-list');
            Route::post('get-site-group-exam-roll-student-list-pdf', 'SiteGroupStudentExamRollController@getSiteGroupExamRollStudentListPdf')->name('get-site-group-exam-roll-student-list-Pdf');
            Route::post('site-group-student-roll-generate', 'SiteGroupStudentExamRollController@siteGroupStudentRollGenerate')->name('site-group-student-roll-generate');

            //====exam roll====
            Route::post('get-site-group-exam-peaper-token', 'SiteGroupExamPeaperTokenGenerateController@getSiteGroupExamPeaperToten')->name('get-site-group-exam-peaper-token');
            Route::post('get-site-group-exam-token-list-pdf', 'SiteGroupExamPeaperTokenGenerateController@siteGroupExamTokenListPdf')->name('get-site-group-exam-token-list-pdf');

            Route::get('open-report/{name}', 'SiteGroupExamPeaperTokenGenerateController@openReport')->name('site_group-open-pdf-file-storage');

            //====exam attendace====
            Route::get('site-group-exam-attendance-master', 'SiteGroupExamAttendanceReportController@index')->name('site-group-exam-attendance-master');
            Route::post('get-site-group-exam-mark-count-report', 'SiteGroupExamAttendanceReportController@getSiteGroupExamMarkCountReport')->name('get-site-group-exam-mark-count-report');
            Route::post('get-site-group-exam-attendance-count-report', 'SiteGroupExamAttendanceReportController@getSiteGroupExamAttendanceCountReport')->name('get-site-group-exam-attendance-count-report');
            Route::post('get-site-group-mark-count-report-pdf', 'SiteGroupExamAttendanceReportController@getSiteGroupMarkCountReportPdf')->name('get-site-group-mark-count-report-pdf');
            Route::post('get-site-group-exam-attendance-count-report-pdf', 'SiteGroupExamAttendanceReportController@getSiteGroupExamAttendanceCountReportPdf')->name('get-site-group-exam-attendance-count-report-pdf');
            Route::post('get-site-group-exam-attendance-present-absent-list-report-pdf', 'SiteGroupExamAttendanceReportController@getSiteGroupExamPresentAbsentReport')->name('get-site-group-exam-attendance-present-absent-list-report-pdf');
            Route::post('get-site-group-exam-attendance-present-absent-list-report-list-pdf', 'SiteGroupExamAttendanceReportController@getSiteGroupExamPresentAbsentReportPdf')->name('get-site-group-exam-attendance-present-absent-list-report-list-pdf');
            Route::post('get-site-group-exam-mark-list-report-list-pdf', 'SiteGroupExamAttendanceReportController@getSiteGroupMarkReportPdf')->name('get-site-group-exam-mark-list-report-list-pdf');
            Route::post('get-site-group-exam-subject-list', 'SiteGroupExamAttendanceReportController@getSiteGroupExamSubjectList')->name('get-site-group-exam-subject-list');
            Route::post('get-site-group-declared-exam-type-list', 'SiteGroupExamAttendanceReportController@getSiteGroupDeclatedExamTypeList')->name('get-site-group-declared-exam-type-list');

            //====exam paper distribution====
            Route::get('site-group-exam-paper-distribution-master', 'SiteGroupBaseExamPaperDistributionController@index')->name('site-group-exam-paper-distribution-master');
            Route::post('get-site-group-base-answer-paper-distribution', 'SiteGroupBaseExamPaperDistributionController@getSiteGroupBaseAnswerPaperDistribution')->name('get-site-group-base-answer-paper-distribution');
            Route::post('save-site-group-base-answer-paper-distribution', 'SiteGroupBaseExamPaperDistributionController@saveSiteGroupBaseAnswerPaperDistribution')->name('save-site-group-base-answer-paper-distribution');


        });

        Route::group(['namespace' => 'ExamResult', 'prefix' => 'exam-result'], function () {

        //====exam setting====
            Route::get('site-group-exam-result-setting-master', 'SiteGroupBaseResultSystemSettingController@index')->name('site-group-exam-result-setting-master');
            Route::post('get-site-group-base-examination-exam-type-list', 'SiteGroupBaseResultSystemSettingController@getSiteGroupExaminationExamTypeList')->name('get-site-group-base-examination-exam-type-list');
            Route::post('create-update-site-group-result-setting', 'SiteGroupBaseResultSystemSettingController@createUpdateSiteGroupResultSetting')->name('create-update-site-group-result-setting');
            Route::post('get-site-group-base-examination-result-system-list', 'SiteGroupBaseResultSystemSettingController@getSiteGroupBaseResultSystemList')->name('get-site-group-base-examination-result-system-list');
            Route::post('create-update-site-group-result-system-setting', 'SiteGroupBaseResultSystemSettingController@createUpdateSiteGroupResultSystemSetting')->name('create-update-site-group-result-system-setting');

        //====exam result generate====
            Route::get('site-group-exam-result-generate-master', 'SiteGroupExamResultGenerateController@index')->name('site-group-exam-result-generate-master');
            Route::post('get-site-group-result-type-list', 'SiteGroupExamResultGenerateController@getStieGroupBaseResultTypeList')->name('get-site-group-result-type-list');
            Route::post('get-site-group-merit-list-result-type-list', 'SiteGroupExamResultGenerateController@getStieGroupBaseMeritListResultTypeList')->name('get-site-group-merit-list-result-type-list');
            Route::post('create-update-site-group-merit-list-exam-result-generate', 'SiteGroupExamResultGenerateController@createUpdateSiteGroupMeritListExamResultGenerate')->name('create-update-site-group-merit-list-exam-result-generate');
            Route::post('create-update-site-group-exam-result-generate', 'SiteGroupExamResultGenerateController@createUpdateSiteGroupExamResultGenerate')->name('create-update-site-group-exam-result-generate');

        //====exam result report====
            Route::get('site-group-exam-result-report-master', 'SiteGroupExamResultReportController@index')->name('site-group-exam-result-report-master');
            Route::post('get-site-group-result-type-list-for-report', 'SiteGroupExamResultReportController@getStieGroupBaseResultTypeList')->name('get-site-group-result-type-list-for-report');
            Route::post('get-result-generated-site-list', 'SiteGroupExamResultReportController@getResultGeneratedSiteList')->name('get-result-generated-site-list');
            Route::get('get-site-group-primary-result-total-summary-pdf', 'SiteGroupExamResultReportController@getSiteGroupPrimaryResultTotalSummaryPdf')->name('get-site-group-primary-result-total-summary-pdf');
            Route::post('get-site-group-primary-result-total-summary', 'SiteGroupExamResultReportController@getSiteGroupPrimaryResultTotalSummary')->name('get-site-group-primary-result-total-summary');

            Route::post('get-site-group-primary-result-pass-fail-total-summary', 'SiteGroupExamResultReportController@getSiteGroupPrimaryResultPassFailTotalSummary')->name('get-site-group-primary-result-pass-fail-total-summary');
            Route::get('get-site-group-primary-result-pass-fail-total-summary-pdf', 'SiteGroupExamResultReportController@getSiteGroupPrimaryResultPassFailTotalSummaryPdf')->name('get-site-group-primary-result-pass-fail-total-summary-Pdf');
            Route::post('get-site-group-primary-result-grading-total-summary', 'SiteGroupExamResultReportController@getSiteGroupPrimaryResultGradingTotalSummary')->name('get-site-group-primary-result-grading-total-summary');

            Route::get('get-site-group-primary-result-pass-pail-student-summary-pdf', 'SiteGroupExamResultReportController@getSiteGroupPrimaryResultPassFailStudentSummaryPdf')->name('get-site-group-primary-result-pass-pail-student-summary-pdf');
            Route::get('get-site-group-primary-result-grading-total-summary-pdf', 'SiteGroupExamResultReportController@getSiteGroupPrimaryResultGradingTotalSummaryPdf')->name('get-site-group-primary-result-grading-total-summary-pdf');

            Route::get('get-site-group-primary-result-simple-tabulation', 'SiteGroupExamResultReportController@getSiteGroupPrimaryResultSimpleTabulation')->name('get-site-group-primary-result-simple-tabulation');
            Route::post('get-site-group-primary-result-total-statistics', 'SiteGroupExamResultReportController@getSiteGroupPrimaryResultTotalStatistics')->name('get-site-group-primary-result-total-statistics');
            Route::post('get-site-group-primary-result-subject-pass-fail-statistics', 'SiteGroupExamResultReportController@getSiteGroupPrimaryResultSubjectPassFailStatistics')->name('get-site-group-primary-result-subject-pass-fail-statistics');
            Route::post('get-site-group-primary-result-merit-list-statistics-pdf-download', 'SiteGroupExamResultReportController@getSiteGroupPrimaryResultMeritListStatisticsPdfDownload')->name('get-site-group-primary-result-merit-list-statistics-pdf-download');
            Route::post('get-site-group-primary-result-merit-list-statistics', 'SiteGroupExamResultReportController@getSiteGroupPrimaryResultMeritListStatistics')->name('get-site-group-primary-result-merit-list-statistics');

            Route::get('get-site-group-primary-result-review-list-statistics-pdf', 'SiteGroupExamResultReportController@getSiteGroupPrimaryResultReviewSummaryPdf')->name('get-site-group-primary-result-review-list-statistics-pdf');
            Route::post('get-site-group-primary-result-review-list-statistics', 'SiteGroupExamResultReportController@getSiteGroupPrimaryResultReviewListStatistics')->name('get-site-group-primary-result-review-list-statistics');
            Route::post('get-grade-setting', 'SiteGroupExamResultReportController@getGradeSetting')->name('get-grade-setting');

            Route::post('get-site-group-primary-result-merit-list', 'SiteGroupExamResultReportController@getSiteGroupPrimaryResultMeritList')->name('get-site-group-primary-result-merit-list');
            Route::post('get-site-group-exam-subject-absent-pass-fail-student-list', 'SiteGroupExamResultReportController@getSiteGroupExamSubjectAbsentPassFailStudentList')->name('get-site-group-exam-subject-absent-pass-fail-student-list');
            Route::post('get-site-group-fixed-count-failed-student-list', 'SiteGroupExamResultReportController@getSiteGroupFixedCountFailedStudentList')->name('get-site-group-fixed-count-failed-student-list');

        //====exam result permission====
            Route::get('site-group-exam-result-permission-master', 'SiteGroupExamResultPermissionController@index')->name('site-group-exam-result-permission-master');
            Route::post('get-site-group-result-type-list-for-permission', 'SiteGroupExamResultPermissionController@getStieGroupBaseResultTypeListForPermission')->name('get-site-group-result-type-list-for-permission');
            Route::post('get-site-group-site-exam-result-permission-list', 'SiteGroupExamResultPermissionController@getStieGroupSiteExamResultPermissionList')->name('get-site-group-site-exam-result-permission-list');
            Route::post('update-site-group-site-exam-result-permission', 'SiteGroupExamResultPermissionController@updateStieGroupSiteExamResultPermission')->name('update-site-group-site-exam-result-permission');

        });


        Route::group(['namespace' => 'Settings', 'prefix' => 'academic-settings'], function () {
            Route::get('site-group-site-academic-settings', 'SiteGroupSiteAcademicSettingController@index')->name('site-group-site-academic-settings');
            Route::get('site-group-academic-settings', 'SiteGroupSiteAcademicSettingController@getSiteGroupAcademicSettings')->name('site-group-academic-settings');
            Route::get('get-site-group-site-list', 'SiteGroupSiteAcademicSettingController@getGroupSiteList')->name('get-site-group-site-list');
            Route::get('get-site-group-select-academic-settings', 'SiteGroupSiteAcademicSettingController@getSiteGroupSelectedAcademicSettings')->name('get-site-group-select-academic-settings');
            Route::post('site-group-academic-settings-store', 'SiteGroupSiteAcademicSettingController@siteGroupAcademicSettingStore')->name('site-group-academic-settings-store');

            Route::get('site-group-shift-class-group-section-setting', 'SiteGroupAcademicSessionSectionClassSettingsController@index')->name('site-group-shift-class-group-section-setting');
            Route::get('get-site-group-shift-version-year', 'SiteGroupAcademicSessionSectionClassSettingsController@getSiteGroupAcademicGroupBaseShiftYearVersion')->name('get-site-group-shift-version-year');
            Route::get('site-group-shift-class-group-section-setting-list/{shift_id}/{year_id}/{version_id}', 'SiteGroupAcademicSessionSectionClassSettingsController@getSiteGroupShiftClassGroupSectionList')->name('site-group-shift-class-group-section-setting-list');
            Route::post('site-group-shift-class-group-section-setting-insert-update', 'SiteGroupAcademicSessionSectionClassSettingsController@siteGroupInsertUpdateShiftClassGroupSectionList')->name('site-group-shift-class-group-section-setting-insert-update');

            Route::get('get-site-group-get-academic-class-list-for-set-session', 'SiteGroupAcademicSessionSectionClassSettingsController@getSiteGroupAcademicClassListForSetSession')->name('get-site-group-get-academic-class-list-for-set-session');
            Route::post('create-site-group-class-session-serial-setting', 'SiteGroupAcademicSessionSectionClassSettingsController@createSiteGroupClassSessionSerial')->name('create-site-group-class-session-serial-setting');

            Route::get('site-group-subject-settings', 'SiteGroupAcademicSubjectSettingController@index')->name('site-group-subject-settings');
            Route::get('site-group-subject-group-condition-setting-get-year-dept-class-list', 'SiteGroupAcademicSubjectSettingController@getSiteGroupYearDepartmentClassList')->name('site-group-subject-group-condition-setting-get-year-dept-class-list');
            Route::get('get-site-group-year-version-base-department-class/{version_id}/{year_id}', 'SiteGroupAcademicSubjectSettingController@getSiteGroupYearVersionBaseDepartmentClass')->name('get-site-group-year-version-base-department-class');
            Route::get('site-group-subject-group-condition-setting-list/{class_id}/{department_id}/{year_id}', 'SiteGroupAcademicSubjectSettingController@getSiteGroupSubjectConditionList')->name('site-group-subject-group-condition-setting-list');
            Route::get('get-site-group-year-version-class-base-group/{version_id}/{year_id}/{shift_id}/{class_id}', 'SiteGroupAcademicSubjectSettingController@getSiteGroupYearVersionClassBaseGroup')->name('get-site-group-year-version-class-base-group');

            Route::post('site-group-subject-group-condition-setting-add', 'SiteGroupAcademicSubjectSettingController@siteGroupSubjectConditionAdd')->name('site-group-subject-group-condition-setting-add');


            Route::post('get-site-group-group-section-base-subject-limit', 'SiteGroupAcademicSubjectSettingController@getSiteGroupGroupSectionBaseSubjectLimit')->name('get-site-group-group-section-base-subject-limit');
            Route::post('create-site-group-subject-condition-limit', 'SiteGroupAcademicSubjectSettingController@createSiteGroupSubjectConditionLimit')->name('create-site-group-subject-condition-limit');

        });


        Route::group(['namespace' => 'Quiz'], function () {
          Route::group(['prefix' => 'quiz-question'], function () {


         //   Route::get('site-group-subject-settings', 'SiteGroupQuestionController@index')->name('site-group-subject-settings');



            Route::get('form', 'SiteGroupQuestionController@index')->name('site-group-quiz-question-form');
            Route::post('add', 'SiteGroupQuestionController@siteGroupQuizQuestionAdd')->name('site-group-quiz-question-add');
            Route::get('topic-list', 'SiteGroupQuestionController@getSiteGroupQuizQuestionTopicList')->name('site-group-quiz-question-topic-list');
            // Route::get('exam-type-list', 'SiteQuizQuestionController@getSiteExamTypeList')->name('site-exam-question-exam-type-list2');
            // Route::get('list-view', 'SiteQuizQuestionController@getSiteExamQuestionListView')->name('site-exam-question-list-view2');


            Route::get('list', 'SiteGroupQuestionController@index')->name('site-group-quiz-question-list');

            Route::post('list-with-pagination', 'SiteGroupQuestionController@getQuizQuestionListWithPagination')->name('site-group-quiz-question-list-with-pagination');

            Route::get('edit/{id}', 'SiteGroupQuestionController@editQuestionView')->name('site-group-quiz-question-edit');

            // Route::post('slelected-question-pdf', 'SiteQuizQuestionController@getSiteExamQuestionSelectedQuestionPDF')->name('site-exam-question-slelected-question-pdf2');
            // Route::get('slelected-question-pdf-show/{data}', 'SiteQuizQuestionController@getSiteExamQuestionSelectedQuestionPDFShow')->name('site-exam-question-slelected-question-pdf-show2');
            Route::get('get-quiz-question-details/{id}', 'SiteGroupQuestionController@getQuestionDetailsForEdit')->name('site-exam-question-details-by-id2');
            Route::post('update', 'SiteGroupQuestionController@updateQuestion')->name('site-group-quiz-question-update');
            Route::post('upate-question-status', 'SiteGroupQuestionController@updateQuestionStatus')->name('site-exam-question-update-status2');
            Route::post('upate-question-status-massly', 'SiteGroupQuestionController@updateQuestionStatusMassly')->name('site-exam-question-update-status-massly2');
            Route::post('delete/{id}', 'SiteGroupQuestionController@deleteQuestion')->name('site-exam-question-delete2');

        });
        Route::group(['prefix' => 'quiz-declare'], function () {

            Route::get('master', 'SiteGroupQuizDeclareController@index')->name('site-group-quiz-declare-master');
            Route::get('group-site-list', 'SiteGroupQuizDeclareController@groupSiteList')->name('group-site-list');
            Route::get('active-quiz-list', 'SiteGroupQuizDeclareController@getActiveQuizList')->name('get-active-quiz-list-for-site-group');
            Route::post('update-group-base-new-quiz-declare', 'SiteGroupQuizDeclareController@createGroupBaseNewQuizDeclare')->name('update-group-base-new-quiz-declare');
            Route::post('check-quiz-for-edit', 'SiteGroupQuizDeclareController@checkGroupQuizForEdit')->name('check-group-quiz-for-edit');
            Route::post('quiz-declare-list', 'SiteGroupQuizDeclareController@siteGroupQuizDeclareList')->name('site-group-quiz-declare-list');
            Route::get('delete-site-group-base-quiz-declare/{quiz_declare_id}', 'SiteGroupQuizDeclareController@siteGroupBasedeclareQuizDelete')->name('delete-site-group-base-quiz-declare');
            Route::post('get-site-group-active-quiz-list', 'SiteGroupQuizRoomController@getSiteGroupActiveQuizList')->name('get-site-group-active-quiz-list');

            Route::post('get-site-group-quiz-event-students-info', 'SiteGroupQuizRoomController@getSiteGroupQuizEventStudentsInfo')->name('get-site-group-quiz-event-students-info');
            Route::get('get-present-site-group-students-count/{quiz_declare_id}', 'SiteGroupQuizRoomController@getSiteGroupPresentStudents')->name('get-present-site-group-students-count');


        });
        Route::group(['prefix' => 'quiz-question-declare'], function () {
            Route::post('question-topic-list', 'SiteGroupBaseQuizQuestionDeclareController@getSubjectTopicList')->name('site-group-question-topic-list');
            Route::post('site-question-list-for-site-group-quiz-question-declare', 'SiteGroupBaseQuizQuestionDeclareController@getQuestionList')->name('site-question-list-for-site-group-quiz-question-declare');
            Route::post('create-site-group-student-quiz-question-declare', 'SiteGroupBaseQuizQuestionDeclareController@createSiteGroupQuizQuestionDeclare')->name('create-site-group-student-quiz-question-declare');
            Route::post('get-selected-quiz-declare-settings', 'SiteGroupBaseQuizQuestionDeclareController@selectedQuizInfo')->name('get-selected-quiz-declare-settings');

        });
        Route::group(['prefix' => 'quiz'], function () {

        //   Route::get('/', 'SiteGroupQuizDeclareController@index')->name('quiz-index');

            Route::post('add', 'SiteGroupQuizDeclareController@createQuiz')->name('site-group-quiz-declare-add');

            Route::get('quiz-list', 'SiteGroupQuizDeclareController@getQuizlist')->name('site-group-quiz-list');
            Route::post('quiz-edit', 'SiteGroupQuizDeclareController@quizEdit')->name('site-group-quiz-edit');

            Route::post('quiz-update', 'SiteGroupQuizDeclareController@quizUpate')->name('site-group-quiz-update');
            Route::post('quiz-delete', 'SiteGroupQuizDeclareController@quizDelete')->name('site-group-quiz-delete');

        });

        Route::group(['prefix' => 'quiz-report'], function () {
              Route::get('/master', 'SiteGroupQuizReportController@index')->name('get-site-group-quiz-report-master');
            // // Route::post('add', 'QuizQuestionController@quizQuestionAdd')->name('quiz-question-add');
              Route::get('quiz-list', 'SiteGroupQuizReportController@quizListForReport')->name('site-group-quiz-list-for-report');
              Route::post('list', 'SiteGroupQuizReportController@getSiteQuizReport')->name('site-group-get-site-quiz-report-list');

        });
    });
    Route::group(['namespace' => 'Attendence'], function () {

        Route::get('get-group-site-list', 'SiteGroupEmployeeAttedenceController@getGroupSiteList')->name('get-group-site-list');
        Route::get('get-academic-group-for-site-group', 'SiteGroupEmployeeAttedenceController@AcademicGroupSiteGroup')->name('get-academic-group-for-site-group');
        Route::get('get-academic-class-year-for-site-group', 'SiteGroupEmployeeAttedenceController@AcademicClassYearForSiteGroup')->name('get-academic-class-year-for-site-group');
        // employee attendence start
        Route::get('group-wise-employee-attedence', 'SiteGroupEmployeeAttedenceController@index')->name('site-group-wise-employee-attedence');
        Route::get('group-wise-student-attedence', 'SiteGroupEmployeeAttedenceController@index')->name('site-group-wise-student-attedence');
        Route::post('site-get-group-employee-attendence', 'SiteGroupEmployeeAttedenceController@siteGroupEmployeeAttendence')->name('site-group-employee-attendence');
        Route::get('single-site-get-group-employee-attendence', 'SiteGroupEmployeeAttedenceController@SinglesiteGroupEmployeeAttendence')->name('single-site-get-group-employee-attendence');
        Route::get('single-site-get-group-employee-attendence-pdf-download', 'SiteGroupEmployeeAttedenceController@SinglesiteGroupEmployeeAttendencePdfDonwload')->name('single-site-get-group-employee-attendence-pdf-download');

        Route::post('site-get-group-employee-attendence-date-wise-for-graph', 'SiteGroupEmployeeAttedenceController@siteGroupEmployeeAttendenceForGraph')->name('site-get-group-employee-attendence-date-wise-for-graph');
        Route::get('site-get-group-employee-attendence-month-wise-for-graph', 'SiteGroupEmployeeAttedenceController@siteGroupEmployeeAttendenceMonthWiseForGraph')->name('site-get-group-employee-attendence-month-wise-for-graph');
        // employee attendence end

        // student attendence start
        Route::post('site-get-group-student-attendence', 'SiteGroupStudentAttedenceController@siteGroupStudentAttendence')->name('site-group-student-attendence');
        Route::post('single-site-get-group-student-attendence', 'SiteGroupStudentAttedenceController@siteGroupSingleSiteAttendence')->name('single-site-get-group-student-attendence');
        Route::post('single-site-get-group-student-attendence-pdf-download', 'SiteGroupStudentAttedenceController@siteGroupSingleSiteAttendencePdfDownload')->name('single-site-get-group-student-attendence-pdf-download');

    });

    Route::group(['namespace' => 'Student'], function () {
        Route::get('site-group-wise-student-list', 'SiteGroupStudentListController@index')->name('site-group-wise-student-list');
        Route::post('site-group-wise-student-list-count', 'SiteGroupStudentListController@SiteGroupwiseStudentListCount')->name('site-group-wise-student-list-count');
        Route::post('site-group-wise-student-list-count-pdf-download', 'SiteGroupStudentListController@SiteGroupwiseStudentListCountPdfDownload')->name('site-group-wise-student-list-count-pdf-download');
        Route::post('site-group-wise-religion-student-list-count', 'SiteGroupStudentListController@SiteGroupwiseReligionStudentListCount')->name('site-group-wise-religion-student-list-count');
        Route::post('single-site-group-wise-student-list', 'SiteGroupStudentListController@SingleSiteGroupwiseStudentList')->name('single-site-group-wise-student-list');
        Route::post('site-group-wise-student-subject-list-count', 'SiteGroupStudentSubjectListController@SiteGroupwiseStudentSubjectListCount')->name('site-group-wise-student-subject-list-count');
        Route::post('site-group-wise-student-optional-subject-list-count', 'SiteGroupStudentSubjectListController@SiteGroupwiseStudentOptionalSubjectListCount')->name('site-group-wise-student-optional-subject-list-count');
        Route::post('site-group-wise-student-riligion-subject-list-count', 'SiteGroupStudentSubjectListController@SiteGroupwiseStudentRiligionSubjectListCount')->name('site-group-wise-student-riligion-subject-list-count');




    });
    Route::group(['namespace' => 'Employee'], function () {
        Route::get('open-group-report/{name}', 'SiteGroupEmployeeListController@openReport')->name('open-pdf-file-storage-for-group');
        Route::get('site-group-wise-employee-list', 'SiteGroupEmployeeListController@index')->name('site-group-wise-employee-list');
        Route::get('site-group-wise-employee-subject-list-pdf-download', 'SiteGroupEmployeeListController@siteGroupWiseEmployeeSubjectListPdfDownload')->name('site-group-wise-employee-subject-list-pdf-download');
        Route::get('site-group-wise-employee-assign-duty-list-pdf-download', 'SiteGroupEmployeeListController@siteGroupWiseEmployeeAssignDutyListPdfDownload')->name('site-group-wise-employee-assign-duty-list-pdf-download');
        Route::post('site-group-wise-employee-assign-duty-list-count', 'SiteGroupEmployeeListController@siteGroupWiseEmployeeAssignDutyListCount')->name('site-group-wise-employee-assign-duty-list-count');
        Route::post('single-site-get-group-employee', 'SiteGroupEmployeeListController@GetEmployeeList')->name('site-get-group-employee-retirement-list');
        Route::post('single-site-get-group-employee-transfer-list', 'SiteGroupEmployeeListController@GetEmployeetransferList')->name('single-site-get-group-employee-transfer-list');
        Route::post('single-site-transfer-group-employee', 'SiteGroupEmployeeListController@TransferEmployeeFromGroup')->name('single-site-transfer-group-employee');
        Route::post('site-group-wise-employee-list-count', 'SiteGroupEmployeeListController@siteGroupWiseEmployeeListCount')->name('site-group-wise-employee-list-count');
        Route::post('single-site-group-wise-employee-list', 'SiteGroupEmployeeListController@SingleSiteGroupWiseEmployeeList')->name('single-site-group-wise-employee-list');
        Route::post('site-group-wise-subject', 'SiteGroupEmployeeSubjectCountController@siteGroupWiseSubject')->name('site-Group-Wise-Subject');
        Route::post('site-group-wise-employee-subject-list-count', 'SiteGroupEmployeeSubjectCountController@SiteGroupWiseEmployeeSubjectListCount')->name('site-group-wise-employee-subject-list-count');
        Route::post('single-site-group-wise-employee-subject-list', 'SiteGroupEmployeeSubjectCountController@SingleSiteGroupWiseEmployeeSubjectList')->name('single-site-group-wise-employee-subject-list');


        Route::get('site-group-wise-employee-retirement-list', 'SiteGroupEmployeeListController@index')->name('site-group-wise-employee-retirement-list');
        Route::post('site-get-group-employee-retirement-list', 'SiteGroupEmployeeListController@GetEmployeeRetirementList')->name('site-get-group-employee-retirement-list');

    });
});


