<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Employees Payroll PDF</title>
    <style>
        body {
            font-family: Arial, sans-serif;
        }

        h2 {
            text-align: center;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        th,
        td {
            border: 1px solid #ddd;
            padding: 4px;
            text-align: center;
            font-size: 10px;
        }

        .bg-info {
            background-color: #5bc0de;
            color: #fff;
        }

        .error {
            text-align: center;
            color: red;
        }

        .total-row {
            color: red;
            font-weight: bold;
        }

        .badge-success {
            color: #468847;
        }

        .badge-danger {
            color: #f11c00;
        }

        .checkbox-container {
            display: flex;
            align-items: center;
            gap: 5px;
        }

        .checkbox-container input[type="checkbox"] {
            width: 14px;
            height: 14px;
        }

        .status-label {
            font-size: 14px;
            font-weight: bold;
        }
    </style>
</head>

<body>
    <div>



        <div class="headerco" style="width: 100%; ">
            <table style="width: 100%; border: none;">
                <tr>
                    <td style="width: 10%; text-align: left; border: none;">
                        <img style="text-align: center; padding-top: 0px;" width="70px" height="70px;"
                            src="<?php echo public_path(Session::get('LOGO_PATH')); ?>">
                    </td>
                    <td style="width: 100%; text-align:center;  padding-right:100px;  border: none;">
                        <span style="font-size:20px"><?php echo e($site_info->site_name); ?></span> <br>
                        <?php echo e($site_info->address); ?>

                    </td>
                </tr>
            </table>
        </div>
        <div class="header-right" style="text-align: center">
            <strong>Student Fine Report </strong> <br>

            <span><span>Class: </span><?php echo e($class_name); ?></span>
            <span><span>, Group: </span><?php echo e($Class_group_name); ?></span>
        </div>


        <div class="new" style="text-align: right">

            <?php if($year && $month): ?>
            <span style="color: red"><?php echo e(\Carbon\Carbon::createFromFormat('m', str_pad($month, 2, '0', STR_PAD_LEFT))->format('F') . ' - ' . $year); ?></span>


            <?php endif; ?>
        </div>
        <?php if($StudentFineType->fine_type_name_key == 'attendance'): ?>
            <table>
                <thead>
                    <tr style="background-color: 	#c4c4c3">
                        <th>Sl</th>
                        <th>Student Name</th>
                        <th>Roll</th>
                        <th>Days of a month </th>
                        <th>Present </th>
                        <th>Absent</th>
                        <th>Fine Amount (TK)</th>
                        <th>Payment status</th>
                        <th>Remark</th>

                    </tr>
                </thead>

                <tbody>
                    <?php if($Students->isEmpty()): ?>
                        <tr>
                            <td colspan="12" class="text-center error">
                                No data!
                            </td>
                        </tr>
                    <?php else: ?>
                        <?php $__currentLoopData = $Students; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $student): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e($index + 1); ?></td>
                                <td><?php echo e($student['full_name']); ?></td>
                                <td><?php echo e($student['student_full_roll_number']); ?></td>
                                <td><?php echo e($student['TotlaDayOfMonth']); ?></td>
                                <td><?php echo e($student['total_present']); ?></td>
                                <td><?php echo e($student['total_absent']); ?></td>
                                <td><?php echo e($student['total_fine']); ?></td>

                                <td>

                                    <div class="checkbox-container">
                                        <input type="checkbox">
                                        <span class="status-label">Paid</span>
                                    </div>
                                    <div class="checkbox-container">
                                        <input type="checkbox">
                                        <span class="status-label">Unpaid</span>
                                    </div>

                                </td>
                                <td style="width: 20%"></td>



                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                    <?php endif; ?>
                </tbody>
            </table>
        <?php else: ?>
            <table>
                <thead>
                    <tr style="background-color: 	#c4c4c3">
                        <th>#</th>
                        <th>Name</th>
                        <th>Fine Type</th>
                        <th>Waiver</th>
                        <th>Total Fine</th>
                        <th>action</th>
                        <th>Issue Date</th>
                    </tr>
                </thead>

                <tbody>
                    
                </tbody>
            </table>
        <?php endif; ?>

    </div>
</body>

</html>
<?php /**PATH C:\laragon\www\EduWorldErp\resources\views/default/site/student/fine/site-student-month-fine-pdf.blade.php ENDPATH**/ ?>