<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title><?php echo e($title_view); ?></title>

    <style type="text/css">
        * {
            font-family: Verdana, Arial, sans-serif;
        }

        table {
            font-size: x-small;
            width: 100%;
            border-collapse: collapse;
        }

        tfoot tr td {
            font-weight: bold;
            font-size: x-small;
        }

        .amount-right {
            text-align: right;
        }

        .gray {
            background-color: lightgray;
        }

        .table-header {
            background-color: #b3dbff;
            font-weight: bold;
        }

        .text-center {
            text-align: center;
        }

        .text-right {
            text-align: right;
        }

        table.payment-history-table th,
        table.payment-history-table td {
            border: 1px solid #ddd;
            padding: 5px;
        }

        ,
        td {
            border: 1px solid #ddd;
            padding: 5px;
        }

        table>th,
        td {
            border: none;
            padding: 5px;
        }
    </style>
</head>

<body>

    <div>
        <?php echo $__env->make('default.site.layout.pdf-header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

        <table class="payment-history-table" style="margin-top: 20px;">
            <thead>
                <tr class="table-header">
                    <th>#</th>
                    <th>Name</th>
                    <th class="text-center">Username</th>
                    <th class="text-center">Roll</th>
                    <th>Voucher No</th>
                    
                    <th class="text-center">Payment Date</th>
                    <th class="text-center">Payment Time</th>
                    <th class="text-right">Total Amount</th>
                </tr>
            </thead>

            <tbody>
                <?php $__currentLoopData = $payment_history_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="text-center"><?php echo e($index + 1); ?></td>
                        <td><?php echo e($payment['studentHistory']->full_name ?? 'N/A'); ?></td>
                        <td class="text-center"><?php echo e($payment['studentHistory']->username ?? 'N/A'); ?></td>

                        <td class="text-center"><?php echo e($payment['studentHistory']->student_full_roll_number ?? 'N/A'); ?></td>
                        <td class="text-center"><?php echo e($payment['voucher_no']); ?></td>
                        
                        <td class="text-center"><?php echo e($payment['payment_date']); ?> </td>
                        <td class="text-center"> <?php echo e($payment['created_at']); ?></td>
                        <td class="text-right"><?php echo e(number_format($payment['paid_amount'], 2)); ?></td>
                    </tr>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td colspan="7" class="text-right">Total Amount</td>
                        <td class="text-right"><b><?php echo e(number_format($total_amount, 2)); ?></b></td>
                    </tr>
                <?php if($payment_history_list->isEmpty()): ?>
                    <tr>
                        <td colspan="8" class="text-center" style="color: red">No data found</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

    <style>
        @page  {
            size: A4;
            margin: 10px;
        }

        body {
            margin: 10px;
        }
    </style>

</body>

</html>
<?php /**PATH C:\laragon\www\EduWorldErp\resources\views/default/admin/site/student-fee/report/student-online-payment.blade.php ENDPATH**/ ?>