<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Examination Routine</title>
    <style>
       body {
            font-family: Arial, sans-serif;
            margin: 0;
            padding: 0;
        }
        .page {
            border: 2px solid #000; /* Page border */
            padding: 10px;
            margin: 10px;
        }
        .header {
            text-align: center;
            margin-bottom: 10px;
        }
        .header h1 {
            font-size: 24px;
            margin: 0;
        }
        .header p {
            font-size: 14px;
            margin: 0;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        table th, table td {
            border: 1px solid #000;
            padding: 8px;
            text-align: center;
            font-size: 12px;
        }
        table th {
            background-color: #f4f4f4;
        }
        .footer {
            margin-top: 20px;
            text-align: right;
            font-size: 12px;
        }
    </style>
</head>
<body>
    <div class="page">
     <table width="100%;" border="0">
        <tr>
            <td style="width: 20%; border:none">
                <img style="float: left" src="<?php echo e(public_path($site->site_logo)); ?>" width="60" height="55">
            </td>
            <td style="width: 60%; border:none">
                <div class="header">
                    <h2>Examination Routine</h2>
                    <h3><?php echo e($site->site_name); ?></h3>
                    <h4><?php echo e($class_name); ?>-<?php echo e($shift_name); ?></h4>
                    <h4><?php echo e($examination_name); ?>- <?php echo e($year_name); ?>

                    </h4>
                </div>
            <td style="width: 20%; text-align: right; font-size: 10px; border:none">
                <b>Printed :</b> <?php echo e(date('d M Y h:i:s A',time())); ?>

            </td>
        </tr>
    </table>

    <table>
        <thead>
            <tr>
                <th style="width:10px">#</th>
                <th>Subject</th>
                <th>Exam Type</th>
                <th>Date</th>
                <th>Time</th>
                <th style="width:20px">Duration (min)</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $subject_array; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $kesse=>$subject): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php $__currentLoopData = $subject['exam_type_array']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key1=>$exam_type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <?php if($key1==0): ?>
                    <td rowspan="<?php echo e(count($subject['exam_type_array'])); ?>"><?php echo e($kesse+1); ?></td>
                    <td rowspan="<?php echo e(count($subject['exam_type_array'])); ?>"><?php echo e($subject['subject_name']); ?></td>
                    <?php endif; ?>
                    <td><?php echo e($exam_type['exam_type_name']); ?></td>
                    <td><?php echo e($exam_type['exam_start_date']); ?></td>
                    <td><?php echo e($exam_type['exam_start_time']); ?> - <?php echo e($exam_type['exam_end_time']); ?></td>
                    <td><?php echo e($exam_type['exam_duration']); ?></td>
                </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
           
        </tbody>
        <tfoot>
            
        </tfoot>
    </table>
</div>

</body>
</html>
<?php /**PATH C:\laragon\www\EduWorldErp\resources\views/default/admin/site/exam/report/exam-routine-pdf.blade.php ENDPATH**/ ?>