<!doctype html>
<html lang="en">

<head>
    <meta charset="UTF-8">

    <style>
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        th,
        td {
            border: 1px solid #ddd;
            padding: 4px;
            text-align: center;
            font-size: 10px;
        }

        body {
            width: 800pt;
            height: 550pt;
            margin: 0;
            padding: 5px;
        }

        .site-name {
            text-align: center;
            font-size: 16px;
            font-weight: bold;
            margin-top: 10px;
        }
    </style>

</head>

<body>

    <div class="headerco" style="width: 100%;">
        <table style="width: 100%; border: none;">
            <tr>
                <td style="width: 10%; text-align: left; border: none;">
                    <img width="70" height="70" src="<?php echo public_path('uploads/' . $SiteGroupInfo['group_logo']); ?>">
                </td>
                <td style="width: 90%; text-align: center; border: none;">
                    <span style="font-size: 25px"><?php echo e($SiteGroupInfo['name']); ?></span> <br>
                    <span style="font-size: 15px">Education Department</span>
                </td>
            </tr>
        </table>
    </div>

    <?php
        // সাইট অনুযায়ী গ্রুপিং (একই পেজে)
        $sites = [];
        foreach($emp_array as $emp) {
            $site = $emp['site_name'] ?? 'Unknown Site';
            $sites[$site][] = $emp;
        }
    ?>

    <?php $__currentLoopData = $sites; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $siteName => $employees): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="site-name"><?php echo e($siteName); ?></div>

        <table>
            <thead>
                <tr>
                    <th>Serial</th>
                    <th>Name</th>
                    <th>Designation</th>
                </tr>
            </thead>
            <tbody>
                <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $emp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e($key + 1); ?></td>
                        <td><?php echo e($emp['full_name']); ?></td>
                        <td><?php echo e($emp['designation']); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
        </table>
        <!-- page-break সরানো হয়েছে -->
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

</body>

<style>
    @page  {
        size: A4 landscape;
        margin: 10px;
    }
</style>

</html>
<?php /**PATH C:\laragon\www\EduWorldErp\resources\views/default/admin/site_group/site-employees-designation-wise-pdf.blade.php ENDPATH**/ ?>